/*
 * Decompiled with CFR 0.152.
 */
package facs;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;

public final class Representation
implements Serializable {
    private static final long serialVersionUID = 4649L;
    public static final int TEST_PATTERN = -1;
    public static final int HISTOGRAM_X = 1;
    public static final int HISTOGRAM_Y = 2;
    public static final int DOT_PLOT = 11;
    public static final int DENSITY_DOT_PLOT = 12;
    public static final int SHADOW_PLOT = 13;
    public static final int CONTOUR_PLOT = 14;
    public static final int SHADED_CONTOUR_PLOT = 15;
    public static final int DENSITY_PLOT = 16;
    public static final int HISTOGRAM_OVERLAY = 101;
    public static final int NO_STATISTIC = -1;
    public static final int MEAN = 1;
    public static final int MEDIAN = 2;
    public static final int STANDARD_DEVIATION = 3;
    public static final int VARIANCE = 4;
    public static final int MINIMUM = 5;
    public static final int MAXIMUM = 6;
    public static final int PERCENT = 8;
    public static final int EVENT_COUNT = 9;
    public static final int CHANNEL_RANGE = 10;
    public static final int GEOMETRIC_MEAN = 11;
    public static final int STATISTIC_1D_X = 101;
    public static final int STATISTIC_1D_Y = 102;
    public static final int STATISTIC_2D = 103;
    public static final int DEFAULT_COLOR_SET = -1;
    public static final int EN_FUEGO = 1;
    public static final int CHILL_OUT = 2;
    public static final int RAINBOW = 3;
    public static final int GREYSCALE = 4;
    public static final int PALE_FIRE = 5;
    public static final int GREEN_TO_RED = 6;
    public static final int BLUE_TO_YELLOW = 7;
    public static final int RYAN1 = 101;
    public static final int WILLIAM1 = 102;
    public static final int NIKESH1 = 103;
    public static final int MARK1 = 104;
    public static final int PETER1 = 105;
    public static final int ALL_REGIONS = -3;
    public static final int UNGATED = -2;
    public static final int GATE_SET = -1;
    private final int id;
    private String name;
    private boolean panelDefaultRepresentationP;
    private int channelCount;
    private String filename;
    private int compensationID;
    private ArrayList gateSetIDs;
    private int xChannel;
    private int yChannel;
    private int plotType;
    private int statType;
    private int colorSet;
    private boolean blackBackgroundP;
    private boolean annotationP;
    private boolean scaleLabelP;
    private boolean scaleTickP;
    private boolean axisLabelP;
    private boolean longLabelP;
    private int axisBins;
    private double smoothing;
    private double aspectRatio;
    private double contourPercent;
    private double contourStartPercent;
    private int populationType;
    private int eventCount;
    private int dotSize;
    private int[] scaleFlags;
    private String[] scaleArguments;
    private double[] minimums;
    private double[] maximums;
    private ArrayList regions;

    public Representation(int id, String name, int channelCount) {
        this.id = id;
        this.name = name;
        this.panelDefaultRepresentationP = false;
        this.channelCount = channelCount <= 0 ? 0 : channelCount;
        this.filename = null;
        this.compensationID = -1;
        this.gateSetIDs = new ArrayList();
        this.xChannel = -1;
        if (this.channelCount > 0) {
            this.xChannel = 0;
        }
        this.yChannel = -1;
        if (this.channelCount > 0) {
            this.yChannel = 0;
        }
        this.plotType = -1;
        this.statType = -1;
        this.colorSet = -1;
        this.blackBackgroundP = false;
        this.annotationP = false;
        this.scaleLabelP = false;
        this.scaleTickP = false;
        this.axisLabelP = false;
        this.longLabelP = false;
        this.axisBins = 256;
        this.smoothing = 1.0;
        this.aspectRatio = 1.0;
        this.contourPercent = 10.0;
        this.contourStartPercent = 10.0;
        this.populationType = -1;
        this.eventCount = 10000;
        this.dotSize = 1;
        this.scaleFlags = new int[this.channelCount];
        this.scaleArguments = new String[this.channelCount];
        this.minimums = new double[this.channelCount];
        this.maximums = new double[this.channelCount];
        for (int i = 0; i < this.channelCount; ++i) {
            this.scaleFlags[i] = 1;
            this.minimums[i] = Double.NaN;
            this.maximums[i] = Double.NaN;
        }
        this.regions = new ArrayList();
    }

    public int getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Representation) {
            Representation rep = (Representation)obj;
            return this.id == rep.id;
        }
        return false;
    }

    public int hashCode() {
        return this.getID();
    }

    public boolean isPanelDefaultRepresentation() {
        return this.panelDefaultRepresentationP;
    }

    public void setPanelDefaultRepresentation(boolean panelDefaultRepresentationP) {
        this.panelDefaultRepresentationP = panelDefaultRepresentationP;
    }

    public int getChannelCount() {
        return this.channelCount;
    }

    public void setChannelCount(int channelCount) {
        if (channelCount <= this.channelCount) {
            return;
        }
        int[] scaleFlagArray = new int[this.channelCount];
        System.arraycopy(this.scaleFlags, 0, scaleFlagArray, 0, this.channelCount);
        String[] scaleArgumentArray = new String[this.channelCount];
        System.arraycopy(this.scaleArguments, 0, scaleArgumentArray, 0, this.channelCount);
        double[] minimumArray = new double[this.channelCount];
        System.arraycopy(this.minimums, 0, minimumArray, 0, this.channelCount);
        double[] maximumArray = new double[this.channelCount];
        System.arraycopy(this.maximums, 0, maximumArray, 0, this.channelCount);
        this.scaleFlags = new int[channelCount];
        this.scaleArguments = new String[channelCount];
        this.minimums = new double[channelCount];
        this.maximums = new double[channelCount];
        for (int i = 0; i < channelCount; ++i) {
            this.scaleFlags[i] = 1;
            this.minimums[i] = Double.NaN;
            this.maximums[i] = Double.NaN;
        }
        System.arraycopy(scaleFlagArray, 0, this.scaleFlags, 0, this.channelCount);
        System.arraycopy(scaleArgumentArray, 0, this.scaleArguments, 0, this.channelCount);
        System.arraycopy(minimumArray, 0, this.minimums, 0, this.channelCount);
        System.arraycopy(maximumArray, 0, this.maximums, 0, this.channelCount);
        this.channelCount = channelCount;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public int getCompensationID() {
        return this.compensationID;
    }

    public void setCompensationID(int id) {
        this.compensationID = id;
    }

    public int[] getGateSetIDs() {
        int size = this.gateSetIDs.size();
        int[] idArray = new int[size];
        for (int i = 0; i < size; ++i) {
            idArray[i] = -1;
            Object obj = this.gateSetIDs.get(i);
            if (!(obj instanceof Integer)) continue;
            Integer id = (Integer)obj;
            idArray[i] = id;
        }
        return idArray;
    }

    public boolean containsGateSetID(int id) {
        if (id < 1) {
            return false;
        }
        Integer newID = new Integer(id);
        return this.gateSetIDs.contains(newID);
    }

    public boolean addGateSetID(int id) {
        if (id < 1) {
            return false;
        }
        Integer newID = new Integer(id);
        if (this.gateSetIDs.contains(newID)) {
            return false;
        }
        return this.gateSetIDs.add(newID);
    }

    public boolean removeGateSetID(int id) {
        if (id < 1) {
            return false;
        }
        Integer newID = new Integer(id);
        return this.gateSetIDs.remove(newID);
    }

    public void clearGateSetIDs() {
        this.gateSetIDs.clear();
    }

    public int getXChannel() {
        return this.xChannel;
    }

    public void setXChannel(int channel) {
        if (channel >= -1 && channel < this.channelCount) {
            this.xChannel = channel;
        }
    }

    public int getYChannel() {
        return this.yChannel;
    }

    public void setYChannel(int channel) {
        if (channel >= -1 && channel < this.channelCount) {
            this.yChannel = channel;
        }
    }

    public int getPlotType() {
        return this.plotType;
    }

    public void setPlotType(int type) {
        switch (type) {
            case 1: {
                this.plotType = 1;
                return;
            }
            case 2: {
                this.plotType = 2;
                return;
            }
            case 11: {
                this.plotType = 11;
                return;
            }
            case 12: {
                this.plotType = 12;
                return;
            }
            case 13: {
                this.plotType = 13;
                return;
            }
            case 14: {
                this.plotType = 14;
                return;
            }
            case 15: {
                this.plotType = 15;
                return;
            }
            case 16: {
                this.plotType = 16;
                return;
            }
            case 101: {
                this.plotType = 101;
                return;
            }
        }
        this.plotType = -1;
    }

    public int getStatisticType() {
        return this.statType;
    }

    public void setStatisticType(int type) {
        switch (type) {
            case 1: {
                this.statType = 1;
                return;
            }
            case 2: {
                this.statType = 2;
                return;
            }
            case 3: {
                this.statType = 3;
                return;
            }
            case 4: {
                this.statType = 4;
                return;
            }
            case 5: {
                this.statType = 5;
                return;
            }
            case 6: {
                this.statType = 6;
                return;
            }
            case 8: {
                this.statType = 8;
                return;
            }
            case 9: {
                this.statType = 9;
                return;
            }
            case 10: {
                this.statType = 10;
                return;
            }
            case 11: {
                this.statType = 11;
                return;
            }
            case 101: {
                this.statType = 101;
                return;
            }
            case 102: {
                this.statType = 102;
                return;
            }
            case 103: {
                this.statType = 103;
                return;
            }
        }
        this.statType = -1;
    }

    public int getColorSet() {
        return this.colorSet;
    }

    public void setColorSet(int colorSet) {
        switch (colorSet) {
            case 1: {
                this.colorSet = 1;
                return;
            }
            case 2: {
                this.colorSet = 2;
                return;
            }
            case 3: {
                this.colorSet = 3;
                return;
            }
            case 4: {
                this.colorSet = 4;
                return;
            }
            case 5: {
                this.colorSet = 5;
                return;
            }
            case 6: {
                this.colorSet = 6;
                return;
            }
            case 7: {
                this.colorSet = 7;
                return;
            }
            case 101: {
                this.colorSet = 101;
                return;
            }
            case 102: {
                this.colorSet = 102;
                return;
            }
            case 103: {
                this.colorSet = 103;
                return;
            }
            case 104: {
                this.colorSet = 104;
                return;
            }
            case 105: {
                this.colorSet = 105;
                return;
            }
        }
        this.colorSet = -1;
    }

    public boolean useBlackBackground() {
        return this.blackBackgroundP;
    }

    public void setBlackBackground(boolean blackBackgroundP) {
        this.blackBackgroundP = blackBackgroundP;
    }

    public boolean drawAnnotation() {
        return this.annotationP;
    }

    public void setAnnotation(boolean annotationP) {
        this.annotationP = annotationP;
    }

    public boolean drawScaleLabel() {
        return this.scaleLabelP;
    }

    public void setScaleLabel(boolean scaleLabelP) {
        this.scaleLabelP = scaleLabelP;
    }

    public boolean drawScaleTick() {
        return this.scaleTickP;
    }

    public void setScaleTick(boolean scaleTickP) {
        this.scaleTickP = scaleTickP;
    }

    public boolean drawAxisLabel() {
        return this.axisLabelP;
    }

    public void setAxisLabel(boolean axisLabelP) {
        this.axisLabelP = axisLabelP;
    }

    public boolean useLongLabel() {
        return this.longLabelP;
    }

    public void setLongLabel(boolean longLabelP) {
        this.longLabelP = longLabelP;
    }

    public int getAxisBins() {
        return this.axisBins;
    }

    public void setAxisBins(int bins) {
        if (bins >= 0) {
            this.axisBins = bins;
        }
    }

    public double getSmoothing() {
        return this.smoothing;
    }

    public void setSmoothing(double smoothing) {
        this.smoothing = smoothing;
    }

    public double getAspectRatio() {
        return this.aspectRatio;
    }

    public void setAspectRatio(double aspectRatio) {
        this.aspectRatio = aspectRatio;
    }

    public double getContourPercent() {
        return this.contourPercent;
    }

    public void setContourPercent(double contourPercent) {
        this.contourPercent = contourPercent;
    }

    public double getContourStartPercent() {
        return this.contourStartPercent;
    }

    public void setContourStartPercent(double contourStartPercent) {
        this.contourStartPercent = contourStartPercent;
    }

    public int getPopulationType() {
        return this.populationType;
    }

    public void setPopulationType(int type) {
        this.populationType = type;
    }

    public int getEventCount() {
        return this.eventCount;
    }

    public int getDotSize() {
        return this.dotSize;
    }

    public void setDotSize(int dotSize) {
        this.dotSize = dotSize;
    }

    public void setEventCount(int eventCount) {
        this.eventCount = eventCount;
    }

    public int getScaleFlag(int channel) {
        if (channel < 0 || channel >= this.channelCount) {
            return 1;
        }
        return this.scaleFlags[channel];
    }

    public void setScaleFlag(int channel, int flag) {
        if (channel >= 0 && channel < this.channelCount) {
            this.scaleFlags[channel] = flag;
        }
    }

    public String getScaleArgumentString(int channel) {
        if (channel < 0 || channel >= this.channelCount) {
            return null;
        }
        return this.scaleArguments[channel];
    }

    public void setScaleArgumentString(int channel, String arg) {
        if (channel >= 0 && channel < this.channelCount) {
            this.scaleArguments[channel] = arg;
        }
    }

    public double getMinimum(int channel) {
        if (channel < 0 || channel >= this.channelCount) {
            return Double.NaN;
        }
        return this.minimums[channel];
    }

    public void setMinimum(int channel, double min) {
        if (channel >= 0 && channel < this.channelCount) {
            this.minimums[channel] = min;
        }
    }

    public double getMaximum(int channel) {
        if (channel < 0 || channel >= this.channelCount) {
            return Double.NaN;
        }
        return this.maximums[channel];
    }

    public void setMaximum(int channel, double max) {
        if (channel >= 0 && channel < this.channelCount) {
            this.maximums[channel] = max;
        }
    }

    public Region addRegion(int id) {
        if (id < -3) {
            return null;
        }
        Region region = this.getRegion(id);
        if (region == null) {
            region = new Region(id);
            this.regions.add(region);
            if (this.regions.size() > 1) {
                Collections.sort(this.regions);
            }
        }
        return region;
    }

    public boolean removeRegion(int id) {
        if (id < -3) {
            return false;
        }
        int n = this.regions.size();
        for (int i = 0; i < n; ++i) {
            Region region;
            Object object = this.regions.get(i);
            if (!(object instanceof Region) || (region = (Region)object).getID() != id) continue;
            return this.regions.remove(region);
        }
        return false;
    }

    public Region getRegion(int id) {
        if (id < -3) {
            return null;
        }
        int n = this.regions.size();
        for (int i = 0; i < n; ++i) {
            Region region;
            Object object = this.regions.get(i);
            if (!(object instanceof Region) || (region = (Region)object).getID() != id) continue;
            return region;
        }
        return null;
    }

    public Region[] getRegions() {
        Region[] regionArray = new Region[this.regions.size()];
        this.regions.toArray(regionArray);
        return regionArray;
    }

    public void clearRegions() {
        this.regions.clear();
    }

    public String getParameters() {
        return this.getParameters(this.xChannel, this.yChannel, this.populationType, this.eventCount);
    }

    public String getParameters(int xChannel, int yChannel) {
        return this.getParameters(xChannel, yChannel, this.populationType, this.eventCount);
    }

    public String getParameters(int xChannel, int yChannel, int populationType, int eventCount) {
        if (populationType <= 0) {
            populationType = this.populationType;
            eventCount = this.eventCount;
        }
        if (xChannel < -1 || xChannel >= this.channelCount) {
            xChannel = this.xChannel;
        }
        if (yChannel < -1 || yChannel >= this.channelCount) {
            yChannel = this.yChannel;
        }
        StringBuffer parameters = new StringBuffer();
        parameters.append("xChannel=");
        parameters.append(xChannel);
        parameters.append("&yChannel=");
        parameters.append(yChannel);
        parameters.append("&plotType=");
        if (yChannel == -1) {
            parameters.append(1);
        } else if (xChannel == -1) {
            parameters.append(2);
        } else {
            parameters.append(this.plotType);
        }
        parameters.append("&statType=");
        parameters.append(this.statType);
        parameters.append("&colorSet=");
        parameters.append(this.colorSet);
        parameters.append("&blackBackground=");
        parameters.append(this.blackBackgroundP);
        parameters.append("&annotation=");
        parameters.append(this.annotationP);
        if (this.annotationP) {
            parameters.append("&scaleLabel=");
            parameters.append(this.scaleLabelP);
            parameters.append("&scaleTick=");
            parameters.append(this.scaleTickP);
            parameters.append("&axisLabel=");
            parameters.append(this.axisLabelP);
            parameters.append("&longLabel=");
            parameters.append(this.longLabelP);
        }
        parameters.append("&axisBins=");
        parameters.append(this.axisBins);
        parameters.append("&smoothing=");
        parameters.append(this.smoothing);
        parameters.append("&aspectRatio=");
        parameters.append(this.aspectRatio);
        parameters.append("&contourPercent=");
        parameters.append(this.contourPercent);
        parameters.append("&contourStartPercent=");
        parameters.append(this.contourStartPercent);
        if (populationType > 0) {
            parameters.append("&populationType=");
            parameters.append(populationType);
            parameters.append("&eventCount=");
            parameters.append(eventCount);
        }
        parameters.append("&channelCount=");
        parameters.append(this.channelCount);
        for (int i = 0; i < this.channelCount; ++i) {
            parameters.append("&scale");
            parameters.append(i);
            parameters.append("=");
            parameters.append(this.scaleFlags[i]);
            if (this.scaleArguments[i] != null) {
                parameters.append("&scaleArg");
                parameters.append(i);
                parameters.append("=");
                parameters.append(Representation.encode(this.scaleArguments[i]));
            }
            if (!Double.isNaN(this.minimums[i])) {
                parameters.append("&min");
                parameters.append(i);
                parameters.append("=");
                parameters.append(this.minimums[i]);
            }
            if (Double.isNaN(this.maximums[i])) continue;
            parameters.append("&max");
            parameters.append(i);
            parameters.append("=");
            parameters.append(this.maximums[i]);
        }
        if (this.annotationP) {
            Region[] regionArray = this.getRegions();
            for (int i = 0; i < regionArray.length; ++i) {
                parameters.append(regionArray[i].encode());
            }
        }
        return parameters.toString();
    }

    public String encode() {
        return this.encode(this.filename, this.compensationID, this.getGateSetIDs(), this.xChannel, this.yChannel, this.populationType, this.eventCount);
    }

    public String encode(String filename, int compensationID, int[] gateSetIDs, int xChannel, int yChannel) {
        return this.encode(filename, compensationID, gateSetIDs, xChannel, yChannel, this.populationType, this.eventCount);
    }

    public String encode(String filename, int compensationID, int[] gateSetIDs, int xChannel, int yChannel, int populationType, int eventCount) {
        StringBuffer parameters = new StringBuffer();
        parameters.append("filename=");
        parameters.append(Representation.encode(filename));
        parameters.append("&compensationID=");
        parameters.append(compensationID);
        if (gateSetIDs != null) {
            for (int i = 0; i < gateSetIDs.length; ++i) {
                parameters.append("&gateSetID=");
                parameters.append(gateSetIDs[i]);
            }
        }
        parameters.append("&");
        parameters.append(this.getParameters(xChannel, yChannel, populationType, eventCount));
        return parameters.toString();
    }

    public String encode(int experimentID, String filename, int compensationID, int[] gateSetIDs) {
        return this.encode(experimentID, filename, compensationID, gateSetIDs, this.xChannel, this.yChannel, this.populationType, this.eventCount);
    }

    public String encode(int experimentID, String filename, int compensationID, int[] gateSetIDs, int xChannel, int yChannel) {
        return this.encode(experimentID, filename, compensationID, gateSetIDs, xChannel, yChannel, this.populationType, this.eventCount);
    }

    public String encode(int experimentID, String filename, int compensationID, int[] gateSetIDs, int xChannel, int yChannel, int populationType, int eventCount) {
        StringBuffer parameters = new StringBuffer();
        parameters.append("experimentID=");
        parameters.append(experimentID);
        parameters.append("&");
        parameters.append(this.encode(filename, compensationID, gateSetIDs, xChannel, yChannel, populationType, eventCount));
        return parameters.toString();
    }

    public static Representation getRepresentation(int id, String name, int channelCount, String filename, int compensationID, int[] gateSetIDs, int xChannel, int yChannel, int plotType, int statType, int colorSet, boolean blackBackgroundP, boolean annotationP, boolean scaleLabelP, boolean scaleTickP, boolean axisLabelP, boolean longLabelP, int axisBins, double smoothing, double aspectRatio, double contourPercent, double contourStartPercent) {
        Representation rep = new Representation(id, name, channelCount);
        rep.setFilename(filename);
        rep.setCompensationID(compensationID);
        if (gateSetIDs != null) {
            for (int i = 0; i < gateSetIDs.length; ++i) {
                rep.addGateSetID(gateSetIDs[i]);
            }
        }
        rep.setXChannel(xChannel);
        rep.setYChannel(yChannel);
        rep.setPlotType(plotType);
        rep.setStatisticType(statType);
        rep.setColorSet(colorSet);
        rep.setBlackBackground(blackBackgroundP);
        rep.setAnnotation(annotationP);
        rep.setScaleLabel(scaleLabelP);
        rep.setScaleTick(scaleTickP);
        rep.setAxisLabel(axisLabelP);
        rep.setLongLabel(longLabelP);
        rep.setAxisBins(axisBins);
        rep.setSmoothing(smoothing);
        rep.setAspectRatio(aspectRatio);
        rep.setContourPercent(contourPercent);
        rep.setContourStartPercent(contourStartPercent);
        return rep;
    }

    public static Representation getRepresentation(int id, String name, int channelCount, String filename, int compensationID, int[] gateSetIDs, int xChannel, int yChannel, int plotType, int statType, int colorSet, boolean blackBackgroundP, boolean annotationP, boolean scaleLabelP, boolean scaleTickP, boolean axisLabelP, boolean longLabelP, int axisBins, double smoothing, double aspectRatio, double contourPercent, double contourStartPercent, int populationType, int eventCount) {
        Representation rep = Representation.getRepresentation(id, name, channelCount, filename, compensationID, gateSetIDs, xChannel, yChannel, plotType, statType, colorSet, blackBackgroundP, annotationP, scaleLabelP, scaleTickP, axisLabelP, longLabelP, axisBins, smoothing, aspectRatio, contourPercent, contourStartPercent);
        rep.setPopulationType(populationType);
        rep.setEventCount(eventCount);
        return rep;
    }

    private static String encode(String str) {
        if (str == null) {
            return null;
        }
        try {
            return URLEncoder.encode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            return null;
        }
    }

    public static void main(String[] args) {
        int i;
        Representation rep = new Representation(1, "Representation 1", 8);
        System.out.println(rep.encode());
        rep.setCompensationID(3);
        rep.setScaleArgumentString(0, "Zero");
        rep.setScaleArgumentString(1, "One");
        rep.setScaleArgumentString(2, "Two");
        rep.setScaleArgumentString(3, "blah");
        rep.setMinimum(6, 10.0);
        System.out.println(rep.encode());
        System.out.println("Scale parameters before resizing");
        System.out.println("---");
        for (i = 0; i < 8; ++i) {
            System.out.println("Channel " + i + ": ");
            System.out.println("\tScale flag: " + rep.getScaleFlag(i));
            System.out.println("\tScale argument string: " + rep.getScaleArgumentString(i));
            System.out.println("\tMinimum: " + rep.getMinimum(i));
            System.out.println("\tMaximum: " + rep.getMaximum(i));
        }
        rep.setChannelCount(11);
        rep.setScaleFlag(9, 3);
        rep.setScaleArgumentString(9, "Nine");
        rep.setScaleArgumentString(10, "Ten");
        System.out.println("Scale parameters after resizing");
        System.out.println("---");
        for (i = 0; i < 11; ++i) {
            System.out.println("Channel " + i + ": ");
            System.out.println("\tScale flag: " + rep.getScaleFlag(i));
            System.out.println("\tScale argument string: " + rep.getScaleArgumentString(i));
            System.out.println("\tMinimum: " + rep.getMinimum(i));
            System.out.println("\tMaximum: " + rep.getMaximum(i));
        }
    }

    public static final class Region
    implements Comparable,
    Serializable {
        private final int id;
        private boolean showP;
        private boolean drawP;
        private boolean showLabelP;
        private boolean showEventCountP;
        private boolean showMeanP;
        private boolean showMedianP;
        private boolean showPercentP;

        private Region(int id) {
            this.id = id;
            this.showP = false;
            this.drawP = false;
            this.showLabelP = false;
            this.showEventCountP = false;
            this.showMeanP = false;
            this.showMedianP = false;
            this.showPercentP = false;
        }

        public int getID() {
            return this.id;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj instanceof Region) {
                Region region = (Region)obj;
                return this.id == region.id;
            }
            return false;
        }

        public int hashCode() {
            return this.getID();
        }

        public boolean isShown() {
            return this.showP;
        }

        public void setShown(boolean showP) {
            this.showP = showP;
        }

        public boolean isDrawn() {
            return this.drawP;
        }

        public void setDrawn(boolean drawP) {
            this.drawP = drawP;
        }

        public boolean isLabelShown() {
            return this.showLabelP;
        }

        public void setLabelShown(boolean showLabelP) {
            this.showLabelP = showLabelP;
        }

        public boolean isEventCountShown() {
            return this.showEventCountP;
        }

        public void setEventCountShown(boolean showEventCountP) {
            this.showEventCountP = showEventCountP;
        }

        public boolean isMeanShown() {
            return this.showMeanP;
        }

        public void setMeanShown(boolean showMeanP) {
            this.showMeanP = showMeanP;
        }

        public boolean isMedianShown() {
            return this.showMedianP;
        }

        public void setMedianShown(boolean showMedianP) {
            this.showMedianP = showMedianP;
        }

        public boolean isPercentShown() {
            return this.showPercentP;
        }

        public void setPercentShown(boolean showPercentP) {
            this.showPercentP = showPercentP;
        }

        public String encode() {
            StringBuffer parameters = new StringBuffer();
            if (this.showP) {
                if (this.drawP) {
                    parameters.append("&region");
                    parameters.append(this.id);
                    parameters.append("=region");
                }
                if (this.showLabelP) {
                    parameters.append("&region");
                    parameters.append(this.id);
                    parameters.append("=label");
                }
                if (this.showEventCountP) {
                    parameters.append("&region");
                    parameters.append(this.id);
                    parameters.append("=eventCount");
                }
                if (this.showMeanP) {
                    parameters.append("&region");
                    parameters.append(this.id);
                    parameters.append("=mean");
                }
                if (this.showMedianP) {
                    parameters.append("&region");
                    parameters.append(this.id);
                    parameters.append("=median");
                }
                if (this.showPercentP) {
                    parameters.append("&region");
                    parameters.append(this.id);
                    parameters.append("=percent");
                }
            } else {
                parameters.append("&region");
                parameters.append(this.id);
                parameters.append("=none");
            }
            return parameters.toString();
        }

        public int compareTo(Object obj) {
            if (obj == null) {
                throw new NullPointerException("The object is null.");
            }
            if (obj instanceof Region) {
                Region region = (Region)obj;
                if (this.id < region.id) {
                    return -1;
                }
                if (this.id == region.id) {
                    return 0;
                }
                return 1;
            }
            throw new ClassCastException("The object is not a region.");
        }
    }
}

