/*
 * Decompiled with CFR 0.152.
 */
package cytospade.ui;

import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.actions.LoadNetworkTask;
import cytoscape.data.SelectEvent;
import cytoscape.data.SelectEventListener;
import cytoscape.logger.CyLogger;
import cytoscape.view.CyNetworkView;
import cytoscape.visual.GlobalAppearanceCalculator;
import cytoscape.visual.NodeAppearanceCalculator;
import cytoscape.visual.NodeShape;
import cytoscape.visual.VisualMappingManager;
import cytoscape.visual.VisualPropertyDependency;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.VisualStyle;
import cytospade.CytoSpade;
import cytospade.FCSOperations;
import cytospade.SpadeContext;
import cytospade.SpadeController;
import cytospade.VisualMapping;
import cytospade.WorkflowWizard;
import cytospade.WorkflowWizardPanels;
import cytospade.ui.NodeContextMenu;
import cytospade.ui.NodeContextMenuItems;
import cytospade.ui.ScatterPlotPanel;
import ding.view.NodeContextMenuListener;
import giny.model.GraphPerspective;
import giny.model.Node;
import giny.view.NodeView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.SwingWorker;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.layout.GroupLayout;

public class SpadeAnalysisPanel
extends JPanel {
    private SpadeContext spadeCxt;
    private VisualMapping visualMapping;
    private FCSOperations fcsOperations;
    private ScatterPlotPanel scatterPlot;
    private ReentrantLock panelLock;
    DefaultTableModel TValTableModel = new DefaultTableModel(new Object[][]{{null, null}}, new String[]{"Parameter", "T value"});
    private JButton CloseButton;
    private ButtonGroup ColorSymmetryRadioGroup;
    private JComboBox ColoringSelect;
    private JLabel FilenameLabel;
    private JComboBox FilenameSelect;
    private JLabel NumberEventsLabel;
    private JButton PDFButton;
    private JTable PValTable;
    private JScrollPane PValTableContainer;
    private JScrollPane PlotContainer;
    private JComboBox RangeSelect;
    private JButton TableButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JRadioButton radioAsymmetric;
    private JRadioButton radioSymmetric;

    public SpadeAnalysisPanel(SpadeContext spadeCxt) {
        this.spadeCxt = spadeCxt;
        File[] boundaryFiles = spadeCxt.getPath().listFiles(new FilenameFilter(){

            public boolean accept(File f, String name) {
                return name.matches("global_boundaries.table");
            }
        });
        if (boundaryFiles.length == 1) {
            this.visualMapping = new VisualMapping(boundaryFiles[0]);
        } else if (boundaryFiles.length == 0) {
            this.visualMapping = new VisualMapping();
        } else {
            JOptionPane.showMessageDialog(null, "Error: Found more than one global_boundaries.table file.");
            return;
        }
        this.panelLock = new ReentrantLock();
        this.initComponents();
    }

    private void initComponents() {
        this.ColorSymmetryRadioGroup = new ButtonGroup();
        FileItem[] files = new FileItem[this.spadeCxt.getFCSFiles().length];
        int i = 0;
        for (File fi : this.spadeCxt.getFCSFiles()) {
            files[i] = new FileItem(fi);
            ++i;
        }
        this.FilenameSelect = new JComboBox<FileItem>(files);
        this.FilenameLabel = new JLabel();
        this.ColoringSelect = new JComboBox();
        this.jLabel1 = new JLabel();
        this.RangeSelect = new JComboBox();
        this.jLabel2 = new JLabel();
        this.PDFButton = new JButton();
        this.TableButton = new JButton();
        this.CloseButton = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jSeparator2 = new JSeparator();
        this.NumberEventsLabel = new JLabel();
        this.PlotContainer = new JScrollPane();
        this.PValTableContainer = new JScrollPane();
        this.PValTable = new JTable();
        this.radioSymmetric = new JRadioButton();
        this.radioAsymmetric = new JRadioButton();
        this.setMinimumSize(new Dimension(390, 680));
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(440, 720));
        this.FilenameSelect.setBackground(null);
        this.FilenameSelect.setMaximumRowCount(20);
        this.FilenameSelect.setSelectedIndex(-1);
        this.FilenameSelect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpadeAnalysisPanel.this.FilenameSelectActionPerformed(evt);
            }
        });
        this.FilenameLabel.setLabelFor(this.FilenameSelect);
        this.FilenameLabel.setText("File");
        this.ColoringSelect.setMaximumRowCount(20);
        this.ColoringSelect.setToolTipText("Select attribute for coloring nodes");
        this.ColoringSelect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpadeAnalysisPanel.this.ColoringSelectActionPerformed(evt);
            }
        });
        this.jLabel1.setLabelFor(this.ColoringSelect);
        this.jLabel1.setText("Coloring Attribute");
        this.RangeSelect.setMaximumRowCount(20);
        this.RangeSelect.setModel(this.RangeSelectModel());
        this.RangeSelect.setToolTipText("Global sets colorscale using min/max across all files, local uses min/max of selected file");
        this.RangeSelect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpadeAnalysisPanel.this.RangeSelectActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Coloring Range");
        this.PDFButton.setText("Produce PDFs");
        this.PDFButton.setToolTipText("Generate PDF tree plots using current Cytoscape layout");
        this.PDFButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpadeAnalysisPanel.this.PDFButtonActionPerformed(evt);
            }
        });
        this.TableButton.setText("Produce Tables");
        this.TableButton.setToolTipText("Generate CSV tables for each attributes with columns for all files");
        this.TableButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpadeAnalysisPanel.this.TableButtonActionPerformed(evt);
            }
        });
        this.CloseButton.setText("Close SPADE");
        this.CloseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpadeAnalysisPanel.this.CloseButtonActionPerformed(evt);
            }
        });
        this.jSeparator1.setForeground(new Color(0, 0, 0));
        this.jSeparator2.setForeground(new Color(0, 0, 0));
        this.NumberEventsLabel.setText("Select a file to display network and bi-axial plot");
        this.PlotContainer.setMaximumSize(new Dimension(Short.MAX_VALUE, 400));
        this.PlotContainer.setMinimumSize(new Dimension(365, 430));
        this.PValTableContainer.setPreferredSize(new Dimension(365, 402));
        this.PValTable.setAutoCreateRowSorter(true);
        this.PValTable.setModel(this.TValTableModel);
        this.PValTable.setCellSelectionEnabled(true);
        this.PValTableContainer.setViewportView(this.PValTable);
        this.ColorSymmetryRadioGroup.add(this.radioSymmetric);
        this.radioSymmetric.setSelected(true);
        this.radioSymmetric.setText("Symmetric");
        this.radioSymmetric.setToolTipText("Center coloring range about 0");
        this.radioSymmetric.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpadeAnalysisPanel.this.radioSymmetricActionPerformed(evt);
            }
        });
        this.ColorSymmetryRadioGroup.add(this.radioAsymmetric);
        this.radioAsymmetric.setText("Asymmetric");
        this.radioAsymmetric.setToolTipText("Center coloring range about mean of attribute range");
        this.radioAsymmetric.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpadeAnalysisPanel.this.radioAsymmetricActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.PValTableContainer, -1, 370, Short.MAX_VALUE).add((Component)this.jSeparator2, -1, 370, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jSeparator1, -2, -1, -2).addPreferredGap(0).add((Component)this.PDFButton).addPreferredGap(0).add((Component)this.TableButton).addPreferredGap(0, 61, Short.MAX_VALUE).add((Component)this.CloseButton)).add((Component)this.FilenameLabel).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.jLabel2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.RangeSelect, 0, 119, Short.MAX_VALUE).addPreferredGap(1).add((Component)this.radioSymmetric).addPreferredGap(0).add((Component)this.radioAsymmetric)).add((Component)this.ColoringSelect, 0, 281, Short.MAX_VALUE).add((Component)this.FilenameSelect, 0, 281, Short.MAX_VALUE))).add(2, (Component)this.NumberEventsLabel, -1, 370, Short.MAX_VALUE).add((Component)this.PlotContainer, -1, 370, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.FilenameLabel).add((Component)this.FilenameSelect, -2, -1, -2)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.ColoringSelect, -2, -1, -2)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.RangeSelect, -2, -1, -2).add((Component)this.jLabel2).add((Component)this.radioAsymmetric).add((Component)this.radioSymmetric)).add(8, 8, 8).add((Component)this.jSeparator2, -2, -1, -2).addPreferredGap(0).add((Component)this.NumberEventsLabel).addPreferredGap(0).add((Component)this.PlotContainer, -2, 430, -2).addPreferredGap(0).add((Component)this.PValTableContainer, -1, 129, Short.MAX_VALUE).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jSeparator1, -2, -1, -2).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.PDFButton).add((Component)this.TableButton).add((Component)this.CloseButton))).addContainerGap()));
    }

    private void FilenameSelectActionPerformed(ActionEvent evt) {
        CyNetwork network = Cytoscape.getCurrentNetwork();
        if (!network.nodesList().isEmpty()) {
            this.saveMetadata(true);
        }
        if (this.FilenameSelect.getSelectedIndex() >= 0) {
            LoadNetworkTask.loadFile((File)this.spadeCxt.getGMLFiles()[this.FilenameSelect.getSelectedIndex()], (boolean)true);
            File[] layoutFiles = this.spadeCxt.getPath().listFiles(new FilenameFilter(){

                public boolean accept(File f, String name) {
                    return name.matches("layout.table");
                }
            });
            if (layoutFiles.length == 1) {
                this.loadMetadata(layoutFiles[0]);
            } else if (layoutFiles.length > 1) {
                JOptionPane.showMessageDialog(null, "Error: Found more than one layout.table file");
                return;
            }
            Cytoscape.getCurrentNetworkView().addNodeContextMenuListener((NodeContextMenuListener)new NodeContextMenu());
            Cytoscape.getCurrentNetworkView().fitContent();
            VisualMapping.populateNumericAttributeComboBox(this.ColoringSelect);
            this.ColoringSelect.setSelectedIndex(0);
            this.RangeSelect.setSelectedIndex(0);
            this.spadeCxt.setNormalizationKind((SpadeContext.NormalizationKind)((Object)this.RangeSelect.getSelectedItem()));
            this.updateNodeSizeAndColors();
            this.NumberEventsLabel.setText("Select a file to display network and bi-axial plot");
            this.TValTableModel.setRowCount(0);
            this.TValTableModel.addRow(new Object[]{"Select nodes...", ""});
            this.PlotContainer.setViewportView(null);
            this.scatterPlot = null;
            this.fcsOperations = null;
            try {
                this.fcsOperations = new FCSOperations(((FileItem)this.FilenameSelect.getSelectedItem()).getFCSFile());
                this.scatterPlot = new ScatterPlotPanel(this.fcsOperations);
                this.PlotContainer.setViewportView(this.scatterPlot);
                Cytoscape.getCurrentNetwork().addSelectEventListener((SelectEventListener)new HandleSelect());
                this.updateFCSConsumers();
            }
            catch (FileNotFoundException ex) {
                JOptionPane.showMessageDialog(null, "FCS file not found: " + ((FileItem)this.FilenameSelect.getSelectedItem()).getFCSpath());
                return;
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(null, "Error reading FCS file: " + this.FilenameSelect.getSelectedItem());
                return;
            }
        }
    }

    private void ColoringSelectActionPerformed(ActionEvent evt) {
        this.updateNodeSizeAndColors();
        Cytoscape.getCurrentNetworkView().redrawGraph(true, true);
    }

    private void RangeSelectActionPerformed(ActionEvent evt) {
        this.spadeCxt.setNormalizationKind((SpadeContext.NormalizationKind)((Object)this.RangeSelect.getSelectedItem()));
        this.updateNodeSizeAndColors();
        Cytoscape.getCurrentNetworkView().redrawGraph(true, true);
    }

    private void TableButtonActionPerformed(ActionEvent evt) {
        try {
            this.spadeCxt.authorMakePivot("pivotSPADE.R");
            SpadeController ctl = new SpadeController(this.spadeCxt.getPath(), "pivotSPADE.R");
            ctl.exec();
        }
        catch (IOException ex) {
            CyLogger.getLogger((String)CytoSpade.class.getName()).error(null, (Throwable)ex);
        }
    }

    private void PDFButtonActionPerformed(ActionEvent evt) {
        this.saveMetadata(false);
        WorkflowWizard wf = new WorkflowWizard((Frame)Cytoscape.getDesktop());
        WorkflowWizardPanels.GeneratePDFs genPDFs = new WorkflowWizardPanels.GeneratePDFs(this.spadeCxt);
        wf.registerWizardPanel("GENERATE_PDFS_PANEL", genPDFs);
        wf.setCurrentPanel("GENERATE_PDFS_PANEL");
        int showModalDialog = wf.showModalDialog();
        if (showModalDialog == 1) {
            return;
        }
        if (showModalDialog != 0) {
            JOptionPane.showMessageDialog(null, "Error occured in workflow wizard.");
        }
    }

    private void CloseButtonActionPerformed(ActionEvent evt) {
        int returnvalue = JOptionPane.showConfirmDialog(null, "Close SPADE plug-in?", "Confirm close", 2);
        if (returnvalue == 0) {
            this.saveMetadata(true);
            Cytoscape.getDesktop().getCytoPanel(7).remove(Cytoscape.getDesktop().getCytoPanel(7).getCytoPanelComponentCount() - 1);
            return;
        }
    }

    private void radioSymmetricActionPerformed(ActionEvent evt) {
        this.spadeCxt.setSymmetry(SpadeContext.SymmetryType.SYMMETRIC);
        this.updateNodeSizeAndColors();
        Cytoscape.getCurrentNetworkView().redrawGraph(true, true);
    }

    private void radioAsymmetricActionPerformed(ActionEvent evt) {
        this.spadeCxt.setSymmetry(SpadeContext.SymmetryType.ASYMMETRIC);
        this.updateNodeSizeAndColors();
        Cytoscape.getCurrentNetworkView().redrawGraph(true, true);
    }

    private DefaultComboBoxModel RangeSelectModel() {
        SpadeContext.NormalizationKind[] normalizationKindArray;
        if (this.visualMapping.globalRangeAvailable()) {
            SpadeContext.NormalizationKind[] normalizationKindArray2 = new SpadeContext.NormalizationKind[2];
            normalizationKindArray2[0] = SpadeContext.NormalizationKind.GLOBAL;
            normalizationKindArray = normalizationKindArray2;
            normalizationKindArray2[1] = SpadeContext.NormalizationKind.LOCAL;
        } else {
            SpadeContext.NormalizationKind[] normalizationKindArray3 = new SpadeContext.NormalizationKind[1];
            normalizationKindArray = normalizationKindArray3;
            normalizationKindArray3[0] = SpadeContext.NormalizationKind.LOCAL;
        }
        return new DefaultComboBoxModel<SpadeContext.NormalizationKind>(normalizationKindArray);
    }

    public void onExit() {
        this.saveMetadata(true);
    }

    private void updateFCSConsumers() {
        new SwingWorker<Integer, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Integer doInBackground() throws Exception {
                SpadeAnalysisPanel.this.fcsOperations.updateSelectedNodes();
                SpadeAnalysisPanel.this.scatterPlot.updatePlot();
                if (SpadeAnalysisPanel.this.fcsOperations.getSelectedNodesCount() == 0) {
                    SpadeAnalysisPanel.this.panelLock.lock();
                    try {
                        SpadeAnalysisPanel.this.NumberEventsLabel.setText("Displaying all " + SpadeAnalysisPanel.this.fcsOperations.getEventCount() + " events.");
                        SpadeAnalysisPanel.this.TValTableModel.setRowCount(0);
                        SpadeAnalysisPanel.this.TValTableModel.addRow(new Object[]{"Select nodes...", ""});
                    }
                    finally {
                        SpadeAnalysisPanel.this.panelLock.unlock();
                    }
                }
                if (SpadeAnalysisPanel.this.fcsOperations.getSelectedEventCount() >= 2) {
                    List<FCSOperations.AttributeValuePair> stats = SpadeAnalysisPanel.this.fcsOperations.computeTStat();
                    SpadeAnalysisPanel.this.TValTableModel.setRowCount(0);
                    for (int i = 0; i < stats.size(); ++i) {
                        SpadeAnalysisPanel.this.TValTableModel.addRow(new Object[]{stats.get((int)i).attribute, (double)Math.round(stats.get((int)i).value * 10.0) / 10.0});
                    }
                } else {
                    SpadeAnalysisPanel.this.TValTableModel.addRow(new Object[]{"Too few events.", ""});
                }
                SpadeAnalysisPanel.this.panelLock.lock();
                try {
                    SpadeAnalysisPanel.this.NumberEventsLabel.setText("Displaying " + SpadeAnalysisPanel.this.fcsOperations.getSelectedEventCount() + " of " + SpadeAnalysisPanel.this.fcsOperations.getEventCount() + " events.");
                }
                finally {
                    SpadeAnalysisPanel.this.panelLock.unlock();
                }
                return 0;
            }
        }.execute();
    }

    private void updateNodeSizeAndColors() {
        if (this.FilenameSelect.getSelectedIndex() < 0 || this.ColoringSelect.getSelectedIndex() < 0) {
            return;
        }
        try {
            this.visualMapping.setCurrentMarkersAndRangeKind("percenttotal", this.ColoringSelect.getSelectedItem().toString(), this.spadeCxt.getNormalizationKind(), this.spadeCxt.getSymmetry());
        }
        catch (IllegalArgumentException e) {
            JOptionPane.showMessageDialog(null, "Invalid choice of mapping parameters: " + e);
            return;
        }
        VisualMappingManager cyVMM = Cytoscape.getVisualMappingManager();
        try {
            VisualStyle spadeVS = cyVMM.getCalculatorCatalog().getVisualStyle("SPADEVisualStyle");
            if (spadeVS != null) {
                cyVMM.getCalculatorCatalog().removeVisualStyle("SPADEVisualStyle");
            }
            spadeVS = new VisualStyle("SPADEVisualStyle");
            GlobalAppearanceCalculator globalAppCalc = new GlobalAppearanceCalculator();
            globalAppCalc.setDefaultNodeSelectionColor(Color.MAGENTA);
            globalAppCalc.setDefaultEdgeSelectionColor(Color.MAGENTA);
            spadeVS.setGlobalAppearanceCalculator(globalAppCalc);
            NodeAppearanceCalculator nodeAppCalc = new NodeAppearanceCalculator(spadeVS.getDependency());
            nodeAppCalc.setCalculator(this.visualMapping.createColorCalculator());
            nodeAppCalc.setCalculator(this.visualMapping.createSizeCalculator());
            spadeVS.setNodeAppearanceCalculator(nodeAppCalc);
            VisualPropertyType.NODE_SHAPE.setDefault(spadeVS, (Object)NodeShape.ELLIPSE);
            VisualPropertyType.NODE_FILL_COLOR.setDefault(spadeVS, (Object)Color.LIGHT_GRAY);
            spadeVS.getDependency().set(VisualPropertyDependency.Definition.NODE_SIZE_LOCKED, true);
            cyVMM.getCalculatorCatalog().addVisualStyle(spadeVS);
            cyVMM.setVisualStyle(spadeVS);
            Cytoscape.getCurrentNetworkView().setVisualStyle(spadeVS.getName());
        }
        catch (RuntimeException ex) {
            CyLogger.getLogger().error("Error Visual Mapping", (Throwable)ex);
        }
    }

    private void saveMetadata(Boolean closeNetwork) {
        int id;
        CyNetwork currentNetwork = Cytoscape.getCurrentNetwork();
        CyNetworkView currentNetworkView = Cytoscape.getCurrentNetworkView();
        try {
            FileWriter nstream = new FileWriter(new File(this.spadeCxt.getPath(), "nested.txt").getAbsolutePath());
            BufferedWriter nout = new BufferedWriter(nstream);
            for (CyNode node : currentNetwork.nodesList()) {
                GraphPerspective nestedNetwork = node.getNestedNetwork();
                if (nestedNetwork == null) continue;
                for (CyNode nn : nestedNetwork.nodesList()) {
                    if (!NodeContextMenuItems.MakeNestedNetwork.isNested(nn)) continue;
                    id = Integer.parseInt(nn.getIdentifier());
                    nout.write(id + 1 + " ");
                }
                nout.write("\n");
                NodeContextMenuItems.UndoNestedNetwork.undoNestedNode(node);
            }
            nout.close();
        }
        catch (IOException ex) {
            CyLogger.getLogger().error("Error read layout.table", (Throwable)ex);
            return;
        }
        try {
            FileWriter lstream = new FileWriter(new File(this.spadeCxt.getPath(), "layout.table").getAbsolutePath());
            BufferedWriter lout = new BufferedWriter(lstream);
            int nodeCount = currentNetwork.getNodeCount();
            double[][] pos = new double[nodeCount][2];
            for (CyNode node : currentNetwork.nodesList()) {
                NodeView nodeView = currentNetworkView.getNodeView((Node)node);
                try {
                    id = Integer.parseInt(node.getIdentifier());
                }
                catch (NumberFormatException ex) {
                    continue;
                }
                if (id > nodeCount || nodeView == null) continue;
                pos[id][0] = nodeView.getXPosition();
                pos[id][1] = -1.0 * nodeView.getYPosition();
            }
            for (int i = 0; i < nodeCount; ++i) {
                lout.write(pos[i][0] + " " + pos[i][1] + "\n");
            }
            lout.close();
        }
        catch (IOException ex) {
            CyLogger.getLogger().error("Error read layout.table", (Throwable)ex);
            return;
        }
        if (closeNetwork.booleanValue()) {
            Cytoscape.destroyNetwork((CyNetwork)currentNetwork);
            Cytoscape.createNewSession();
        }
    }

    private void loadMetadata(File layoutFile) {
        CyNetwork currentNetwork = Cytoscape.getCurrentNetwork();
        CyNetworkView currentNetworkView = Cytoscape.getCurrentNetworkView();
        try {
            int nodeCount = currentNetwork.getNodeCount();
            double[][] pos = new double[currentNetwork.getNodeCount()][2];
            Scanner scanner = new Scanner(layoutFile);
            for (int curNode = 0; scanner.hasNextLine() && curNode < nodeCount; ++curNode) {
                pos[curNode][0] = scanner.nextDouble();
                pos[curNode][1] = -1.0 * scanner.nextDouble();
            }
            for (CyNode node : currentNetwork.nodesList()) {
                int id;
                try {
                    id = Integer.parseInt(node.getIdentifier());
                }
                catch (NumberFormatException ex) {
                    continue;
                }
                if (id > nodeCount) continue;
                NodeView nodeView = currentNetworkView.getNodeView((Node)node);
                nodeView.setXPosition(pos[id][0]);
                nodeView.setYPosition(pos[id][1]);
            }
        }
        catch (FileNotFoundException ex) {
            CyLogger.getLogger().error("Error read layout.table", (Throwable)ex);
            return;
        }
        try {
            Scanner scanner = new Scanner(new File(this.spadeCxt.getPath(), "nested.txt"));
            while (scanner.hasNextLine()) {
                HashSet<CyNode> nodes = new HashSet<CyNode>();
                for (String id : scanner.nextLine().split(" ")) {
                    try {
                        nodes.add(Cytoscape.getCyNode((String)Integer.toString(Integer.parseInt(id) - 1)));
                    }
                    catch (NumberFormatException ex) {
                        CyLogger.getLogger().error("Invalid entry in nested.txt", (Throwable)ex);
                    }
                }
                NodeContextMenuItems.MakeNestedNetwork.makeNestedNode(nodes);
            }
        }
        catch (FileNotFoundException ex) {
            CyLogger.getLogger().debug("Error reading nested.txt", (Throwable)ex);
            return;
        }
    }

    private String getOS() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.indexOf("win") >= 0) {
            return "windows";
        }
        if (os.indexOf("mac") >= 0) {
            return "macintosh";
        }
        if (os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0) {
            return "unix";
        }
        JOptionPane.showMessageDialog(null, "Invalid OS detection");
        return "error";
    }

    public class HandleSelect
    implements SelectEventListener {
        public void onSelectEvent(SelectEvent e) {
            SpadeAnalysisPanel.this.updateFCSConsumers();
        }
    }

    public class FileItem {
        private File f;

        public FileItem(File file) {
            this.f = file;
        }

        public String toString() {
            return this.f.getName().substring(0, this.f.getName().indexOf(".fcs"));
        }

        public String getFCSpath() {
            return this.f.getName();
        }

        public File getFCSFile() {
            return this.f;
        }
    }
}

