/*
 * Decompiled with CFR 0.152.
 */
package cytospade.ui;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.view.CyNetworkView;
import giny.model.Edge;
import giny.model.GraphPerspective;
import giny.model.Node;
import giny.view.NodeView;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JOptionPane;

public class NodeContextMenuItems {

    public static class UndoNestedNetwork
    implements ActionListener {
        public static final String LABEL = "Undo Nested Network";

        public static void undoNestedNode(CyNode node) {
            CyNetwork currentNetwork = Cytoscape.getCurrentNetwork();
            CyNetworkView currentView = Cytoscape.getCurrentNetworkView();
            CyAttributes nodeAttributes = Cytoscape.getNodeAttributes();
            GraphPerspective nestedNetwork = node.getNestedNetwork();
            if (nestedNetwork == null) {
                return;
            }
            NodeView nv = currentView.getNodeView((Node)node);
            for (CyNode nn : nestedNetwork.nodesList()) {
                Double off_y;
                if (!MakeNestedNetwork.isNested(nn)) continue;
                currentNetwork.restoreNode((Node)nn);
                nodeAttributes.deleteAttribute(nn.getIdentifier(), "is_nested");
                NodeView nnv = currentView.getNodeView((Node)nn);
                Double off_x = nodeAttributes.getDoubleAttribute(nn.getIdentifier(), "OffsetToNNX");
                if (off_x != null) {
                    nnv.setXPosition(off_x + nv.getXPosition());
                    nodeAttributes.deleteAttribute(nn.getIdentifier(), "OffsetToNNX");
                }
                if ((off_y = nodeAttributes.getDoubleAttribute(nn.getIdentifier(), "OffsetToNNY")) == null) continue;
                nnv.setYPosition(off_y + nv.getYPosition());
                nodeAttributes.deleteAttribute(nn.getIdentifier(), "OffsetToNNY");
            }
            for (CyEdge ne : nestedNetwork.edgesList()) {
                currentNetwork.restoreEdge((Edge)ne);
            }
            for (int idx : currentNetwork.getAdjacentEdgeIndicesArray(node.getRootGraphIndex(), true, true, true)) {
                currentNetwork.removeEdge(idx, true);
            }
            currentNetwork.removeNode(node.getRootGraphIndex(), true);
        }

        public void actionPerformed(ActionEvent ae) {
            if (JOptionPane.showConfirmDialog(null, "Undo previous nesting operation?") != 0) {
                return;
            }
            CyNetwork currentNetwork = Cytoscape.getCurrentNetwork();
            HashSet selectedNodes = new HashSet(currentNetwork.getSelectedNodes());
            for (CyNode node : selectedNodes) {
                UndoNestedNetwork.undoNestedNode(node);
            }
            Cytoscape.getVisualMappingManager().applyAppearances();
        }
    }

    public static class MakeNestedNetwork
    implements ActionListener {
        public static final String LABEL = "Create Nested Network";
        private static int MetaID = 0;

        public static void makeNestedNode(Set nodes) {
            CyNetwork currentNetwork = Cytoscape.getCurrentNetwork();
            CyNetworkView currentView = Cytoscape.getCurrentNetworkView();
            CyAttributes nodeAttributes = Cytoscape.getNodeAttributes();
            HashSet nestedNodes = new HashSet(nodes);
            HashSet<CyEdge> nestedEdges = new HashSet<CyEdge>();
            HashSet<CyEdge> bridgingEdges = new HashSet<CyEdge>();
            for (CyNode node : nestedNodes) {
                if (node.getNestedNetwork() == null) continue;
                JOptionPane.showMessageDialog(null, "Cannot create hierarchically nested networks");
                return;
            }
            for (CyEdge edge : currentNetwork.edgesList()) {
                boolean src_in = nestedNodes.contains(edge.getSource());
                boolean trg_in = nestedNodes.contains(edge.getTarget());
                if (src_in && trg_in) {
                    nestedEdges.add(edge);
                    continue;
                }
                if (!src_in && !trg_in) continue;
                nestedEdges.add(edge);
                bridgingEdges.add(edge);
            }
            String title = currentNetwork.getTitle() + "_meta" + MetaID;
            CyNetwork nestedNetwork = Cytoscape.createNetwork(nestedNodes, nestedEdges, (String)title, (CyNetwork)currentNetwork, (boolean)false);
            CyNode containerNode = Cytoscape.getCyNode((String)("meta" + MetaID), (boolean)true);
            containerNode.setNestedNetwork((GraphPerspective)nestedNetwork);
            currentNetwork.addNode((Node)containerNode);
            for (CyEdge edge : bridgingEdges) {
                CyEdge nEdge = null;
                if (nestedNodes.contains(edge.getTarget())) {
                    nEdge = Cytoscape.getCyEdge((Node)edge.getSource(), (Node)containerNode, (String)"interaction", (Object)"pp", (boolean)true);
                } else if (nestedNodes.contains(edge.getSource())) {
                    nEdge = Cytoscape.getCyEdge((Node)containerNode, (Node)edge.getTarget(), (String)"interaction", (Object)"pp", (boolean)true);
                }
                currentNetwork.addEdge((Edge)nEdge);
            }
            double avgX = 0.0;
            double avgY = 0.0;
            for (CyNode node : nestedNodes) {
                NodeView nv = currentView.getNodeView((Node)node);
                avgX += nv.getXPosition();
                avgY += nv.getYPosition();
            }
            NodeView containerNodeView = currentView.getNodeView((Node)containerNode);
            containerNodeView.setXPosition(avgX /= (double)nestedNodes.size());
            containerNodeView.setYPosition(avgY /= (double)nestedNodes.size());
            for (CyNode node : nestedNodes) {
                NodeView nv = currentView.getNodeView((Node)node);
                nodeAttributes.setAttribute(node.getIdentifier(), "OffsetToNNX", Double.valueOf(nv.getXPosition() - avgX));
                nodeAttributes.setAttribute(node.getIdentifier(), "OffsetToNNY", Double.valueOf(nv.getYPosition() - avgY));
            }
            if (nodeAttributes.getUserVisible("OffsetToNNX")) {
                nodeAttributes.setUserVisible("OffsetToNNX", false);
            }
            if (nodeAttributes.getUserVisible("OffsetToNNY")) {
                nodeAttributes.setUserVisible("OffsetToNNY", false);
            }
            block9: for (String name : nodeAttributes.getAttributeNames()) {
                switch (nodeAttributes.getType(name)) {
                    case 3: {
                        int val = 0;
                        boolean touched = false;
                        for (CyNode node : nestedNodes) {
                            Integer a = nodeAttributes.getIntegerAttribute(node.getIdentifier(), name);
                            if (a == null) continue;
                            val += a.intValue();
                            touched = true;
                        }
                        if (!touched) continue block9;
                        if (!name.contentEquals("count") && !name.contentEquals("percenttotal")) {
                            val /= nestedNodes.size();
                        }
                        nodeAttributes.setAttribute(containerNode.getIdentifier(), name, Integer.valueOf(val));
                        continue block9;
                    }
                    case 2: {
                        double val = 0.0;
                        boolean touched = false;
                        for (CyNode node : nestedNodes) {
                            Double a = nodeAttributes.getDoubleAttribute(node.getIdentifier(), name);
                            if (a == null) continue;
                            val += a.doubleValue();
                            touched = true;
                        }
                        if (!touched) continue block9;
                        if (!name.contentEquals("count") && !name.contentEquals("percenttotal")) {
                            val /= (double)nestedNodes.size();
                        }
                        nodeAttributes.setAttribute(containerNode.getIdentifier(), name, Double.valueOf(val));
                        continue block9;
                    }
                }
            }
            for (CyNode node : nestedNodes) {
                nodeAttributes.setAttribute(node.getIdentifier(), "is_nested", Boolean.valueOf(true));
                currentNetwork.hideNode((Node)node);
            }
            if (nodeAttributes.getUserVisible("is_nested")) {
                nodeAttributes.setUserVisible("is_nested", false);
            }
            for (CyEdge edge : nestedEdges) {
                currentNetwork.hideEdge((Edge)edge);
            }
            Cytoscape.setCurrentNetwork((String)currentNetwork.getIdentifier());
            Cytoscape.setCurrentNetworkView((String)currentView.getIdentifier());
            ++MetaID;
        }

        public static boolean isNested(CyNode node) {
            CyAttributes nodeAttributes = Cytoscape.getNodeAttributes();
            Boolean is_nested = nodeAttributes.getBooleanAttribute(node.getIdentifier(), "is_nested");
            return is_nested != null && is_nested != false;
        }

        public void actionPerformed(ActionEvent ae) {
            if (JOptionPane.showConfirmDialog(null, "Convert selected nodes into a nested network?") != 0) {
                return;
            }
            CyNetwork currentNetwork = Cytoscape.getCurrentNetwork();
            MakeNestedNetwork.makeNestedNode(currentNetwork.getSelectedNodes());
            Cytoscape.getVisualMappingManager().applyAppearances();
        }
    }
}

