### R code from vignette source 'SAFEmanual2.Rnw'

###################################################
### code chunk number 1: initialize
###################################################
library(safe)
library(multtest)
library(hu6800.db)


###################################################
### code chunk number 2: SAFEmanual2.Rnw:95-97
###################################################
data(golub)
dimnames(golub)[[1]] <- golub.gnames[,3]


###################################################
### code chunk number 3: SAFEmanual2.Rnw:108-109
###################################################
table(golub.cl)


###################################################
### code chunk number 4: SAFEmanual2.Rnw:129-132
###################################################
C.mat <- getCmatrix(gene.list = as.list(hu6800PATH), as.matrix = TRUE,
                    present.genes = golub.gnames[,3], min.size = 10)
dimnames(C.mat)[[2]] <- paste("KEGG:",dimnames(C.mat)[[2]],sep="") 


###################################################
### code chunk number 5: SAFEmanual2.Rnw:135-137
###################################################
set.seed(12345)
results <- safe(golub, golub.cl, platform = "hu6800",annotate = "KEGG", min.size = 10)


###################################################
### code chunk number 6: SAFEmanual2.Rnw:150-151
###################################################
results


###################################################
### code chunk number 7: SAFEmanual2.Rnw:171-172
###################################################
gene.results(results,cat.name="KEGG:00860")


###################################################
### code chunk number 8: SAFEmanual2.Rnw:196-202
###################################################
y.vec <- c("ALL","AML")[1+golub.cl]
results2 <- safe(golub, y.vec, C.mat, Pi.mat = 1)
results3 <- safe(golub, golub.cl, C.mat, local="t.Welch", Pi.mat = 1)
round(cbind(Student1 = results@local.stat[1:3],
            Student2 = results2@local.stat[1:3],
            Welch = results3@local.stat[1:3]),3)


###################################################
### code chunk number 9: SAFEmanual2.Rnw:217-221
###################################################
y.vec <- rep(1:19,2)*rep(c(-1,1),each=19)
y.vec
results2 <- safe(golub, y.vec, C.mat, local="t.paired",
                 Pi.mat = 1)


###################################################
### code chunk number 10: SAFEmanual2.Rnw:231-235
###################################################
y.vec <- rexp(38)
cens <- rep(0:1,c(30,8))
results2 <- safe(golub, y.vec, C.mat, local="z.COXPH", Pi.mat = 1, 
                 args.local = list(censor=cens))


###################################################
### code chunk number 11: SAFEmanual2.Rnw:247-254
###################################################
local.Wilcoxon<-function(X.mat,y.vec, ...){
  return(function(data,trt = (y.vec == 1)) {
    return(as.numeric(trt %*% apply(data,1,rank)))
  })
}
results2 <-  safe(golub, golub.cl, C.mat, Pi.mat = 1,
                  local="Wilcoxon")


###################################################
### code chunk number 12: SAFEmanual2.Rnw:256-258
###################################################
cbind(Student1 = round(results@local.stat[1:3],3),
      Rank.Sum=results2@local.stat[1:3])


###################################################
### code chunk number 13: SAFEmanual2.Rnw:297-300
###################################################
set.seed(12345)
results2 <- safe(golub, golub.cl, C.mat, global="Fisher",
                 args.global = list(one.sided=F,genelist.length=200))


###################################################
### code chunk number 14: SAFEmanual2.Rnw:302-303
###################################################
results2


###################################################
### code chunk number 15: SAFEmanual2.Rnw:309-310
###################################################
1-phyper(12-1, 70, 3051-12, 200)


###################################################
### code chunk number 16: SAFEmanual2.Rnw:337-339
###################################################
set.seed(12345)
results <- safe(golub, golub.cl, C.mat, error = "FDR.YB", alpha = 0.25)


###################################################
### code chunk number 17: SAFEmanual2.Rnw:341-342
###################################################
results


###################################################
### code chunk number 18: SAFEmanual2.Rnw:377-380
###################################################
set.seed(12345)
results2 <- safe(golub, golub.cl, C.mat, method = "bootstrap", 
                 error = "FDR.BH")


###################################################
### code chunk number 19: SAFEmanual2.Rnw:382-383
###################################################
results2


###################################################
### code chunk number 20: SAFEmanual2.Rnw:414-416
###################################################
results2 <- safe(golub, golub.cl, platform="hu6800", annotate="PFAM",
                 min.size=10,method="bootstrap")


###################################################
### code chunk number 21: SAFEmanual2.Rnw:418-419
###################################################
results2


###################################################
### code chunk number 22: SAFEmanual2.Rnw:433-438
###################################################
GO.list <- as.list(hu6800GO2ALLPROBES)
C.mat.CC <- getCmatrix(keyword.list = GO.list, GO.ont = "CC", 
            present.genes = dimnames(golub)[[1]], min.size = 10,
            max.size=200)
results2 <- safe(golub, golub.cl, C.mat.CC, method="bootstrap")


###################################################
### code chunk number 23: plot1
###################################################
safeplot(results)


###################################################
### code chunk number 24: plot2
###################################################
safeplot(results,cat.name="KEGG:00010")


###################################################
### code chunk number 25: plot3
###################################################
safedag(results2,filter=1)


###################################################
### code chunk number 26: plot4
###################################################
safedag(results2, filter=1,top="GO:0044428")


