### R code from vignette source 'outliers.Rnw'

###################################################
### code chunk number 1: outliers.Rnw:59-60
###################################################
library(pcaMethods)


###################################################
### code chunk number 2: outliers.Rnw:62-66
###################################################
data(metaboliteDataComplete)
mdc          <- scale(metaboliteDataComplete, center=TRUE, scale=FALSE)
cond         <- runif(length(mdc)) < 0.05;
mdcOut       <- mdc; mdcOut[cond] <- 10


###################################################
### code chunk number 3: outliers.Rnw:69-72
###################################################
resSvd       <- pca(mdc, method = "svd", nPcs = 5, center = FALSE)
resSvdOut    <- pca(mdcOut, method = "svd", nPcs = 5, center = FALSE)
resRobSvd    <- pca(mdcOut, method = "robustPca", nPcs = 5, center = FALSE)


###################################################
### code chunk number 4: outliers.Rnw:76-79
###################################################
mdcNa        <- mdc;
mdcNa[cond]  <- NA
resPPCA      <- pca(mdcNa, method = "ppca", nPcs = 5, center = FALSE)


###################################################
### code chunk number 5: outliers.Rnw:87-101
###################################################
par(mar=c(5, 6, 4, 2))
par(mfrow=c(2,2))
plot(resSvd@loadings[,1], resSvdOut@loadings[,1], 
xlab = "Loading 1 SVD", ylab = "Loading 1 SVD with outliers",
cex.lab = 3, cex.axis = 2, cex = 3, lwd = 3)
plot(resSvd@loadings[,1], resRobSvd@loadings[,1],
xlab = "Loading 1 SVD", ylab = "Loading 1 robustSVD with outliers",
cex.lab = 3, cex.axis = 2, cex = 3, lwd = 3)
plot(resSvd@loadings[,1], resPPCA@loadings[,1],
xlab = "Loading 1 SVD", ylab = "Loading 1 PPCA with outliers = NA",
cex.lab = 3, cex.axis = 2, cex = 3, lwd = 3)
plot(resRobSvd@loadings[,1], resPPCA@loadings[,1],
xlab = "Loading 1 roubst SVD with outliers", ylab = "Loading 1 svdImpute with outliers = NA",
cex.lab = 3, cex.axis = 2, cex = 3, lwd = 3)


