/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.ontocat.utils;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import uk.ac.ebi.ontocat.Ontology;
import uk.ac.ebi.ontocat.OntologyService;
import uk.ac.ebi.ontocat.OntologyServiceException;
import uk.ac.ebi.ontocat.OntologyTerm;
import uk.ac.ebi.ontocat.file.FileOntologyService;
import uk.ac.ebi.ontocat.file.ReasonedFileOntologyService;
import uk.ac.ebi.ontocat.utils.EFOSingleton;
import uk.ac.ebi.ontocat.virtual.LocalisedFileService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OntologyParser {
    private OntologyService os;
    private String ontologySource;
    private String ontologyAccession;
    public boolean status = false;

    public OntologyParser() {
        try {
            this.os = EFOSingleton.getEFO().os;
            this.ontologySource = "http://www.ebi.ac.uk/efo/efo.owl";
            for (Ontology ot : this.os.getOntologies()) {
                this.ontologyAccession = ot.getOntologyAccession();
            }
            this.status = true;
        }
        catch (Exception e) {
            System.out.println("Sorry, can't create Ontology object for EFO by using URL \"http://www.ebi.ac.uk/efo/efo.owl\".");
            this.status = false;
        }
    }

    public OntologyParser(String pathToOntology) {
        int correctResource = 0;
        try {
            File file = new File(pathToOntology);
            URI uri = null;
            if (file.exists()) {
                correctResource = 1;
                uri = file.toURI();
            } else {
                URL url = new URL(pathToOntology);
                correctResource = 1;
                uri = url.toURI();
            }
            if (correctResource > 0) {
                this.ontologySource = pathToOntology;
                if (this.ontologySource.equals("http://www.ebi.ac.uk/efo/efo.owl")) {
                    this.os = EFOSingleton.getEFO().os;
                } else if (correctResource == 1) {
                    this.os = LocalisedFileService.getService(new ReasonedFileOntologyService(uri));
                }
                for (Ontology ot : this.os.getOntologies()) {
                    this.ontologyAccession = ot.getOntologyAccession();
                }
                this.status = true;
            } else {
                System.out.println("Sorry, can't create Ontology object for file \"" + pathToOntology + "\"." + "The ontology file doesn't exist.");
            }
        }
        catch (Exception e) {
            System.out.println("Sorry, can't create Ontology object. Please, check ontology's URI: " + pathToOntology + ".");
            this.status = false;
        }
    }

    public OntologyParser(String pathToOntology, String reasoning) {
        int correctResource = 0;
        try {
            File file = new File(pathToOntology);
            URI uri = null;
            if (file.exists()) {
                correctResource = 1;
                if (reasoning.equals("false")) {
                    correctResource = 2;
                }
                uri = file.toURI();
            } else {
                URL url = new URL(pathToOntology);
                uri = url.toURI();
                correctResource = 1;
                if (reasoning.equals("false")) {
                    correctResource = 2;
                }
            }
            if (correctResource > 0) {
                this.ontologySource = pathToOntology;
                if (this.ontologySource.equals("http://www.ebi.ac.uk/efo/efo.owl")) {
                    this.os = EFOSingleton.getEFO().os;
                } else if (correctResource == 1) {
                    this.os = LocalisedFileService.getService(new ReasonedFileOntologyService(uri));
                } else if (correctResource == 2) {
                    this.os = LocalisedFileService.getService(new FileOntologyService(uri));
                }
                for (Ontology ot : this.os.getOntologies()) {
                    this.ontologyAccession = ot.getOntologyAccession();
                }
                this.status = true;
            } else {
                System.out.println("Sorry, can't create Ontology object for file \"" + pathToOntology + "\"." + "The ontology file doesn't exist.");
            }
        }
        catch (Exception e) {
            System.out.println("Sorry, can't create Ontology object. Please, check ontology's URI: " + pathToOntology + ".");
            this.status = false;
        }
    }

    public OntologyParser(OntologyService os, String ontologyAccession) {
        this.os = os;
        this.ontologyAccession = ontologyAccession;
        try {
            if (!this.os.getRootTerms(this.ontologyAccession).isEmpty()) {
                // empty if block
            }
            this.status = true;
        }
        catch (Exception e) {
            System.out.println("Sorry, can't create Ontology object for ontology \"" + ontologyAccession + "\".");
            this.status = false;
        }
    }

    public String getOntologySource() {
        return this.ontologySource;
    }

    public OntologyService getOntologyService() {
        return this.os;
    }

    public List<OntologyTerm> searchTerm(String text) {
        ArrayList<OntologyTerm> result = new ArrayList<OntologyTerm>();
        try {
            block2: for (OntologyTerm ot : this.os.getAllTerms(this.ontologyAccession)) {
                if (ot.getLabel().contains(text)) {
                    result.add(ot);
                    continue;
                }
                for (String alt : this.os.getSynonyms(ot)) {
                    if (!alt.contains(text)) continue;
                    result.add(ot);
                    continue block2;
                }
            }
        }
        catch (Exception e) {
            System.out.println("Sorry, can't find terms containing \"" + text + "\" in ontology \"" + this.ontologyAccession + "\".");
        }
        return result;
    }

    public List<OntologyTerm> searchTermPrefix(String prefix) {
        String lowerCasePrefix = prefix.toLowerCase();
        ArrayList<OntologyTerm> result = new ArrayList<OntologyTerm>();
        try {
            block2: for (OntologyTerm ot : this.os.getAllTerms(this.ontologyAccession)) {
                if (ot.getLabel().toLowerCase().startsWith(lowerCasePrefix) || ot.getAccession().toLowerCase().startsWith(lowerCasePrefix)) {
                    result.add(ot);
                    continue;
                }
                for (String alt : this.os.getSynonyms(ot)) {
                    if (!alt.toLowerCase().startsWith(lowerCasePrefix)) continue;
                    result.add(ot);
                    continue block2;
                }
            }
        }
        catch (Exception e) {
            System.out.println("Sorry, can't find terms containing prefix \"" + prefix + "\" in ontology \"" + this.ontologyAccession + "\".");
        }
        return result;
    }

    public List<OntologyTerm> getAllTerms() {
        ArrayList<OntologyTerm> result = new ArrayList<OntologyTerm>();
        try {
            for (OntologyTerm ot : this.os.getAllTerms(this.ontologyAccession)) {
                result.add(ot);
            }
        }
        catch (Exception e) {
            System.out.println("Sorry, can't get all terms for ontology " + this.ontologyAccession + ".");
        }
        return result;
    }

    public List<String> getAllTermIds() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            for (OntologyTerm ot : this.os.getAllTerms(this.ontologyAccession)) {
                result.add(ot.getAccession());
            }
        }
        catch (Exception e) {
            System.out.println("Sorry, can't get all terms for ontology \"" + this.ontologyAccession + "\".");
        }
        return result;
    }

    public List<String> getRootIds() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            for (OntologyTerm n : this.os.getRootTerms(this.ontologyAccession)) {
                result.add(n.getAccession());
            }
        }
        catch (Exception e) {
            System.out.println("Sorry, can't get root terms for ontology \"" + this.ontologyAccession + "\".");
        }
        return result;
    }

    public List<OntologyTerm> getRoots() {
        ArrayList<OntologyTerm> result = new ArrayList();
        try {
            result = this.os.getRootTerms(this.ontologyAccession);
        }
        catch (Exception e) {
            System.out.println("Sorry, can't get root terms for ontology \"" + this.ontologyAccession + "\".");
        }
        return result;
    }

    public List<String> getEFOBranchRootIds() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            for (OntologyTerm n : this.os.getAllTerms(this.ontologyAccession)) {
                if (!this.isEFOBranchRoot(n.getAccession())) continue;
                result.add(n.getAccession());
            }
        }
        catch (Exception e) {
            System.out.println("Sorry, can't get EFO branch root terms for ontology \"" + this.ontologyAccession + "\".");
        }
        return result;
    }

    public List<OntologyTerm> getEFOBranchRoots() {
        ArrayList<OntologyTerm> result = new ArrayList<OntologyTerm>();
        try {
            for (OntologyTerm n : this.os.getAllTerms(this.ontologyAccession)) {
                if (!this.isEFOBranchRoot(n.getAccession())) continue;
                result.add(n);
            }
        }
        catch (Exception e) {
            System.out.println("Sorry, can't get EFO branch root terms for ontology \"" + this.ontologyAccession + "\".");
        }
        return result;
    }

    public List<OntologyTerm> getTermChildren(String accession) {
        ArrayList<OntologyTerm> result = new ArrayList<OntologyTerm>();
        try {
            OntologyTerm term = this.os.getTerm(accession);
            for (OntologyTerm ot : this.os.getChildren(term)) {
                result.add(ot);
            }
        }
        catch (Exception e) {
            System.out.println("Sorry, can't find term '" + accession + "' in ontology \"" + this.ontologyAccession + "\".");
        }
        return result;
    }

    public List<OntologyTerm> getTermChildren(OntologyTerm term) {
        if (term != null && term.getAccession() != null) {
            return this.getTermChildren(term.getAccession());
        }
        System.out.println("Sorry, can't find requested term in ontology \"" + this.ontologyAccession + "\".");
        return new ArrayList<OntologyTerm>();
    }

    public List<OntologyTerm> getTermParents(String accession) {
        ArrayList<OntologyTerm> result = new ArrayList<OntologyTerm>();
        try {
            OntologyTerm term = this.os.getTerm(accession);
            for (OntologyTerm ot : this.os.getParents(term)) {
                result.add(ot);
            }
        }
        catch (Exception e) {
            System.out.println("Sorry, can't find term '" + accession + "' in ontology \"" + this.ontologyAccession + "\".");
        }
        return result;
    }

    public List<OntologyTerm> getTermParents(OntologyTerm term) {
        if (term != null && term.getAccession() != null) {
            return this.getTermParents(term.getAccession());
        }
        System.out.println("Sorry, can't find requested term in ontology \"" + this.ontologyAccession + "\".");
        return new ArrayList<OntologyTerm>();
    }

    public List<OntologyTerm> getAllTermChildren(String accession) {
        ArrayList<OntologyTerm> result = new ArrayList<OntologyTerm>();
        try {
            OntologyTerm term = this.os.getTerm(accession);
            for (OntologyTerm ot : this.os.getAllChildren(this.ontologyAccession, term.getAccession())) {
                result.add(ot);
            }
        }
        catch (Exception e) {
            System.out.println("Sorry, can't find term '" + accession + "' in ontology \"" + this.ontologyAccession + "\".");
        }
        return result;
    }

    public List<OntologyTerm> getAllTermChildren(OntologyTerm term) {
        if (term != null && term.getAccession() != null) {
            return this.getAllTermChildren(term.getAccession());
        }
        System.out.println("Sorry, can't find requested term in ontology \"" + this.ontologyAccession + "\".");
        return new ArrayList<OntologyTerm>();
    }

    public List<OntologyTerm> getAllTermParents(String accession) {
        ArrayList<OntologyTerm> result = new ArrayList<OntologyTerm>();
        try {
            OntologyTerm term = this.os.getTerm(accession);
            for (OntologyTerm ot : this.os.getAllParents(this.ontologyAccession, term.getAccession())) {
                result.add(ot);
            }
        }
        catch (Exception e) {
            System.out.println("Sorry, can't find term \"" + accession + "\" in ontology \"" + this.ontologyAccession + "\".");
        }
        return result;
    }

    public List<OntologyTerm> getAllTermParents(OntologyTerm term) {
        if (term != null && term.getAccession() != null) {
            return this.getAllTermParents(term.getAccession());
        }
        System.out.println("Sorry, can't find requested term in ontology \"" + this.ontologyAccession + "\".");
        return new ArrayList<OntologyTerm>();
    }

    public List<OntologyTerm> getTermAndAllChildren(String accession) {
        ArrayList<OntologyTerm> result = new ArrayList<OntologyTerm>();
        try {
            OntologyTerm term = this.os.getTerm(accession);
            for (OntologyTerm child : this.os.getAllChildren(this.ontologyAccession, term.getAccession())) {
                result.add(child);
            }
            result.add(term);
        }
        catch (Exception e) {
            System.out.println("Sorry, can't find term \"" + accession + "\" in ontology \"" + this.ontologyAccession + "\".");
        }
        return result;
    }

    public List<OntologyTerm> getTermAndAllChildren(OntologyTerm term) {
        if (term != null && term.getAccession() != null) {
            return this.getTermAndAllChildren(term.getAccession());
        }
        System.out.println("Sorry, can't find requested term in ontology \"" + this.ontologyAccession + "\".");
        return new ArrayList<OntologyTerm>();
    }

    public OntologyTerm getTermById(String accession) {
        OntologyTerm term = null;
        try {
            term = this.os.getTerm(accession);
        }
        catch (Exception e) {
            System.out.println("Sorry, can't find term \"" + accession + "\" in ontology \"" + this.ontologyAccession + "\".");
        }
        return term;
    }

    public String getTermNameById(String accession) {
        String result = "";
        try {
            OntologyTerm term = this.os.getTerm(accession);
            result = term.getLabel();
        }
        catch (Exception e) {
            System.out.println("Sorry, can't find term \"" + accession + "\" in ontology \"" + this.ontologyAccession + "\".");
        }
        return result;
    }

    public List<String> getTermDefinitions(String accession) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            OntologyTerm term = this.os.getTerm(accession);
            for (String definition : this.os.getDefinitions(term)) {
                result.add(definition);
            }
        }
        catch (Exception e) {
            System.out.println("Sorry, can't find term \"" + accession + "\" in ontology \"" + this.ontologyAccession + "\".");
        }
        return result;
    }

    public List<String> getTermSynonyms(String accession) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            OntologyTerm term = this.os.getTerm(accession);
            for (String synonym : this.os.getSynonyms(term)) {
                result.add(synonym);
            }
        }
        catch (Exception e) {
            System.out.println("Sorry, can't find term \"" + accession + "\" in ontology \"" + this.ontologyAccession + "\".");
        }
        return result;
    }

    public String getTermName(OntologyTerm term) {
        if (term != null && term.getAccession() != null) {
            return this.getTermNameById(term.getAccession());
        }
        System.out.println("Sorry, can't find requested term in ontology \"" + this.ontologyAccession + "\".");
        return "";
    }

    public List<String> getTermDefinitions(OntologyTerm term) {
        if (term != null && term.getAccession() != null) {
            return this.getTermDefinitions(term.getAccession());
        }
        System.out.println("Sorry, can't find requested term in ontology \"" + this.ontologyAccession + "\".");
        return new ArrayList<String>();
    }

    public List<String> getTermSynonyms(OntologyTerm term) {
        if (term != null && term.getAccession() != null) {
            return this.getTermSynonyms(term.getAccession());
        }
        System.out.println("Sorry, can't find requested term in ontology \"" + this.ontologyAccession + "\".");
        return new ArrayList<String>();
    }

    public boolean hasTerm(String accession) {
        boolean result = false;
        try {
            OntologyTerm node = this.os.getTerm(accession);
            result = node != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public boolean isRoot(String accession) {
        boolean result = false;
        try {
            OntologyTerm term = this.os.getTerm(accession);
            for (OntologyTerm ot : this.os.getRootTerms(this.ontologyAccession)) {
                if (!ot.equals(term)) continue;
                result = true;
            }
        }
        catch (Exception e) {
            System.out.println("Sorry, can't find term \"" + accession + "\" in ontology \"" + this.ontologyAccession + "\".");
        }
        return result;
    }

    public boolean isRoot(OntologyTerm term) {
        if (term != null && term.getAccession() != null) {
            return this.isRoot(term.getAccession());
        }
        System.out.println("Sorry, can't find requested term in ontology \"" + this.ontologyAccession + "\".");
        return false;
    }

    public boolean isEFOBranchRoot(String accession) {
        boolean result = false;
        try {
            OntologyTerm term = this.os.getTerm(accession);
            List<String> propBranchClass = this.os.getAnnotations(term).get("branch_class");
            result = propBranchClass != null && propBranchClass.size() > 0 && propBranchClass.get(0).equalsIgnoreCase("true");
        }
        catch (Exception e) {
            System.out.println("Sorry, can't find term \"" + accession + "\" in ontology \"" + this.ontologyAccession + "\".");
        }
        return result;
    }

    public boolean isEFOBranchRoot(OntologyTerm term) {
        if (term != null && term.getAccession() != null) {
            return this.isEFOBranchRoot(term.getAccession());
        }
        System.out.println("Sorry, can't find requested term in ontology \"" + this.ontologyAccession + "\".");
        return false;
    }

    public void showHierarchyDownToTerm(String accession) {
        try {
            OntologyTerm term = this.os.getTerm(accession);
            List<Stack<OntologyTerm>> pathStack = this.getClassPathToRoot(term);
            Stack<OntologyNode> result = new Stack<OntologyNode>();
            this.collectToPrintTreeDownTo(this.orderedStack(this.getRoots(), this.os.getTerm(accession)), pathStack, result, 0, this.os.getTerm(accession), false, false);
            for (OntologyNode n : result) {
                System.out.println(n);
            }
        }
        catch (Exception e) {
            System.out.println("Sorry, can't find term \"" + accession + "\" in ontology \"" + this.ontologyAccession + "\".");
        }
    }

    public void showHierarchyDownToTerm(OntologyTerm term) {
        if (term == null || term.getAccession() == null) {
            System.out.println("Sorry, can't find requested term in ontology \"" + this.ontologyAccession + "\".");
        } else {
            this.showHierarchyDownToTerm(term.getAccession());
        }
    }

    public void showPathsToTerm(String accession) {
        try {
            OntologyTerm term = this.os.getTerm(accession);
            List<Stack<OntologyTerm>> pathStack = this.getClassPathToRoot(term);
            Iterator<Stack<OntologyTerm>> paths = pathStack.iterator();
            int i = 0;
            while (paths.hasNext()) {
                Stack<OntologyTerm> path = paths.next();
                String result = "Path " + ++i + ": ";
                for (OntologyTerm n : path) {
                    result = result + n.getAccession() + " <- ";
                }
                System.out.println(result.substring(0, result.length() - 4));
            }
        }
        catch (Exception e) {
            System.out.println("Sorry, can't find term \"" + accession + "\" in ontology \"" + this.ontologyAccession + "\".");
        }
    }

    public void showPathsToTerm(OntologyTerm term) {
        if (term == null || term.getAccession() == null) {
            System.out.println("Sorry, can't find requested term in ontology \"" + this.ontologyAccession + "\".");
        } else {
            this.showPathsToTerm(term.getAccession());
        }
    }

    public String getOntologyDescription() {
        String result = "";
        try {
            Ontology ontology = this.os.getOntology(this.ontologyAccession);
            result = "Accession: " + (ontology.getOntologyAccession() != null ? ontology.getOntologyAccession() : "");
            result = result + (ontology.getVersionNumber() != null ? " Version: " + ontology.getVersionNumber() : "");
            result = result + (ontology.getLabel() != null ? " Label: " + ontology.getLabel() : "");
            result = result + (ontology.getAbbreviation() != null ? " Abbreviation: " + ontology.getAbbreviation() : "");
            result = result + (ontology.getDescription() != null ? " Description: " + ontology.getDescription() : "");
            result = result + (ontology.getDateReleased() != null ? " Release date: " + ontology.getDateReleased() : "");
        }
        catch (Exception e) {
            System.out.println("Sorry, can't find description for ontology \"" + this.ontologyAccession + "\".");
        }
        return result;
    }

    public String getOntologyAccession() {
        return this.ontologyAccession;
    }

    public List<String> getOntologyRelationNames() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            OntologyTerm startNode = this.getRoots().get(0);
            TreeMap<String, Set<OntologyTerm>> relations = new TreeMap<String, Set<OntologyTerm>>();
            relations.putAll(this.os.getRelations(startNode));
            for (Map.Entry entry : relations.entrySet()) {
                System.out.println("\n\t" + (String)entry.getKey());
                result.add((String)entry.getKey());
            }
        }
        catch (Exception e) {
            System.out.println("Sorry, can't find relations in ontology \"" + this.ontologyAccession + "\".");
        }
        return result;
    }

    public List<String> getTermRelationNames(OntologyTerm term) {
        ArrayList<String> result = new ArrayList();
        if (term != null && term.getAccession() != null) {
            result = this.getTermRelationNames(term.getAccession());
        } else {
            System.out.println("Sorry, can't find requested term in ontology \"" + this.ontologyAccession + "\".");
        }
        return result;
    }

    public List<String> getTermRelationNames(String accession) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            OntologyTerm startNode = this.os.getTerm(accession);
            TreeMap<String, Set<OntologyTerm>> relations = new TreeMap<String, Set<OntologyTerm>>();
            relations.putAll(this.os.getRelations(startNode));
            for (Map.Entry entry : relations.entrySet()) {
                if (((Set)entry.getValue()).isEmpty()) continue;
                result.add((String)entry.getKey());
            }
        }
        catch (Exception e) {
            System.out.println("Sorry, can't find term \"" + accession + "\" in ontology \"" + this.ontologyAccession + "\".");
        }
        return result;
    }

    public List<OntologyTerm> getTermRelations(String accession, String relation) {
        ArrayList<OntologyTerm> result = new ArrayList<OntologyTerm>();
        OntologyTerm startNode = null;
        try {
            startNode = this.os.getTerm(accession);
        }
        catch (Exception e) {
            System.out.println("Sorry, can't find term \"" + accession + "\" in ontology \"" + this.ontologyAccession + "\".");
        }
        try {
            Map<String, Set<OntologyTerm>> relations = this.os.getRelations(startNode);
            for (Map.Entry<String, Set<OntologyTerm>> entry : relations.entrySet()) {
                if (entry.getValue().isEmpty() || !entry.getKey().equals(relation)) continue;
                for (OntologyTerm ot : entry.getValue()) {
                    result.add(ot);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Sorry, can't find relation \"" + relation + "\" for term \"" + accession + "\" in ontology \"" + this.ontologyAccession + "\".");
        }
        return result;
    }

    public List<OntologyTerm> getTermRelations(OntologyTerm term, String relation) {
        ArrayList<OntologyTerm> result = new ArrayList();
        if (term != null && term.getAccession() != null) {
            result = this.getTermRelations(term.getAccession(), relation);
        } else {
            System.out.println("Sorry, can't find requested term in ontology \"" + this.ontologyAccession + "\".");
        }
        return result;
    }

    public void showTermPartonomy(OntologyTerm startNode) {
        try {
            List<OntologyTerm> branch = this.getAllTermChildren(startNode);
            branch.add(startNode);
            System.out.println("\nBuilding exhaustive relations tree, estimated size more than " + branch.size() + " classes\n");
            System.out.println(startNode.getAccession() + " " + startNode.getLabel());
            this.visualisePartonomy(startNode, "    ");
        }
        catch (Exception e) {
            System.out.println("Sorry, can't visualise partonomy.");
        }
    }

    public void showTermAllRelations(OntologyTerm startNode) {
        try {
            List<OntologyTerm> branch = this.getAllTermChildren(startNode);
            branch.add(startNode);
            System.out.println("\nBuilding exhaustive relations tree, estimated size more than " + branch.size() + " classes\n");
            System.out.println(startNode.getAccession() + " " + startNode.getLabel());
            this.visualiseAll(startNode, "    ");
        }
        catch (Exception e) {
            System.out.println("Sorry, can't visualise all relations");
        }
    }

    private void collectToPrintTreeDownTo(Stack<OntologyTerm> nodes, Stack<OntologyTerm> path, Stack<OntologyNode> result, int depth, OntologyTerm mainTerm, boolean shortPath) throws OntologyServiceException {
        OntologyTerm next = path.pop();
        OntologyTerm temp = null;
        for (OntologyTerm n : nodes) {
            if (n.equals(next) && !path.empty()) {
                temp = n;
                continue;
            }
            if (shortPath) continue;
            result.push(new OntologyNode(depth, n));
        }
        if (temp != null) {
            result.push(new OntologyNode(depth, temp));
            this.collectToPrintTreeDownTo(this.orderedStack(this.os.getChildren(temp), mainTerm), path, result, depth + 1, mainTerm, shortPath);
        }
        if (temp == null && path.empty() && !result.contains(new OntologyNode(depth, mainTerm))) {
            result.push(new OntologyNode(depth, mainTerm));
        }
    }

    private void collectToPrintTreeDownTo(Stack<OntologyTerm> nodes, List<Stack<OntologyTerm>> paths, Stack<OntologyNode> result, int depth, OntologyTerm mainTerm, boolean shortPath, boolean stopMergeVal) throws OntologyServiceException {
        OntologyTerm next;
        boolean stopMerge = stopMergeVal;
        HashMap<OntologyTerm, Integer> levelTerms = new HashMap<OntologyTerm, Integer>();
        int i = 0;
        for (Stack<OntologyTerm> path : paths) {
            if (path.empty() || stopMerge) continue;
            next = path.peek();
            levelTerms.put(next, i);
            ++i;
        }
        if (levelTerms.size() != 1) {
            stopMerge = true;
        } else {
            levelTerms.clear();
            i = 0;
            for (Stack<OntologyTerm> path : paths) {
                if (path.empty() || stopMerge) continue;
                next = path.pop();
                levelTerms.put(next, i);
                ++i;
            }
        }
        if (levelTerms.size() == 1 && !stopMerge) {
            for (OntologyTerm ontologyTerm : levelTerms.keySet()) {
                int pathNr = (Integer)levelTerms.get(ontologyTerm);
                OntologyTerm temp = null;
                for (OntologyTerm n : nodes) {
                    if (n.equals(ontologyTerm) && !paths.get(pathNr).empty()) {
                        temp = n;
                        continue;
                    }
                    if (shortPath) continue;
                    result.push(new OntologyNode(depth, n));
                }
                if (temp != null) {
                    result.push(new OntologyNode(depth, temp));
                    this.collectToPrintTreeDownTo(this.orderedStack(this.os.getChildren(temp), mainTerm), paths, result, depth + 1, mainTerm, shortPath, stopMerge);
                }
                if (temp != null || !paths.get(pathNr).empty() || result.contains(new OntologyNode(depth, mainTerm))) continue;
                result.push(new OntologyNode(depth, mainTerm));
            }
        } else {
            for (Stack<OntologyTerm> path : paths) {
                next = path.pop();
                OntologyTerm temp = null;
                boolean exclude = false;
                for (OntologyTerm n : nodes) {
                    if (n.equals(next) && !path.empty()) {
                        temp = n;
                        continue;
                    }
                    if (shortPath) continue;
                    for (Stack<OntologyTerm> path2 : paths) {
                        if (!path2.contains(n)) continue;
                        exclude = true;
                    }
                    if (exclude || result.contains(new OntologyNode(depth, n))) continue;
                    result.push(new OntologyNode(depth, n));
                }
                if (temp != null) {
                    result.push(new OntologyNode(depth, temp));
                    this.collectToPrintTreeDownTo(this.orderedStack(this.os.getChildren(temp), mainTerm), path, result, depth + 1, mainTerm, shortPath);
                }
                if (temp != null || !path.empty() || result.contains(new OntologyNode(depth, mainTerm))) continue;
                result.push(new OntologyNode(depth, mainTerm));
            }
        }
    }

    private Stack<OntologyTerm> orderedStack(List<OntologyTerm> list, OntologyTerm term) throws OntologyServiceException {
        ArrayList<OntologyTerm> tempListBottom = new ArrayList<OntologyTerm>();
        ArrayList<OntologyTerm> tempListTop = new ArrayList<OntologyTerm>();
        Stack<OntologyTerm> orderedStack = new Stack<OntologyTerm>();
        for (OntologyTerm n : list) {
            if (this.os.getParents(term).contains(n) || term.equals(n)) {
                tempListBottom.add(n);
                continue;
            }
            tempListTop.add(n);
        }
        for (OntologyTerm n : tempListTop) {
            orderedStack.push(n);
        }
        for (OntologyTerm n : tempListBottom) {
            orderedStack.push(n);
        }
        return orderedStack;
    }

    private List<Stack<OntologyTerm>> getClassPathToRoot(OntologyTerm term) throws OntologyServiceException {
        Stack<Stack> tempStack = new Stack<Stack>();
        Stack<Stack<OntologyTerm>> resultsStack = new Stack<Stack<OntologyTerm>>();
        Stack<OntologyTerm> seed = new Stack<OntologyTerm>();
        seed.add(term);
        tempStack.push(seed);
        do {
            Stack path;
            List<OntologyTerm> parents;
            if ((parents = this.os.getParents((OntologyTerm)(path = (Stack)tempStack.pop()).peek())).size() != 0) {
                for (OntologyTerm parent : parents) {
                    if (this.isRoot(parent.getAccession())) {
                        path.push(parent);
                        path.trimToSize();
                        resultsStack.push(path);
                        continue;
                    }
                    Stack newPath = (Stack)path.clone();
                    newPath.push(parent);
                    tempStack.push(newPath);
                }
            } else {
                path.trimToSize();
                resultsStack.push(path);
            }
        } while (!tempStack.empty());
        resultsStack.trimToSize();
        return resultsStack;
    }

    private void visualisePartonomy(OntologyTerm currentNode, String tab) throws OntologyServiceException {
        String partPadding = OntologyParser.pad("has_part", "-");
        String isaPadding = OntologyParser.pad("", "-");
        String newTab = tab + OntologyParser.pad("", " ");
        List<OntologyTerm> isaChildren = this.getTermChildren(currentNode);
        List<OntologyTerm> partChildren = this.getTermRelations(currentNode, "has_part");
        isaChildren.removeAll(partChildren);
        for (OntologyTerm term : isaChildren) {
            System.out.println(tab + isaPadding + term.getLabel());
            this.visualisePartonomy(term, newTab);
        }
        for (OntologyTerm term : partChildren) {
            System.out.println(tab + partPadding + term.getLabel());
            this.visualisePartonomy(term, newTab);
        }
    }

    private void visualiseAll(OntologyTerm currentNode, String tab) throws OntologyServiceException {
        String isaPadding = OntologyParser.pad("", "-");
        String newTab = tab + OntologyParser.pad("", " ");
        List<OntologyTerm> isaChildren = this.getTermChildren(currentNode);
        Map<String, Set<OntologyTerm>> mOtherChildren = this.os.getRelations(currentNode.getOntologyAccession(), currentNode.getAccession());
        for (Set<OntologyTerm> set : mOtherChildren.values()) {
            isaChildren.removeAll(set);
        }
        for (OntologyTerm ontologyTerm : isaChildren) {
            System.out.println(tab + isaPadding + ontologyTerm.getLabel());
            this.visualiseAll(ontologyTerm, newTab);
        }
        for (Map.Entry entry : mOtherChildren.entrySet()) {
            for (OntologyTerm ot : (Set)entry.getValue()) {
                System.out.println(tab + OntologyParser.pad((String)entry.getKey(), "-") + ot.getLabel());
                this.visualiseAll(ot, newTab);
            }
        }
    }

    private static String pad(String str, String padChar) {
        StringBuilder padded = new StringBuilder(padChar + padChar + str);
        while (padded.length() < 15) {
            padded.append(padChar);
        }
        return padded.toString();
    }

    private class OntologyNode
    implements Comparable {
        final int depth;
        final OntologyTerm term;

        OntologyNode(int depth, OntologyTerm term) {
            this.depth = depth;
            this.term = term;
        }

        public String toString() {
            String dashes = "";
            for (int i = 0; i != this.depth; ++i) {
                dashes = dashes + "-";
            }
            String outTerm = "";
            try {
                outTerm = this.term.getAccession() + " " + this.term.getLabel();
            }
            catch (Exception e) {
                // empty catch block
            }
            return dashes + outTerm;
        }

        private boolean same(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1.equals(o2);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OntologyNode)) {
                return false;
            }
            OntologyNode p = (OntologyNode)obj;
            return this.same(p.depth, this.depth) && this.same(p.term, this.term);
        }

        public int compareTo(Object o1) {
            if (this.term.equals(((OntologyNode)o1).term) && this.depth == ((OntologyNode)o1).depth) {
                return 0;
            }
            if (this.depth > ((OntologyNode)o1).depth) {
                return 1;
            }
            return -1;
        }
    }
}

