/*
 * Decompiled with CFR 0.152.
 */
package rationals.transformations;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import rationals.Automaton;
import rationals.NoSuchStateException;
import rationals.State;
import rationals.Transition;
import rationals.transformations.UnaryTransformation;

public class Projection
implements UnaryTransformation {
    private Set alphabet;

    public Projection(Set alphabet) {
        this.alphabet = alphabet;
    }

    public Automaton transform(Automaton a) {
        Automaton b = new Automaton();
        HashMap<State, State> smap = new HashMap<State, State>();
        Iterator it = a.delta().iterator();
        while (it.hasNext()) {
            Transition tr = (Transition)it.next();
            State os = tr.start();
            State oe = tr.end();
            Object l = tr.label();
            State ns = (State)smap.get(os);
            State ne = (State)smap.get(oe);
            if (ns == null) {
                ns = b.addState(os.isInitial(), os.isTerminal());
                smap.put(os, ns);
            }
            if (ne == null) {
                ne = b.addState(oe.isInitial(), oe.isTerminal());
                smap.put(oe, ne);
            }
            if (this.alphabet.contains(l)) {
                try {
                    b.addTransition(new Transition(ns, l, ne));
                }
                catch (NoSuchStateException e) {}
                continue;
            }
            try {
                b.addTransition(new Transition(ns, null, ne));
            }
            catch (NoSuchStateException e1) {}
        }
        return b;
    }
}

