/*
 * Decompiled with CFR 0.152.
 */
package rationals.converters.analyzers;

import rationals.Automaton;
import rationals.converters.ConverterException;
import rationals.converters.analyzers.DefaultLexer;
import rationals.converters.analyzers.Lexer;
import rationals.transformations.Concatenation;
import rationals.transformations.Mix;
import rationals.transformations.Reducer;
import rationals.transformations.Shuffle;
import rationals.transformations.Star;
import rationals.transformations.Union;

public class Parser {
    private Lexer lexico;

    public Parser(String expression) {
        this.lexico = new DefaultLexer(expression);
    }

    public Parser(Lexer lexer) {
        this.lexico = lexer;
    }

    private Automaton error(String message) throws ConverterException {
        throw new ConverterException("line " + this.lexico.lineNumber() + " , " + this.lexico.label() + " : " + message);
    }

    public Automaton analyze() throws ConverterException {
        this.lexico.read();
        Automaton r = this.E();
        if (this.lexico.current() != 9) {
            this.error("end of expression expected");
        }
        return r;
    }

    private Automaton E() throws ConverterException {
        switch (this.lexico.current()) {
            case 0: 
            case 2: 
            case 3: 
            case 7: {
                Automaton a = this.T();
                Automaton b = this.EP();
                return new Reducer().transform(new Union().transform(a, b));
            }
        }
        return this.error("expression expected");
    }

    private Automaton EP() throws ConverterException {
        switch (this.lexico.current()) {
            case 0: 
            case 2: 
            case 3: 
            case 7: {
                return this.error("union expected");
            }
            case 8: 
            case 9: {
                return new Automaton();
            }
            case 5: {
                this.lexico.read();
                Automaton a = this.T();
                Automaton b = this.EP();
                return new Reducer().transform(new Union().transform(a, b));
            }
        }
        return this.error("union expected");
    }

    private Automaton T() throws ConverterException {
        switch (this.lexico.current()) {
            case 0: 
            case 2: 
            case 3: 
            case 7: {
                Automaton a = this.S();
                Automaton b = this.TS();
                return new Reducer().transform(new Shuffle().transform(a, b));
            }
        }
        return this.error("expression expected");
    }

    private Automaton TS() throws ConverterException {
        switch (this.lexico.current()) {
            case 0: 
            case 2: 
            case 3: 
            case 7: {
                return this.error("concatenation expected");
            }
            case 5: 
            case 8: 
            case 9: {
                return Automaton.epsilonAutomaton();
            }
            case 11: {
                this.lexico.read();
                Automaton a = this.S();
                Automaton b = this.TS();
                return new Reducer().transform(new Shuffle().transform(a, b));
            }
            case 12: {
                this.lexico.read();
                Automaton a = this.S();
                Automaton b = this.TS();
                return new Reducer().transform(new Mix().transform(a, b));
            }
        }
        return this.error("concatenation expected");
    }

    private Automaton S() throws ConverterException {
        switch (this.lexico.current()) {
            case 0: 
            case 2: 
            case 3: 
            case 7: {
                Automaton a = this.F();
                Automaton b = this.TP();
                return new Reducer().transform(new Concatenation().transform(a, b));
            }
        }
        return this.error("expression expected");
    }

    private Automaton TP() throws ConverterException {
        switch (this.lexico.current()) {
            case 0: 
            case 2: 
            case 3: 
            case 7: {
                Automaton a = this.F();
                Automaton b = this.TP();
                return new Reducer().transform(new Concatenation().transform(a, b));
            }
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                return Automaton.epsilonAutomaton();
            }
        }
        return this.error("concatenation expected");
    }

    private Automaton F() throws ConverterException {
        switch (this.lexico.current()) {
            case 0: 
            case 2: 
            case 3: 
            case 7: {
                Automaton a = this.BP(this.B());
                return a;
            }
        }
        return this.error("factor expected");
    }

    private Automaton B() throws ConverterException {
        switch (this.lexico.current()) {
            case 2: {
                Automaton a = Automaton.epsilonAutomaton();
                this.lexico.read();
                return a;
            }
            case 3: {
                Automaton a = new Automaton();
                this.lexico.read();
                return a;
            }
            case 7: {
                this.lexico.read();
                Automaton a = this.E();
                if (this.lexico.current() != 8) {
                    return this.error("( expected");
                }
                this.lexico.read();
                return a;
            }
            case 0: {
                Automaton a = Automaton.labelAutomaton(this.lexico.label());
                this.lexico.read();
                return a;
            }
        }
        return this.error("factor expected");
    }

    private Automaton BP(Automaton a) throws ConverterException {
        switch (this.lexico.current()) {
            case 0: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                return a;
            }
            case 6: {
                this.lexico.read();
                return new Reducer().transform(new Star().transform(a));
            }
            case 4: {
                this.lexico.read();
                return new Reducer().transform(new Concatenation().transform(a, new Star().transform(a)));
            }
            case 1: 
            case 2: 
            case 3: {
                int value = this.lexico.value();
                this.lexico.read();
                Automaton b = Automaton.epsilonAutomaton();
                for (int i = 0; i < value; ++i) {
                    b = new Reducer().transform(new Concatenation().transform(b, a));
                }
                return b;
            }
        }
        return this.error("Unexpected character");
    }
}

