/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.tableau;

import org.semanticweb.HermiT.Prefixes;
import org.semanticweb.HermiT.model.Concept;
import org.semanticweb.HermiT.model.DLPredicate;
import org.semanticweb.HermiT.model.Role;
import org.semanticweb.HermiT.model.Term;

public class ReasoningTaskDescription {
    protected final boolean m_flipSatisfiabilityResult;
    protected final String m_messagePattern;
    protected final Object[] m_arguments;

    public ReasoningTaskDescription(boolean bl, StandardTestType standardTestType, Object ... objectArray) {
        this(bl, standardTestType.messagePattern, objectArray);
    }

    public ReasoningTaskDescription(boolean bl, String string, Object ... objectArray) {
        this.m_flipSatisfiabilityResult = bl;
        this.m_messagePattern = string;
        this.m_arguments = objectArray;
    }

    public boolean flipSatisfiabilityResult() {
        return this.m_flipSatisfiabilityResult;
    }

    public String getTaskDescription(Prefixes prefixes) {
        String string = this.m_messagePattern;
        for (int i = 0; i < this.m_arguments.length; ++i) {
            Object object = this.m_arguments[i];
            String string2 = object instanceof DLPredicate ? ((DLPredicate)object).toString(prefixes) : (object instanceof Role ? ((Role)object).toString(prefixes) : (object instanceof Concept ? ((Concept)object).toString(prefixes) : (object instanceof Term ? ((Term)object).toString(prefixes) : object.toString())));
            string = string.replace("{" + i + "}", string2);
        }
        return string;
    }

    public String getMessagePattern() {
        return this.m_messagePattern;
    }

    public String toString() {
        return this.getTaskDescription(Prefixes.STANDARD_PREFIXES);
    }

    public static ReasoningTaskDescription isABoxSatisfiable() {
        return new ReasoningTaskDescription(false, StandardTestType.CONSISTENCY, new Object[0]);
    }

    public static ReasoningTaskDescription isConceptSatisfiable(Object object) {
        return new ReasoningTaskDescription(false, StandardTestType.CONCEPT_SATISFIABILITY, object);
    }

    public static ReasoningTaskDescription isConceptSubsumedBy(Object object, Object object2) {
        return new ReasoningTaskDescription(true, StandardTestType.CONCEPT_SUBSUMPTION, object, object2);
    }

    public static ReasoningTaskDescription isConceptSubsumedByList(Object object, Object ... objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("satisiability of concept '{0}' ");
        for (int i = 0; i < objectArray.length; ++i) {
            stringBuffer.append(" and not({");
            stringBuffer.append(i + 1);
            stringBuffer.append("})");
        }
        Object[] objectArray2 = new Object[objectArray.length + 1];
        objectArray2[0] = object;
        System.arraycopy(objectArray, 0, objectArray2, 1, objectArray.length);
        return new ReasoningTaskDescription(false, stringBuffer.toString(), objectArray2);
    }

    public static ReasoningTaskDescription isRoleSubsumedByList(Object object, Object ... objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("satisiability of role '{0}' ");
        for (int i = 0; i < objectArray.length; ++i) {
            stringBuffer.append(" and not({");
            stringBuffer.append(i + 1);
            stringBuffer.append("})");
        }
        Object[] objectArray2 = new Object[objectArray.length + 1];
        objectArray2[0] = object;
        System.arraycopy(objectArray, 0, objectArray2, 1, objectArray.length);
        return new ReasoningTaskDescription(false, stringBuffer.toString(), objectArray2);
    }

    public static ReasoningTaskDescription isRoleSatisfiable(Object object, boolean bl) {
        return new ReasoningTaskDescription(false, bl ? StandardTestType.OBJECT_ROLE_SATISFIABILITY : StandardTestType.DATA_ROLE_SATISFIABILITY, object);
    }

    public static ReasoningTaskDescription isRoleSubsumedBy(Object object, Object object2, boolean bl) {
        return new ReasoningTaskDescription(true, bl ? StandardTestType.OBJECT_ROLE_SUBSUMPTION : StandardTestType.DATA_ROLE_SUBSUMPTION, object, object2);
    }

    public static ReasoningTaskDescription isInstanceOf(Object object, Object object2) {
        return new ReasoningTaskDescription(true, StandardTestType.INSTANCE_OF, object, object2);
    }

    public static ReasoningTaskDescription isObjectRoleInstanceOf(Object object, Object object2, Object object3) {
        return new ReasoningTaskDescription(true, StandardTestType.OBJECT_ROLE_INSTANCE_OF, object, object2, object3);
    }

    public static ReasoningTaskDescription isDataRoleInstanceOf(Object object, Object object2, Object object3) {
        return new ReasoningTaskDescription(true, StandardTestType.DATA_ROLE_INSTANCE_OF, object, object2, object3);
    }

    public static ReasoningTaskDescription isAxiomEntailed(Object object) {
        return new ReasoningTaskDescription(true, StandardTestType.ENTAILMENT, object);
    }

    public static ReasoningTaskDescription isDomainOf(Object object, Object object2) {
        return new ReasoningTaskDescription(true, StandardTestType.DOMAIN, object, object2);
    }

    public static ReasoningTaskDescription isRangeOf(Object object, Object object2) {
        return new ReasoningTaskDescription(true, StandardTestType.RANGE, object, object2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StandardTestType {
        CONCEPT_SATISFIABILITY("satisfiability of concept '{0}'"),
        CONSISTENCY("ABox satisfiability"),
        CONCEPT_SUBSUMPTION("concept subsumption '{0}' => '{1}'"),
        OBJECT_ROLE_SATISFIABILITY("satisfiability of object role '{0}'"),
        DATA_ROLE_SATISFIABILITY("satisfiability of data role '{0}'"),
        OBJECT_ROLE_SUBSUMPTION("object role subsumption '{0}' => '{1}'"),
        DATA_ROLE_SUBSUMPTION("data role subsumption '{0}' => '{1}'"),
        INSTANCE_OF("class instance '{0}'('{1}')"),
        OBJECT_ROLE_INSTANCE_OF("object role instance '{0}'('{1}', '{2}')"),
        DATA_ROLE_INSTANCE_OF("data role instance '{0}'('{1}', '{2}')"),
        ENTAILMENT("entailment of '{0}'"),
        DOMAIN("check if {0} is domain of {1}"),
        RANGE("check if {0} is range of {1}");

        public final String messagePattern;

        private StandardTestType(String string2) {
            this.messagePattern = string2;
        }
    }
}

