/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.tableau;

import java.io.Serializable;
import org.semanticweb.HermiT.model.AnnotatedEquality;
import org.semanticweb.HermiT.tableau.BranchingPoint;
import org.semanticweb.HermiT.tableau.DependencySet;
import org.semanticweb.HermiT.tableau.DependencySetFactory;
import org.semanticweb.HermiT.tableau.InterruptFlag;
import org.semanticweb.HermiT.tableau.MergingManager;
import org.semanticweb.HermiT.tableau.Node;
import org.semanticweb.HermiT.tableau.PermanentDependencySet;
import org.semanticweb.HermiT.tableau.Tableau;
import org.semanticweb.HermiT.tableau.TupleTable;
import org.semanticweb.HermiT.tableau.TupleTableFullIndex;

public final class NominalIntroductionManager
implements Serializable {
    private static final long serialVersionUID = 5863617010809297861L;
    protected final Tableau m_tableau;
    protected final DependencySetFactory m_dependencySetFactory;
    protected final InterruptFlag m_interruptFlag;
    protected final MergingManager m_mergingManager;
    protected final TupleTable m_annotatedEqualities;
    protected final Object[] m_bufferForAnnotatedEquality;
    protected final TupleTable m_newRootNodesTable;
    protected final TupleTableFullIndex m_newRootNodesIndex;
    protected final Object[] m_bufferForRootNodes;
    protected int[] m_indicesByBranchingPoint;
    protected int m_firstUnprocessedAnnotatedEquality;

    public NominalIntroductionManager(Tableau tableau) {
        this.m_tableau = tableau;
        this.m_dependencySetFactory = this.m_tableau.m_dependencySetFactory;
        this.m_interruptFlag = this.m_tableau.m_interruptFlag;
        this.m_mergingManager = this.m_tableau.m_mergingManager;
        this.m_annotatedEqualities = new TupleTable(5);
        this.m_bufferForAnnotatedEquality = new Object[5];
        this.m_newRootNodesTable = new TupleTable(4);
        this.m_newRootNodesIndex = new TupleTableFullIndex(this.m_newRootNodesTable, 3);
        this.m_bufferForRootNodes = new Object[4];
        this.m_indicesByBranchingPoint = new int[20];
        this.m_firstUnprocessedAnnotatedEquality = 0;
    }

    public void clear() {
        int n;
        this.m_annotatedEqualities.clear();
        for (n = this.m_bufferForAnnotatedEquality.length - 1; n >= 0; --n) {
            this.m_bufferForAnnotatedEquality[n] = null;
        }
        this.m_newRootNodesTable.clear();
        this.m_newRootNodesIndex.clear();
        for (n = this.m_bufferForRootNodes.length - 1; n >= 0; --n) {
            this.m_bufferForRootNodes[n] = null;
        }
        this.m_firstUnprocessedAnnotatedEquality = 0;
    }

    public void branchingPointPushed() {
        int n = this.m_tableau.getCurrentBranchingPoint().getLevel() * 3;
        int n2 = n + 3;
        if (n2 > this.m_indicesByBranchingPoint.length) {
            int n3 = this.m_indicesByBranchingPoint.length * 3 / 2;
            while (n2 > n3) {
                n3 = n3 * 3 / 2;
            }
            int[] nArray = new int[n3];
            System.arraycopy(this.m_indicesByBranchingPoint, 0, nArray, 0, this.m_indicesByBranchingPoint.length);
            this.m_indicesByBranchingPoint = nArray;
        }
        this.m_indicesByBranchingPoint[n] = this.m_firstUnprocessedAnnotatedEquality;
        this.m_indicesByBranchingPoint[n + 1] = this.m_annotatedEqualities.getFirstFreeTupleIndex();
        this.m_indicesByBranchingPoint[n + 2] = this.m_newRootNodesTable.getFirstFreeTupleIndex();
    }

    public void backtrack() {
        int n;
        int n2 = this.m_tableau.getCurrentBranchingPoint().getLevel() * 3;
        this.m_firstUnprocessedAnnotatedEquality = this.m_indicesByBranchingPoint[n2];
        int n3 = this.m_indicesByBranchingPoint[n2 + 1];
        for (n = this.m_annotatedEqualities.getFirstFreeTupleIndex() - 1; n >= n3; --n) {
            this.m_dependencySetFactory.removeUsage((PermanentDependencySet)this.m_annotatedEqualities.getTupleObject(n, 4));
        }
        this.m_annotatedEqualities.truncate(n3);
        n = this.m_indicesByBranchingPoint[n2 + 2];
        for (int i = this.m_newRootNodesTable.getFirstFreeTupleIndex() - 1; i >= n; --i) {
            this.m_newRootNodesIndex.removeTuple(i);
        }
        this.m_newRootNodesTable.truncate(n);
    }

    public boolean processAnnotatedEqualities() {
        boolean bl = false;
        while (this.m_firstUnprocessedAnnotatedEquality < this.m_annotatedEqualities.getFirstFreeTupleIndex()) {
            this.m_annotatedEqualities.retrieveTuple(this.m_bufferForAnnotatedEquality, this.m_firstUnprocessedAnnotatedEquality);
            ++this.m_firstUnprocessedAnnotatedEquality;
            AnnotatedEquality annotatedEquality = (AnnotatedEquality)this.m_bufferForAnnotatedEquality[0];
            Node node = (Node)this.m_bufferForAnnotatedEquality[1];
            Node node2 = (Node)this.m_bufferForAnnotatedEquality[2];
            Node node3 = (Node)this.m_bufferForAnnotatedEquality[3];
            DependencySet dependencySet = (DependencySet)this.m_bufferForAnnotatedEquality[4];
            if (this.applyNIRule(annotatedEquality, node, node2, node3, dependencySet)) {
                bl = true;
            }
            this.m_interruptFlag.checkInterrupt();
        }
        return bl;
    }

    public boolean canForgetAnnotation(AnnotatedEquality annotatedEquality, Node node, Node node2, Node node3) {
        return node.isRootNode() || node2.isRootNode() || !node3.isRootNode() || node3.isParentOf(node) && node3.isParentOf(node2);
    }

    public boolean addAnnotatedEquality(AnnotatedEquality annotatedEquality, Node node, Node node2, Node node3, DependencySet dependencySet) {
        if (!(node.isActive() && node2.isActive() && node3.isActive())) {
            return false;
        }
        if (this.canForgetAnnotation(annotatedEquality, node, node2, node3)) {
            return this.m_mergingManager.mergeNodes(node, node2, dependencySet);
        }
        if (annotatedEquality.getCaridnality() == 1) {
            return this.applyNIRule(annotatedEquality, node, node2, node3, dependencySet);
        }
        PermanentDependencySet permanentDependencySet = this.m_dependencySetFactory.getPermanent(dependencySet);
        this.m_bufferForAnnotatedEquality[0] = annotatedEquality;
        this.m_bufferForAnnotatedEquality[1] = node;
        this.m_bufferForAnnotatedEquality[2] = node2;
        this.m_bufferForAnnotatedEquality[3] = node3;
        this.m_bufferForAnnotatedEquality[4] = permanentDependencySet;
        this.m_dependencySetFactory.addUsage(permanentDependencySet);
        this.m_annotatedEqualities.addTuple(this.m_bufferForAnnotatedEquality);
        return true;
    }

    protected boolean applyNIRule(AnnotatedEquality annotatedEquality, Node node, Node node2, Node node3, DependencySet dependencySet) {
        Serializable serializable;
        Node node4;
        Node node5;
        if (node.isPruned() || node2.isPruned() || node3.isPruned()) {
            return false;
        }
        dependencySet = node.addCanonicalNodeDependencySet(dependencySet);
        dependencySet = node2.addCanonicalNodeDependencySet(dependencySet);
        dependencySet = node3.addCanonicalNodeDependencySet(dependencySet);
        if (this.canForgetAnnotation(annotatedEquality, node = node.getCanonicalNode(), node2 = node2.getCanonicalNode(), node3 = node3.getCanonicalNode())) {
            return this.m_mergingManager.mergeNodes(node, node2, dependencySet);
        }
        if (!node.isRootNode() && !node3.isParentOf(node)) {
            node5 = node;
            node4 = node2;
        } else {
            node5 = node2;
            node4 = node;
        }
        if (this.m_tableau.m_tableauMonitor != null) {
            this.m_tableau.m_tableauMonitor.nominalIntorductionStarted(node3, node5, annotatedEquality, node, node2);
        }
        if (annotatedEquality.getCaridnality() > 1) {
            serializable = new NominalIntroductionBranchingPoint(this.m_tableau, node3, node5, node4, annotatedEquality);
            this.m_tableau.pushBranchingPoint((BranchingPoint)serializable);
            dependencySet = this.m_tableau.getDependencySetFactory().addBranchingPoint(dependencySet, ((BranchingPoint)serializable).getLevel());
        }
        if (!((Node)(serializable = this.getNIRootFor(dependencySet, node3, annotatedEquality, 1))).isActive()) {
            assert (((Node)serializable).isMerged());
            dependencySet = ((Node)serializable).addCanonicalNodeDependencySet(dependencySet);
            serializable = ((Node)serializable).getCanonicalNode();
        }
        this.m_mergingManager.mergeNodes(node5, (Node)serializable, dependencySet);
        if (!node4.isPruned()) {
            dependencySet = node4.addCanonicalNodeDependencySet(dependencySet);
            this.m_mergingManager.mergeNodes(node4.getCanonicalNode(), (Node)serializable, dependencySet);
        }
        if (this.m_tableau.m_tableauMonitor != null) {
            this.m_tableau.m_tableauMonitor.nominalIntorductionFinished(node3, node5, annotatedEquality, node, node2);
        }
        return true;
    }

    protected Node getNIRootFor(DependencySet dependencySet, Node node, AnnotatedEquality annotatedEquality, int n) {
        this.m_bufferForRootNodes[0] = node;
        this.m_bufferForRootNodes[1] = annotatedEquality;
        this.m_bufferForRootNodes[2] = n;
        int n2 = this.m_newRootNodesIndex.getTupleIndex(this.m_bufferForRootNodes);
        if (n2 == -1) {
            Node node2 = this.m_tableau.createNewNINode(dependencySet);
            this.m_bufferForRootNodes[3] = node2;
            this.m_newRootNodesIndex.addTuple(this.m_bufferForRootNodes, this.m_newRootNodesTable.getFirstFreeTupleIndex());
            this.m_newRootNodesTable.addTuple(this.m_bufferForRootNodes);
            return node2;
        }
        return (Node)this.m_newRootNodesTable.getTupleObject(n2, 3);
    }

    protected class NominalIntroductionBranchingPoint
    extends BranchingPoint {
        private static final long serialVersionUID = 6678113479704184263L;
        protected final Node m_rootNode;
        protected final Node m_niTargetNode;
        protected final Node m_otherNode;
        protected final AnnotatedEquality m_annotatedEquality;
        protected int m_currentRootNode;

        public NominalIntroductionBranchingPoint(Tableau tableau, Node node, Node node2, Node node3, AnnotatedEquality annotatedEquality) {
            super(tableau);
            this.m_rootNode = node;
            this.m_niTargetNode = node2;
            this.m_otherNode = node3;
            this.m_annotatedEquality = annotatedEquality;
            this.m_currentRootNode = 1;
        }

        public void startNextChoice(Tableau tableau, DependencySet dependencySet) {
            Node node;
            ++this.m_currentRootNode;
            assert (this.m_currentRootNode <= this.m_annotatedEquality.getCaridnality());
            DependencySet dependencySet2 = dependencySet;
            if (this.m_currentRootNode == this.m_annotatedEquality.getCaridnality()) {
                dependencySet2 = tableau.getDependencySetFactory().removeBranchingPoint(dependencySet2, this.m_level);
            }
            if (!(node = NominalIntroductionManager.this.getNIRootFor(dependencySet2, this.m_rootNode, this.m_annotatedEquality, this.m_currentRootNode)).isActive()) {
                assert (node.isMerged());
                dependencySet2 = node.addCanonicalNodeDependencySet(dependencySet2);
                node = node.getCanonicalNode();
            }
            NominalIntroductionManager.this.m_mergingManager.mergeNodes(this.m_niTargetNode, node, dependencySet2);
            if (!this.m_otherNode.isPruned()) {
                dependencySet2 = this.m_otherNode.addCanonicalNodeDependencySet(dependencySet2);
                NominalIntroductionManager.this.m_mergingManager.mergeNodes(this.m_otherNode.getCanonicalNode(), node, dependencySet2);
            }
        }
    }
}

