/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.tableau;

import java.io.Serializable;
import org.semanticweb.HermiT.model.AtomicConcept;
import org.semanticweb.HermiT.model.AtomicNegationConcept;
import org.semanticweb.HermiT.model.AtomicRole;
import org.semanticweb.HermiT.model.Concept;
import org.semanticweb.HermiT.model.DescriptionGraph;
import org.semanticweb.HermiT.model.ExistentialConcept;
import org.semanticweb.HermiT.model.NegatedAtomicRole;
import org.semanticweb.HermiT.monitor.TableauMonitor;
import org.semanticweb.HermiT.tableau.DependencySet;
import org.semanticweb.HermiT.tableau.DependencySetFactory;
import org.semanticweb.HermiT.tableau.Node;
import org.semanticweb.HermiT.tableau.PermanentDependencySet;
import org.semanticweb.HermiT.tableau.Tableau;
import org.semanticweb.HermiT.tableau.TupleTable;

public abstract class ExtensionTable
implements Serializable {
    private static final long serialVersionUID = -5029938218056017193L;
    protected final Tableau m_tableau;
    protected final TableauMonitor m_tableauMonitor;
    protected final int m_tupleArity;
    protected final TupleTable m_tupleTable;
    protected final DependencySetManager m_dependencySetManager;
    protected final CoreManager m_coreManager;
    protected int m_afterExtensionOldTupleIndex;
    protected int m_afterExtensionThisTupleIndex;
    protected int m_afterDeltaNewTupleIndex;
    protected int[] m_indicesByBranchingPoint;

    public ExtensionTable(Tableau tableau, int n, boolean bl) {
        this.m_tableau = tableau;
        this.m_tableauMonitor = this.m_tableau.m_tableauMonitor;
        this.m_tupleArity = n;
        this.m_tupleTable = new TupleTable(this.m_tupleArity + (bl ? 1 : 0));
        this.m_dependencySetManager = bl ? new LastObjectDependencySetManager(this) : new DeterministicDependencySetManager(this);
        this.m_coreManager = this.m_tupleArity == 2 ? new RealCoreManager() : new NoCoreManager();
        this.m_indicesByBranchingPoint = new int[6];
    }

    public abstract int sizeInMemory();

    public int getArity() {
        return this.m_tupleArity;
    }

    public void retrieveTuple(Object[] objectArray, int n) {
        this.m_tupleTable.retrieveTuple(objectArray, n);
    }

    public Object getTupleObject(int n, int n2) {
        return this.m_tupleTable.getTupleObject(n, n2);
    }

    public DependencySet getDependencySet(int n) {
        return this.m_dependencySetManager.getDependencySet(n);
    }

    public boolean isCore(int n) {
        return this.m_coreManager.isCore(n);
    }

    public abstract boolean addTuple(Object[] var1, DependencySet var2, boolean var3);

    protected void postAdd(Object[] objectArray, DependencySet dependencySet, int n, boolean bl) {
        Object object = objectArray[0];
        if (object instanceof Concept) {
            Node node = (Node)objectArray[1];
            if (object instanceof AtomicConcept) {
                ++node.m_numberOfPositiveAtomicConcepts;
            } else if (object instanceof ExistentialConcept) {
                node.addToUnprocessedExistentials((ExistentialConcept)object);
            } else if (object instanceof AtomicNegationConcept) {
                ++node.m_numberOfNegatedAtomicConcepts;
            }
            this.m_tableau.m_existentialExpansionStrategy.assertionAdded((Concept)object, node, bl);
        } else if (object instanceof AtomicRole) {
            this.m_tableau.m_existentialExpansionStrategy.assertionAdded((AtomicRole)object, (Node)objectArray[1], (Node)objectArray[2], bl);
        } else if (object instanceof NegatedAtomicRole) {
            ++((Node)objectArray[1]).m_numberOfNegatedRoleAssertions;
        } else if (object instanceof DescriptionGraph) {
            this.m_tableau.m_descriptionGraphManager.descriptionGraphTupleAdded(n, objectArray);
        }
        this.m_tableau.m_clashManager.tupleAdded(this, objectArray, dependencySet, bl);
    }

    public abstract boolean containsTuple(Object[] var1);

    public Retrieval createRetrieval(boolean[] blArray, View view) {
        int[] nArray = new int[blArray.length];
        for (int i = 0; i < blArray.length; ++i) {
            nArray[i] = blArray[i] ? i : -1;
        }
        return this.createRetrieval(nArray, new Object[blArray.length], new Object[blArray.length], true, view);
    }

    public abstract Retrieval createRetrieval(int[] var1, Object[] var2, Object[] var3, boolean var4, View var5);

    public abstract DependencySet getDependencySet(Object[] var1);

    public abstract boolean isCore(Object[] var1);

    public boolean propagateDeltaNew() {
        boolean bl = this.m_afterExtensionThisTupleIndex != this.m_afterDeltaNewTupleIndex;
        this.m_afterExtensionOldTupleIndex = this.m_afterExtensionThisTupleIndex;
        this.m_afterExtensionThisTupleIndex = this.m_afterDeltaNewTupleIndex;
        this.m_afterDeltaNewTupleIndex = this.m_tupleTable.getFirstFreeTupleIndex();
        return bl;
    }

    public void branchingPointPushed() {
        int n = this.m_tableau.getCurrentBranchingPoint().m_level * 3;
        int n2 = n + 3;
        if (n2 > this.m_indicesByBranchingPoint.length) {
            int n3 = this.m_indicesByBranchingPoint.length * 3 / 2;
            while (n2 > n3) {
                n3 = n3 * 3 / 2;
            }
            int[] nArray = new int[n3];
            System.arraycopy(this.m_indicesByBranchingPoint, 0, nArray, 0, this.m_indicesByBranchingPoint.length);
            this.m_indicesByBranchingPoint = nArray;
        }
        this.m_indicesByBranchingPoint[n] = this.m_afterExtensionOldTupleIndex;
        this.m_indicesByBranchingPoint[n + 1] = this.m_afterExtensionThisTupleIndex;
        this.m_indicesByBranchingPoint[n + 2] = this.m_afterDeltaNewTupleIndex;
    }

    public void backtrack() {
        int n = this.m_tableau.getCurrentBranchingPoint().m_level * 3;
        int n2 = this.m_indicesByBranchingPoint[n + 2];
        for (int i = this.m_afterDeltaNewTupleIndex - 1; i >= n2; --i) {
            this.removeTuple(i);
            this.m_dependencySetManager.forgetDependencySet(i);
            this.m_tupleTable.nullifyTuple(i);
        }
        this.m_tupleTable.truncate(n2);
        this.m_afterExtensionOldTupleIndex = this.m_indicesByBranchingPoint[n];
        this.m_afterExtensionThisTupleIndex = this.m_indicesByBranchingPoint[n + 1];
        this.m_afterDeltaNewTupleIndex = n2;
    }

    protected abstract void removeTuple(int var1);

    protected void postRemove(Object[] objectArray, int n) {
        Object object = objectArray[0];
        if (object instanceof Concept) {
            Node node = (Node)objectArray[1];
            this.m_tableau.m_existentialExpansionStrategy.assertionRemoved((Concept)object, node, this.m_coreManager.isCore(n));
            if (object instanceof AtomicConcept) {
                --node.m_numberOfPositiveAtomicConcepts;
            } else if (object instanceof ExistentialConcept) {
                node.removeFromUnprocessedExistentials((ExistentialConcept)object);
            } else if (object instanceof AtomicNegationConcept) {
                --node.m_numberOfNegatedAtomicConcepts;
            }
        } else if (object instanceof AtomicRole) {
            this.m_tableau.m_existentialExpansionStrategy.assertionRemoved((AtomicRole)object, (Node)objectArray[1], (Node)objectArray[2], this.m_coreManager.isCore(n));
        } else if (object instanceof NegatedAtomicRole) {
            --((Node)objectArray[1]).m_numberOfNegatedRoleAssertions;
        } else if (object instanceof DescriptionGraph) {
            this.m_tableau.m_descriptionGraphManager.descriptionGraphTupleRemoved(n, objectArray);
        }
        if (this.m_tableauMonitor != null) {
            this.m_tableauMonitor.tupleRemoved(objectArray);
        }
    }

    public void clear() {
        this.m_tupleTable.clear();
        this.m_afterExtensionOldTupleIndex = 0;
        this.m_afterExtensionThisTupleIndex = 0;
        this.m_afterDeltaNewTupleIndex = 0;
    }

    public boolean isTupleActive(Object[] objectArray) {
        for (int i = this.m_tupleArity - 1; i > 0; --i) {
            if (((Node)objectArray[i]).isActive()) continue;
            return false;
        }
        return true;
    }

    public boolean isTupleActive(int n) {
        for (int i = this.m_tupleArity - 1; i > 0; --i) {
            if (((Node)this.m_tupleTable.getTupleObject(n, i)).isActive()) continue;
            return false;
        }
        return true;
    }

    protected static class RealCoreManager
    implements CoreManager,
    Serializable {
        private static final long serialVersionUID = 3276377301185845284L;
        protected int[] m_bits = new int[16];

        public boolean isCore(int n) {
            int n2 = n / 32;
            int n3 = 1 << n % 32;
            return (this.m_bits[n2] & n3) != 0;
        }

        public void addCore(int n) {
            int n2 = n / 32;
            int n3 = 1 << n % 32;
            int n4 = n2;
            this.m_bits[n4] = this.m_bits[n4] | n3;
        }

        public void setCore(int n, boolean bl) {
            int n2 = n / 32;
            int n3 = 1 << n % 32;
            if (n2 >= this.m_bits.length) {
                int n4 = 3 * this.m_bits.length / 2;
                while (n2 >= n4) {
                    n4 = 3 * n4 / 2;
                }
                int[] nArray = new int[n4];
                System.arraycopy(this.m_bits, 0, nArray, 0, this.m_bits.length);
                this.m_bits = nArray;
            }
            if (bl) {
                int n5 = n2;
                this.m_bits[n5] = this.m_bits[n5] | n3;
            } else {
                int n6 = n2;
                this.m_bits[n6] = this.m_bits[n6] & ~n3;
            }
        }
    }

    protected static class NoCoreManager
    implements CoreManager,
    Serializable {
        private static final long serialVersionUID = 3252994135060928432L;

        protected NoCoreManager() {
        }

        public boolean isCore(int n) {
            return true;
        }

        public void addCore(int n) {
        }

        public void setCore(int n, boolean bl) {
        }
    }

    protected static interface CoreManager {
        public boolean isCore(int var1);

        public void addCore(int var1);

        public void setCore(int var1, boolean var2);
    }

    protected class LastObjectDependencySetManager
    implements DependencySetManager,
    Serializable {
        private static final long serialVersionUID = -8097612469749016470L;
        protected final DependencySetFactory m_dependencySetFactory;

        public LastObjectDependencySetManager(ExtensionTable extensionTable2) {
            this.m_dependencySetFactory = extensionTable2.m_tableau.getDependencySetFactory();
        }

        public DependencySet getDependencySet(int n) {
            return (DependencySet)ExtensionTable.this.m_tupleTable.getTupleObject(n, ExtensionTable.this.m_tupleArity);
        }

        public void setDependencySet(int n, DependencySet dependencySet) {
            PermanentDependencySet permanentDependencySet = this.m_dependencySetFactory.getPermanent(dependencySet);
            ExtensionTable.this.m_tupleTable.setTupleObject(n, ExtensionTable.this.m_tupleArity, permanentDependencySet);
            this.m_dependencySetFactory.addUsage(permanentDependencySet);
        }

        public void forgetDependencySet(int n) {
            PermanentDependencySet permanentDependencySet = (PermanentDependencySet)ExtensionTable.this.m_tupleTable.getTupleObject(n, ExtensionTable.this.m_tupleArity);
            this.m_dependencySetFactory.removeUsage(permanentDependencySet);
        }
    }

    protected static class DeterministicDependencySetManager
    implements DependencySetManager,
    Serializable {
        private static final long serialVersionUID = 7982627098607954806L;
        protected final DependencySetFactory m_dependencySetFactory;

        public DeterministicDependencySetManager(ExtensionTable extensionTable) {
            this.m_dependencySetFactory = extensionTable.m_tableau.getDependencySetFactory();
        }

        public DependencySet getDependencySet(int n) {
            return this.m_dependencySetFactory.emptySet();
        }

        public void setDependencySet(int n, DependencySet dependencySet) {
        }

        public void forgetDependencySet(int n) {
        }
    }

    protected static interface DependencySetManager {
        public DependencySet getDependencySet(int var1);

        public void setDependencySet(int var1, DependencySet var2);

        public void forgetDependencySet(int var1);
    }

    protected class UnindexedRetrieval
    implements Retrieval,
    Serializable {
        private static final long serialVersionUID = 6395072458663267969L;
        protected final View m_extensionView;
        protected final int[] m_bindingPositions;
        protected final Object[] m_bindingsBuffer;
        protected final Object[] m_tupleBuffer;
        protected final boolean m_ownsBuffers;
        protected final boolean m_checkTupleSelection;
        protected int m_currentTupleIndex;
        protected int m_afterLastTupleIndex;

        public UnindexedRetrieval(int[] nArray, Object[] objectArray, Object[] objectArray2, boolean bl, View view) {
            this.m_bindingPositions = nArray;
            this.m_extensionView = view;
            this.m_bindingsBuffer = objectArray;
            this.m_tupleBuffer = objectArray2;
            this.m_ownsBuffers = bl;
            int n = 0;
            for (int i = this.m_bindingPositions.length - 1; i >= 0; --i) {
                if (this.m_bindingPositions[i] == -1) continue;
                ++n;
            }
            this.m_checkTupleSelection = n > 0;
        }

        public ExtensionTable getExtensionTable() {
            return ExtensionTable.this;
        }

        public View getExtensionView() {
            return this.m_extensionView;
        }

        public void clear() {
            if (this.m_ownsBuffers) {
                int n;
                for (n = this.m_bindingsBuffer.length - 1; n >= 0; --n) {
                    this.m_bindingsBuffer[n] = null;
                }
                for (n = this.m_tupleBuffer.length - 1; n >= 0; --n) {
                    this.m_tupleBuffer[n] = null;
                }
            }
        }

        public int[] getBindingPositions() {
            return this.m_bindingPositions;
        }

        public Object[] getBindingsBuffer() {
            return this.m_bindingsBuffer;
        }

        public Object[] getTupleBuffer() {
            return this.m_tupleBuffer;
        }

        public DependencySet getDependencySet() {
            return ExtensionTable.this.m_dependencySetManager.getDependencySet(this.m_currentTupleIndex);
        }

        public boolean isCore() {
            return ExtensionTable.this.m_coreManager.isCore(this.m_currentTupleIndex);
        }

        public void open() {
            switch (this.m_extensionView) {
                case EXTENSION_THIS: {
                    this.m_currentTupleIndex = 0;
                    this.m_afterLastTupleIndex = ExtensionTable.this.m_afterExtensionThisTupleIndex;
                    break;
                }
                case EXTENSION_OLD: {
                    this.m_currentTupleIndex = 0;
                    this.m_afterLastTupleIndex = ExtensionTable.this.m_afterExtensionOldTupleIndex;
                    break;
                }
                case DELTA_OLD: {
                    this.m_currentTupleIndex = ExtensionTable.this.m_afterExtensionOldTupleIndex;
                    this.m_afterLastTupleIndex = ExtensionTable.this.m_afterExtensionThisTupleIndex;
                    break;
                }
                case TOTAL: {
                    this.m_currentTupleIndex = 0;
                    this.m_afterLastTupleIndex = ExtensionTable.this.m_afterDeltaNewTupleIndex;
                }
            }
            while (this.m_currentTupleIndex < this.m_afterLastTupleIndex) {
                ExtensionTable.this.m_tupleTable.retrieveTuple(this.m_tupleBuffer, this.m_currentTupleIndex);
                if (this.isTupleActive()) {
                    return;
                }
                ++this.m_currentTupleIndex;
            }
        }

        public boolean afterLast() {
            return this.m_currentTupleIndex >= this.m_afterLastTupleIndex;
        }

        public int getCurrentTupleIndex() {
            return this.m_currentTupleIndex;
        }

        public void next() {
            if (this.m_currentTupleIndex < this.m_afterLastTupleIndex) {
                ++this.m_currentTupleIndex;
                while (this.m_currentTupleIndex < this.m_afterLastTupleIndex) {
                    ExtensionTable.this.m_tupleTable.retrieveTuple(this.m_tupleBuffer, this.m_currentTupleIndex);
                    if (this.isTupleActive()) {
                        return;
                    }
                    ++this.m_currentTupleIndex;
                }
            }
        }

        protected boolean isTupleActive() {
            if (!ExtensionTable.this.isTupleActive(this.m_tupleBuffer)) {
                return false;
            }
            if (this.m_checkTupleSelection) {
                for (int i = this.m_bindingPositions.length - 1; i >= 0; --i) {
                    if (this.m_bindingPositions[i] == -1 || this.m_tupleBuffer[i].equals(this.m_bindingsBuffer[this.m_bindingPositions[i]])) continue;
                    return false;
                }
            }
            return true;
        }
    }

    public static interface Retrieval {
        public ExtensionTable getExtensionTable();

        public View getExtensionView();

        public void clear();

        public int[] getBindingPositions();

        public Object[] getBindingsBuffer();

        public Object[] getTupleBuffer();

        public DependencySet getDependencySet();

        public boolean isCore();

        public void open();

        public boolean afterLast();

        public int getCurrentTupleIndex();

        public void next();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum View {
        EXTENSION_THIS,
        EXTENSION_OLD,
        DELTA_OLD,
        TOTAL;

    }
}

