/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.tableau;

import org.semanticweb.HermiT.model.AnnotatedEquality;
import org.semanticweb.HermiT.model.AtomicConcept;
import org.semanticweb.HermiT.model.DLPredicate;
import org.semanticweb.HermiT.model.Equality;
import org.semanticweb.HermiT.model.Inequality;
import org.semanticweb.HermiT.tableau.BranchingPoint;
import org.semanticweb.HermiT.tableau.DependencySet;
import org.semanticweb.HermiT.tableau.GroundDisjunction;
import org.semanticweb.HermiT.tableau.PermanentDependencySet;
import org.semanticweb.HermiT.tableau.Tableau;

public final class DisjunctionBranchingPoint
extends BranchingPoint {
    private static final long serialVersionUID = -8855083430836162354L;
    protected final GroundDisjunction m_groundDisjunction;
    protected final int[] m_sortedDisjunctIndexes;
    protected int m_currentIndex;

    public DisjunctionBranchingPoint(Tableau tableau, GroundDisjunction groundDisjunction, int[] nArray) {
        super(tableau);
        this.m_groundDisjunction = groundDisjunction;
        this.m_sortedDisjunctIndexes = nArray;
    }

    public void startNextChoice(Tableau tableau, DependencySet dependencySet) {
        if (tableau.m_useDisjunctionLearning) {
            this.m_groundDisjunction.getGroundDisjunctionHeader().increaseNumberOfBacktrackings(this.m_sortedDisjunctIndexes[this.m_currentIndex]);
        }
        ++this.m_currentIndex;
        assert (this.m_currentIndex < this.m_groundDisjunction.getNumberOfDisjuncts());
        int n = this.m_sortedDisjunctIndexes[this.m_currentIndex];
        if (tableau.m_tableauMonitor != null) {
            tableau.m_tableauMonitor.disjunctProcessingStarted(this.m_groundDisjunction, n);
        }
        PermanentDependencySet permanentDependencySet = tableau.getDependencySetFactory().getPermanent(dependencySet);
        if (this.m_currentIndex + 1 == this.m_groundDisjunction.getNumberOfDisjuncts()) {
            permanentDependencySet = tableau.getDependencySetFactory().removeBranchingPoint(permanentDependencySet, this.m_level);
        }
        for (int i = 0; i < this.m_currentIndex; ++i) {
            int n2 = this.m_sortedDisjunctIndexes[i];
            DLPredicate dLPredicate = this.m_groundDisjunction.getDLPredicate(n2);
            if (Equality.INSTANCE.equals(dLPredicate) || dLPredicate instanceof AnnotatedEquality) {
                tableau.m_extensionManager.addAssertion(Inequality.INSTANCE, this.m_groundDisjunction.getArgument(n2, 0), this.m_groundDisjunction.getArgument(n2, 1), permanentDependencySet, false);
                continue;
            }
            if (!(dLPredicate instanceof AtomicConcept)) continue;
            tableau.m_extensionManager.addConceptAssertion(((AtomicConcept)dLPredicate).getNegation(), this.m_groundDisjunction.getArgument(n2, 0), permanentDependencySet, false);
        }
        this.m_groundDisjunction.addDisjunctToTableau(tableau, n, permanentDependencySet);
        if (tableau.m_tableauMonitor != null) {
            tableau.m_tableauMonitor.disjunctProcessingFinished(this.m_groundDisjunction, n);
        }
    }
}

