/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.model;

import java.io.Serializable;
import java.util.Set;
import org.semanticweb.HermiT.Prefixes;
import org.semanticweb.HermiT.model.Atom;
import org.semanticweb.HermiT.model.AtomicConcept;
import org.semanticweb.HermiT.model.AtomicRole;
import org.semanticweb.HermiT.model.DLClause;
import org.semanticweb.HermiT.model.DLPredicate;
import org.semanticweb.HermiT.model.ExistsDescriptionGraph;
import org.semanticweb.HermiT.model.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescriptionGraph
implements DLPredicate,
Serializable {
    private static final long serialVersionUID = -6098910060520673164L;
    protected final String m_name;
    protected final AtomicConcept[] m_atomicConceptsByVertices;
    protected final Edge[] m_edges;
    protected final Set<AtomicConcept> m_startConcepts;

    public DescriptionGraph(String string, AtomicConcept[] atomicConceptArray, Edge[] edgeArray, Set<AtomicConcept> set) {
        this.m_name = string;
        this.m_atomicConceptsByVertices = atomicConceptArray;
        this.m_edges = edgeArray;
        this.m_startConcepts = set;
    }

    public String getName() {
        return this.m_name;
    }

    @Override
    public int getArity() {
        return this.m_atomicConceptsByVertices.length;
    }

    public AtomicConcept getAtomicConceptForVertex(int n) {
        return this.m_atomicConceptsByVertices[n];
    }

    public int getNumberOfVertices() {
        return this.m_atomicConceptsByVertices.length;
    }

    public int getNumberOfEdges() {
        return this.m_edges.length;
    }

    public Edge getEdge(int n) {
        return this.m_edges[n];
    }

    public Set<AtomicConcept> getStartConcepts() {
        return this.m_startConcepts;
    }

    public void produceStartDLClauses(Set<DLClause> set) {
        Variable variable = Variable.create("X");
        for (AtomicConcept atomicConcept : this.m_startConcepts) {
            int n;
            Atom[] atomArray = new Atom[]{Atom.create(atomicConcept, variable)};
            int n2 = 0;
            AtomicConcept[] atomicConceptArray = this.m_atomicConceptsByVertices;
            int n3 = atomicConceptArray.length;
            for (n = 0; n < n3; ++n) {
                AtomicConcept atomicConcept2 = atomicConceptArray[n];
                if (!atomicConcept2.equals(atomicConcept)) continue;
                ++n2;
            }
            int n4 = 0;
            Atom[] atomArray2 = new Atom[n2];
            for (n = 0; n < this.m_atomicConceptsByVertices.length; ++n) {
                if (!this.m_atomicConceptsByVertices[n].equals(atomicConcept)) continue;
                atomArray2[n4++] = Atom.create(ExistsDescriptionGraph.create(this, n), variable);
            }
            set.add(DLClause.create(atomArray2, atomArray, DLClause.ClauseType.GRAPH_START_CLAUSE));
        }
    }

    @Override
    public String toString(Prefixes prefixes) {
        return prefixes.abbreviateIRI(this.m_name);
    }

    public String toString() {
        return this.toString(Prefixes.STANDARD_PREFIXES);
    }

    public String getTextRepresentation() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        stringBuffer.append('[');
        stringBuffer.append(string);
        for (int i = 0; i < this.m_atomicConceptsByVertices.length; ++i) {
            stringBuffer.append("   ");
            stringBuffer.append(i);
            stringBuffer.append(" --> ");
            stringBuffer.append(this.m_atomicConceptsByVertices[i].getIRI());
            stringBuffer.append(string);
        }
        stringBuffer.append(string);
        for (Edge edge : this.m_edges) {
            stringBuffer.append("  ");
            stringBuffer.append(edge.getFromVertex());
            stringBuffer.append(" -- ");
            stringBuffer.append(edge.getAtomicRole().getIRI());
            stringBuffer.append(" --> ");
            stringBuffer.append(edge.getToVertex());
            stringBuffer.append(string);
        }
        stringBuffer.append(string);
        for (AtomicConcept atomicConcept : this.m_startConcepts) {
            stringBuffer.append("  ");
            stringBuffer.append(atomicConcept.getIRI());
            stringBuffer.append(string);
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public static class Edge
    implements Serializable {
        private static final long serialVersionUID = -2407275128459101707L;
        protected final AtomicRole m_atomicRole;
        protected final int m_fromVertex;
        protected final int m_toVertex;

        public Edge(AtomicRole atomicRole, int n, int n2) {
            this.m_atomicRole = atomicRole;
            this.m_fromVertex = n;
            this.m_toVertex = n2;
        }

        public AtomicRole getAtomicRole() {
            return this.m_atomicRole;
        }

        public int getFromVertex() {
            return this.m_fromVertex;
        }

        public int getToVertex() {
            return this.m_toVertex;
        }

        public int hashCode() {
            return this.m_fromVertex + 7 * this.m_toVertex + 11 * this.m_atomicRole.hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Edge)) {
                return false;
            }
            Edge edge = (Edge)object;
            return this.m_atomicRole.equals(edge.m_atomicRole) && this.m_fromVertex == edge.m_fromVertex && this.m_toVertex == edge.m_toVertex;
        }
    }
}

