/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.examples;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Set;
import org.semanticweb.HermiT.Configuration;
import org.semanticweb.HermiT.Reasoner;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.ConsoleProgressMonitor;
import org.semanticweb.owlapi.reasoner.InferenceType;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.util.InferredAxiomGenerator;
import org.semanticweb.owlapi.util.InferredClassAssertionAxiomGenerator;
import org.semanticweb.owlapi.util.InferredDisjointClassesAxiomGenerator;
import org.semanticweb.owlapi.util.InferredOntologyGenerator;
import org.semanticweb.owlapi.util.InferredSubClassAxiomGenerator;

public class MaterialiseInferences {
    public static void main(String[] stringArray) throws Exception {
        OWLOntologyManager oWLOntologyManager = OWLManager.createOWLOntologyManager();
        File file = new File("examples/ontologies/pizza.owl");
        OWLOntology oWLOntology = oWLOntologyManager.loadOntologyFromOntologyDocument(file);
        Reasoner.ReasonerFactory reasonerFactory = new Reasoner.ReasonerFactory();
        Configuration configuration = new Configuration();
        configuration.reasonerProgressMonitor = new ConsoleProgressMonitor();
        OWLReasoner oWLReasoner = reasonerFactory.createReasoner(oWLOntology, configuration);
        ArrayList<InferredAxiomGenerator<? extends OWLAxiom>> arrayList = new ArrayList<InferredAxiomGenerator<? extends OWLAxiom>>();
        arrayList.add(new InferredSubClassAxiomGenerator());
        arrayList.add(new InferredClassAssertionAxiomGenerator());
        arrayList.add(new InferredDisjointClassesAxiomGenerator(){
            boolean precomputed = false;

            @Override
            protected void addAxioms(OWLClass oWLClass, OWLReasoner oWLReasoner, OWLDataFactory oWLDataFactory, Set<OWLDisjointClassesAxiom> set) {
                if (!this.precomputed) {
                    oWLReasoner.precomputeInferences(InferenceType.DISJOINT_CLASSES);
                    this.precomputed = true;
                }
                for (OWLClass oWLClass2 : oWLReasoner.getDisjointClasses(oWLClass).getFlattened()) {
                    set.add(oWLDataFactory.getOWLDisjointClassesAxiom(oWLClass, oWLClass2));
                }
            }
        });
        InferredOntologyGenerator inferredOntologyGenerator = new InferredOntologyGenerator(oWLReasoner, arrayList);
        OWLOntology oWLOntology2 = oWLOntologyManager.createOntology();
        inferredOntologyGenerator.fillOntology(oWLOntologyManager, oWLOntology2);
        File file2 = new File("examples/ontologies/pizza-inferred.owl");
        if (!file2.exists()) {
            file2.createNewFile();
        }
        file2 = file2.getAbsoluteFile();
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        oWLOntologyManager.saveOntology(oWLOntology2, oWLOntologyManager.getOntologyFormat(oWLOntology), fileOutputStream);
        System.out.println("The ontology in examples/ontologies/pizza-inferred.owl should now contain all inferred axioms (you might need to refresh the IDE file view). ");
    }
}

