/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.examples;

import com.clarkparsia.owlapi.explanation.BlackBoxExplanation;
import com.clarkparsia.owlapi.explanation.HSTExplanationGenerator;
import com.clarkparsia.owlapi.explanation.TransactionAwareSingleExpGen;
import java.io.File;
import java.util.Set;
import org.semanticweb.HermiT.Configuration;
import org.semanticweb.HermiT.Reasoner;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;

public class Explanations {
    public static void main(String[] stringArray) throws Exception {
        Object object;
        OWLOntologyManager oWLOntologyManager = OWLManager.createOWLOntologyManager();
        OWLDataFactory oWLDataFactory = oWLOntologyManager.getOWLDataFactory();
        File file = new File("examples/ontologies/pizza.owl");
        OWLOntology oWLOntology = oWLOntologyManager.loadOntologyFromOntologyDocument(file);
        IRI iRI = IRI.create("http://www.co-ode.org/ontologies/pizza/pizza.owl#IceCream");
        OWLClass oWLClass = oWLDataFactory.getOWLClass(iRI);
        Reasoner.ReasonerFactory reasonerFactory = new Reasoner.ReasonerFactory();
        Configuration configuration = new Configuration();
        configuration.throwInconsistentOntologyException = false;
        OWLReasoner oWLReasoner = reasonerFactory.createReasoner(oWLOntology, configuration);
        System.out.println("Is icecream satisfiable? " + oWLReasoner.isSatisfiable(oWLClass));
        System.out.println("Computing explanations...");
        BlackBoxExplanation blackBoxExplanation = new BlackBoxExplanation(oWLOntology, (OWLReasonerFactory)reasonerFactory, oWLReasoner);
        HSTExplanationGenerator hSTExplanationGenerator = new HSTExplanationGenerator((TransactionAwareSingleExpGen)blackBoxExplanation);
        Set set = hSTExplanationGenerator.getExplanations((OWLClassExpression)oWLClass);
        for (Object object2 : set) {
            System.out.println("------------------");
            System.out.println("Axioms causing the unsatisfiability: ");
            Object object3 = object2.iterator();
            while (object3.hasNext()) {
                object = (OWLAxiom)object3.next();
                System.out.println(object);
            }
            System.out.println("------------------");
        }
        OWLClassAssertionAxiom oWLClassAssertionAxiom = oWLDataFactory.getOWLClassAssertionAxiom(oWLClass, oWLDataFactory.getOWLNamedIndividual(IRI.create("http://www.co-ode.org/ontologies/pizza/pizza.owl#dummyIndividual")));
        oWLOntologyManager.addAxiom(oWLOntology, oWLClassAssertionAxiom);
        oWLReasoner = reasonerFactory.createReasoner(oWLOntology, configuration);
        System.out.println("Is the changed ontology consistent? " + oWLReasoner.isConsistent());
        System.out.println("Computing explanations for the inconsistency...");
        reasonerFactory = new Reasoner.ReasonerFactory(){

            protected OWLReasoner createHermiTOWLReasoner(Configuration configuration, OWLOntology oWLOntology) {
                configuration.throwInconsistentOntologyException = false;
                return new Reasoner(configuration, oWLOntology);
            }
        };
        blackBoxExplanation = new BlackBoxExplanation(oWLOntology, (OWLReasonerFactory)reasonerFactory, oWLReasoner);
        hSTExplanationGenerator = new HSTExplanationGenerator((TransactionAwareSingleExpGen)blackBoxExplanation);
        set = hSTExplanationGenerator.getExplanations((OWLClassExpression)oWLDataFactory.getOWLThing());
        for (Object object3 : set) {
            System.out.println("------------------");
            System.out.println("Axioms causing the inconsistency: ");
            object = object3.iterator();
            while (object.hasNext()) {
                OWLAxiom oWLAxiom = (OWLAxiom)object.next();
                System.out.println(oWLAxiom);
            }
            System.out.println("------------------");
        }
    }
}

