/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.debugger.commands;

import java.io.PrintWriter;
import org.semanticweb.HermiT.debugger.Debugger;
import org.semanticweb.HermiT.debugger.commands.AbstractCommand;
import org.semanticweb.HermiT.debugger.commands.SubtreeViewer;
import org.semanticweb.HermiT.tableau.Node;

public class ShowSubtreeCommand
extends AbstractCommand {
    public ShowSubtreeCommand(Debugger debugger) {
        super(debugger);
    }

    public String getCommandName() {
        return "showSubtree";
    }

    public String[] getDescription() {
        return new String[]{"nodeID", "shows the subtree rooted at nodeID"};
    }

    public void printHelp(PrintWriter printWriter) {
        printWriter.println("usage: showSubtree nodeID");
        printWriter.println("    Shows the subtree of the model rooted at the given node.");
        printWriter.println("    black: root node");
        printWriter.println("    green: blockable node (not blocked)");
        printWriter.println("    light gray: inactive node");
        printWriter.println("    cyan: blocked node");
        printWriter.println("    red: node with unprocessed existentials");
        printWriter.println("    magenta: description graph node");
        printWriter.println("    blue: concrete/data value node");
    }

    public void execute(String[] stringArray) {
        int n;
        if (stringArray.length < 2) {
            this.m_debugger.getOutput().println("Node ID is missing.");
            return;
        }
        try {
            n = Integer.parseInt(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            this.m_debugger.getOutput().println("Invalid ID of the first node.");
            return;
        }
        Node node = this.m_debugger.getTableau().getNode(n);
        if (node == null) {
            this.m_debugger.getOutput().println("Node with ID '" + n + "' not found.");
            return;
        }
        new SubtreeViewer(this.m_debugger, node);
    }
}

