/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.debugger.commands;

import java.io.PrintWriter;
import org.semanticweb.HermiT.debugger.Debugger;
import org.semanticweb.HermiT.debugger.commands.AbstractCommand;
import org.semanticweb.HermiT.debugger.commands.DebuggerCommand;

public class HelpCommand
extends AbstractCommand {
    public HelpCommand(Debugger debugger) {
        super(debugger);
    }

    public String getCommandName() {
        return "help";
    }

    public String[] getDescription() {
        return new String[]{"", "prints this list of command", "commandName", "prints help for a command"};
    }

    public void printHelp(PrintWriter printWriter) {
        printWriter.println("usage: help");
        printWriter.println("    Prints this message.");
        printWriter.println("usage: help commandName");
        printWriter.println("    Prints help for the command commandName.");
    }

    public void execute(String[] stringArray) {
        if (stringArray.length > 1) {
            String string = stringArray[1];
            DebuggerCommand debuggerCommand = this.m_debugger.getCommand(string);
            if (debuggerCommand == null) {
                this.m_debugger.getOutput().println("Unknown command '" + string + "'.");
            } else {
                debuggerCommand.printHelp(this.m_debugger.getOutput());
            }
        } else {
            int n;
            String[] stringArray2;
            this.m_debugger.getOutput().println("Available commands are:");
            int n2 = 0;
            for (DebuggerCommand debuggerCommand : this.m_debugger.getDebuggerCommands().values()) {
                stringArray2 = debuggerCommand.getDescription();
                for (n = 0; n < stringArray2.length; n += 2) {
                    int n3 = debuggerCommand.getCommandName().length();
                    if (stringArray2[n].length() != 0) {
                        n3 += 1 + stringArray2[n].length();
                    }
                    n2 = Math.max(n2, n3);
                }
            }
            for (DebuggerCommand debuggerCommand : this.m_debugger.getDebuggerCommands().values()) {
                stringArray2 = debuggerCommand.getDescription();
                for (n = 0; n < stringArray2.length; n += 2) {
                    String string = debuggerCommand.getCommandName();
                    if (stringArray2[n].length() != 0) {
                        string = string + ' ' + stringArray2[n];
                    }
                    this.m_debugger.getOutput().print("  ");
                    this.m_debugger.getOutput().print(string);
                    for (int i = string.length(); i < n2; ++i) {
                        this.m_debugger.getOutput().print(' ');
                    }
                    this.m_debugger.getOutput().print("  :  ");
                    this.m_debugger.getOutput().println(stringArray2[n + 1]);
                }
            }
            this.m_debugger.getOutput().println();
            this.m_debugger.getOutput().println("Nodes in the current model are identified by node IDs.");
            this.m_debugger.getOutput().println("Predicates are written as follows, where uri can be abbreviated or full:");
            this.m_debugger.getOutput().println("    ==      equality");
            this.m_debugger.getOutput().println("    !=      inequality");
            this.m_debugger.getOutput().println("    +uri    atomic concept with the URI uri");
            this.m_debugger.getOutput().println("    -uri    atomic role with the URI uri");
            this.m_debugger.getOutput().println("    $uri    description graph with the URI uri");
        }
    }
}

