/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.debugger;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.semanticweb.HermiT.Prefixes;
import org.semanticweb.HermiT.model.Concept;
import org.semanticweb.HermiT.model.ConstantEnumeration;
import org.semanticweb.HermiT.model.DLClause;
import org.semanticweb.HermiT.model.DLPredicate;
import org.semanticweb.HermiT.model.DataRange;
import org.semanticweb.HermiT.model.DatatypeRestriction;
import org.semanticweb.HermiT.model.Equality;
import org.semanticweb.HermiT.model.ExistentialConcept;
import org.semanticweb.HermiT.model.Inequality;
import org.semanticweb.HermiT.model.NodeIDLessEqualThan;
import org.semanticweb.HermiT.model.NodeIDsAscendingOrEqual;
import org.semanticweb.HermiT.monitor.TableauMonitorAdapter;
import org.semanticweb.HermiT.tableau.BranchingPoint;
import org.semanticweb.HermiT.tableau.DLClauseEvaluator;
import org.semanticweb.HermiT.tableau.DatatypeManager;
import org.semanticweb.HermiT.tableau.GroundDisjunction;
import org.semanticweb.HermiT.tableau.Node;

public class DerivationHistory
extends TableauMonitorAdapter {
    private static final long serialVersionUID = -3963478091986772947L;
    protected static final Object[] EMPTY_TUPLE = new Object[0];
    protected final Map<AtomKey, Atom> m_derivedAtoms = new HashMap<AtomKey, Atom>();
    protected final Map<GroundDisjunction, Disjunction> m_derivedDisjunctions = new HashMap<GroundDisjunction, Disjunction>();
    protected final Stack<Derivation> m_derivations = new Stack();
    protected final Stack<Atom> m_mergeAtoms = new Stack();

    public void tableauCleared() {
        this.m_derivedAtoms.clear();
        this.m_derivedDisjunctions.clear();
        this.m_derivations.clear();
        this.m_derivations.push(BaseFact.INSTANCE);
        this.m_mergeAtoms.clear();
    }

    public void dlClauseMatchedStarted(DLClauseEvaluator dLClauseEvaluator, int n) {
        int n2 = 0;
        for (int i = 0; i < dLClauseEvaluator.getBodyLength(); ++i) {
            DLPredicate dLPredicate = dLClauseEvaluator.getBodyAtom(i).getDLPredicate();
            if (dLPredicate instanceof NodeIDLessEqualThan || dLPredicate instanceof NodeIDsAscendingOrEqual) continue;
            ++n2;
        }
        Atom[] atomArray = new Atom[n2];
        int n3 = 0;
        for (int i = 0; i < atomArray.length; ++i) {
            DLPredicate dLPredicate = dLClauseEvaluator.getBodyAtom(i).getDLPredicate();
            if (dLPredicate instanceof NodeIDLessEqualThan && dLPredicate instanceof NodeIDsAscendingOrEqual) continue;
            atomArray[n3++] = this.getAtom(dLClauseEvaluator.getTupleMatchedToBody(i));
        }
        this.m_derivations.push(new DLClauseApplication(dLClauseEvaluator.getDLClause(n), atomArray));
    }

    public void dlClauseMatchedFinished(DLClauseEvaluator dLClauseEvaluator) {
        this.m_derivations.pop();
    }

    public void addFactFinished(Object[] objectArray, boolean bl, boolean bl2) {
        if (bl2) {
            this.addAtom(objectArray);
        }
    }

    public void mergeStarted(Node node, Node node2) {
        Atom atom = this.addAtom(new Object[]{Equality.INSTANCE, node, node2});
        this.m_mergeAtoms.add(atom);
    }

    public void mergeFactStarted(Node node, Node node2, Object[] objectArray, Object[] objectArray2) {
        this.m_derivations.push(new Merging(this.m_mergeAtoms.peek(), this.getAtom(objectArray)));
    }

    public void mergeFactFinished(Node node, Node node2, Object[] objectArray, Object[] objectArray2) {
        this.m_derivations.pop();
    }

    public void mergeFinished(Node node, Node node2) {
        this.m_mergeAtoms.pop();
    }

    public void clashDetectionStarted(Object[] ... objectArray) {
        Atom[] atomArray = new Atom[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            atomArray[i] = this.getAtom(objectArray[i]);
        }
        this.m_derivations.push(new ClashDetection(atomArray));
    }

    public void clashDetectionFinished(Object[] ... objectArray) {
        this.m_derivations.pop();
    }

    public void clashDetected() {
        this.addAtom(EMPTY_TUPLE);
    }

    public void tupleRemoved(Object[] objectArray) {
        this.m_derivedAtoms.remove(new AtomKey(objectArray));
    }

    public void backtrackToFinished(BranchingPoint branchingPoint) {
        this.m_derivedAtoms.remove(new AtomKey(EMPTY_TUPLE));
    }

    public void groundDisjunctionDerived(GroundDisjunction groundDisjunction) {
        Disjunction disjunction = new Disjunction(groundDisjunction, this.m_derivations.peek());
        this.m_derivedDisjunctions.put(groundDisjunction, disjunction);
    }

    public void disjunctProcessingStarted(GroundDisjunction groundDisjunction, int n) {
        Disjunction disjunction = this.getDisjunction(groundDisjunction);
        this.m_derivations.push(new DisjunctApplication(disjunction, n));
    }

    public void disjunctProcessingFinished(GroundDisjunction groundDisjunction, int n) {
        this.m_derivations.pop();
    }

    public void existentialExpansionStarted(ExistentialConcept existentialConcept, Node node) {
        Atom atom = this.getAtom(new Object[]{existentialConcept, node});
        this.m_derivations.push(new ExistentialExpansion(atom));
    }

    public void existentialExpansionFinished(ExistentialConcept existentialConcept, Node node) {
        this.m_derivations.pop();
    }

    public void descriptionGraphCheckingStarted(int n, int n2, int n3, int n4, int n5, int n6) {
        Atom atom = this.getAtom(this.m_tableau.getDescriptionGraphManager().getDescriptionGraphTuple(n, n2));
        Atom atom2 = this.getAtom(this.m_tableau.getDescriptionGraphManager().getDescriptionGraphTuple(n4, n5));
        this.m_derivations.push(new GraphChecking(atom, n3, atom2, n6));
    }

    public void descriptionGraphCheckingFinished(int n, int n2, int n3, int n4, int n5, int n6) {
        this.m_derivations.pop();
    }

    public void unknownDatatypeRestrictionDetectionStarted(DataRange dataRange, Node node, DataRange dataRange2, Node node2) {
        Atom atom = this.getAtom(new Object[]{dataRange, node});
        Atom atom2 = this.getAtom(new Object[]{dataRange2, node2});
        this.m_derivations.push(new UnknownDatatypeRestrictionDetection(new Atom[]{atom, atom2}));
    }

    public void unknownDatatypeRestrictionDetectionFinished(DataRange dataRange, Node node, DataRange dataRange2, Node node2) {
        this.m_derivations.pop();
    }

    public void datatypeConjunctionCheckingStarted(DatatypeManager.DConjunction dConjunction) {
        ArrayList<Atom> arrayList = new ArrayList<Atom>();
        for (DatatypeManager.DVariable dVariable : dConjunction.getActiveVariables()) {
            Node node = dVariable.getNode();
            for (DatatypeRestriction datatypeRestriction : dVariable.getPositiveDatatypeRestrictions()) {
                arrayList.add(this.getAtom(new Object[]{datatypeRestriction, node}));
            }
            for (DatatypeRestriction datatypeRestriction : dVariable.getNegativeDatatypeRestrictions()) {
                arrayList.add(this.getAtom(new Object[]{datatypeRestriction.getNegation(), node}));
            }
            for (ConstantEnumeration constantEnumeration : dVariable.getPositiveDataValueEnumerations()) {
                arrayList.add(this.getAtom(new Object[]{constantEnumeration, node}));
            }
            for (ConstantEnumeration constantEnumeration : dVariable.getNegativeDataValueEnumerations()) {
                arrayList.add(this.getAtom(new Object[]{constantEnumeration.getNegation(), node}));
            }
            for (DatatypeManager.DVariable dVariable2 : dVariable.getUnequalToDirect()) {
                arrayList.add(this.getAtom(new Object[]{Inequality.INSTANCE, node, dVariable2.getNode()}));
            }
        }
        Atom[] atomArray = new Atom[arrayList.size()];
        arrayList.toArray(atomArray);
        this.m_derivations.push(new DatatypeChecking(atomArray));
    }

    public void datatypeConjunctionCheckingFinished(DatatypeManager.DConjunction dConjunction, boolean bl) {
        this.m_derivations.pop();
    }

    public Atom getAtom(Object[] objectArray) {
        return this.m_derivedAtoms.get(new AtomKey(objectArray));
    }

    public Disjunction getDisjunction(GroundDisjunction groundDisjunction) {
        return this.m_derivedDisjunctions.get(groundDisjunction);
    }

    protected Atom addAtom(Object[] objectArray) {
        Object[] objectArray2 = (Object[])objectArray.clone();
        Atom atom = new Atom(objectArray2, this.m_derivations.peek());
        this.m_derivedAtoms.put(new AtomKey(objectArray2), atom);
        return atom;
    }

    public static class BaseFact
    extends Derivation {
        private static final long serialVersionUID = -5998349862414502218L;
        public static Derivation INSTANCE = new BaseFact();

        public int getNumberOfPremises() {
            return 0;
        }

        public Fact getPremise(int n) {
            throw new IndexOutOfBoundsException();
        }

        public String toString(Prefixes prefixes) {
            return ".";
        }
    }

    public static class UnknownDatatypeRestrictionDetection
    extends Derivation {
        private static final long serialVersionUID = -7824360133765453948L;
        protected final Atom[] m_causes;

        public UnknownDatatypeRestrictionDetection(Atom[] atomArray) {
            this.m_causes = atomArray;
        }

        public int getNumberOfPremises() {
            return this.m_causes.length;
        }

        public Fact getPremise(int n) {
            return this.m_causes[n];
        }

        public String toString(Prefixes prefixes) {
            return "   << UNKNOWN DATATYPE";
        }
    }

    public static class DatatypeChecking
    extends Derivation {
        private static final long serialVersionUID = -7833124370362424190L;
        protected final Atom[] m_causes;

        public DatatypeChecking(Atom[] atomArray) {
            this.m_causes = atomArray;
        }

        public int getNumberOfPremises() {
            return this.m_causes.length;
        }

        public Fact getPremise(int n) {
            return this.m_causes[n];
        }

        public String toString(Prefixes prefixes) {
            return "   << DATATYPES";
        }
    }

    public static class ClashDetection
    extends Derivation {
        private static final long serialVersionUID = -1046733682276190587L;
        protected final Atom[] m_causes;

        public ClashDetection(Atom[] atomArray) {
            this.m_causes = atomArray;
        }

        public int getNumberOfPremises() {
            return this.m_causes.length;
        }

        public Fact getPremise(int n) {
            return this.m_causes[n];
        }

        public String toString(Prefixes prefixes) {
            return "   << CLASH";
        }
    }

    public static class ExistentialExpansion
    extends Derivation {
        private static final long serialVersionUID = -1266097745277870260L;
        protected final Atom m_existentialAtom;

        public ExistentialExpansion(Atom atom) {
            this.m_existentialAtom = atom;
        }

        public int getNumberOfPremises() {
            return 1;
        }

        public Fact getPremise(int n) {
            switch (n) {
                case 0: {
                    return this.m_existentialAtom;
                }
            }
            throw new IndexOutOfBoundsException();
        }

        public String toString(Prefixes prefixes) {
            return " <<  EXISTS";
        }
    }

    public static class GraphChecking
    extends Derivation {
        private static final long serialVersionUID = -3671522413313454739L;
        protected final Atom m_graph1;
        protected final int m_position1;
        protected final Atom m_graph2;
        protected final int m_position2;

        public GraphChecking(Atom atom, int n, Atom atom2, int n2) {
            this.m_graph1 = atom;
            this.m_position1 = n;
            this.m_graph2 = atom2;
            this.m_position2 = n2;
        }

        public int getNumberOfPremises() {
            return 2;
        }

        public Fact getPremise(int n) {
            switch (n) {
                case 0: {
                    return this.m_graph1;
                }
                case 1: {
                    return this.m_graph2;
                }
            }
            throw new IndexOutOfBoundsException();
        }

        public String toString(Prefixes prefixes) {
            return "   << DGRAPHS | " + this.m_position1 + " and " + this.m_position2;
        }
    }

    public static class Merging
    extends Derivation {
        private static final long serialVersionUID = 6815119442652251306L;
        protected final Atom m_equality;
        protected final Atom m_fromAtom;

        public Merging(Atom atom, Atom atom2) {
            this.m_equality = atom;
            this.m_fromAtom = atom2;
        }

        public int getNumberOfPremises() {
            return 2;
        }

        public Fact getPremise(int n) {
            switch (n) {
                case 0: {
                    return this.m_equality;
                }
                case 1: {
                    return this.m_fromAtom;
                }
            }
            throw new IndexOutOfBoundsException();
        }

        public String toString(Prefixes prefixes) {
            return "   <--|";
        }
    }

    public static class DisjunctApplication
    extends Derivation {
        private static final long serialVersionUID = 6657356873675430986L;
        protected final Disjunction m_disjunction;
        protected final int m_disjunctIndex;

        public DisjunctApplication(Disjunction disjunction, int n) {
            this.m_disjunction = disjunction;
            this.m_disjunctIndex = n;
        }

        public int getDisjunctIndex() {
            return this.m_disjunctIndex;
        }

        public int getNumberOfPremises() {
            return 1;
        }

        public Fact getPremise(int n) {
            switch (n) {
                case 0: {
                    return this.m_disjunction;
                }
            }
            throw new IndexOutOfBoundsException();
        }

        public String toString(Prefixes prefixes) {
            return "  |  " + String.valueOf(this.m_disjunctIndex);
        }
    }

    public static class DLClauseApplication
    extends Derivation {
        private static final long serialVersionUID = 5841561027229354512L;
        protected final DLClause m_dlClause;
        protected final Atom[] m_premises;

        public DLClauseApplication(DLClause dLClause, Atom[] atomArray) {
            this.m_dlClause = dLClause;
            this.m_premises = atomArray;
        }

        public DLClause getDLClause() {
            return this.m_dlClause;
        }

        public int getNumberOfPremises() {
            return this.m_premises.length;
        }

        public Fact getPremise(int n) {
            return this.m_premises[n];
        }

        public String toString(Prefixes prefixes) {
            return "  <--  " + this.m_dlClause.toString(prefixes);
        }
    }

    public static abstract class Derivation
    implements Serializable {
        public abstract String toString(Prefixes var1);

        public String toString() {
            return this.toString(Prefixes.STANDARD_PREFIXES);
        }

        public abstract int getNumberOfPremises();

        public abstract Fact getPremise(int var1);
    }

    public static class Disjunction
    implements Fact {
        private static final long serialVersionUID = -6645342875287836609L;
        protected final Object[][] m_atoms;
        protected final Derivation m_derivedBy;

        public Disjunction(GroundDisjunction groundDisjunction, Derivation derivation) {
            this.m_atoms = new Object[groundDisjunction.getNumberOfDisjuncts()][];
            for (int i = 0; i < groundDisjunction.getNumberOfDisjuncts(); ++i) {
                DLPredicate dLPredicate = groundDisjunction.getDLPredicate(i);
                Object[] objectArray = new Object[dLPredicate.getArity() + 1];
                objectArray[0] = dLPredicate;
                for (int j = 0; j < dLPredicate.getArity(); ++j) {
                    objectArray[j + 1] = groundDisjunction.getArgument(i, j);
                }
                this.m_atoms[i] = objectArray;
            }
            this.m_derivedBy = derivation;
        }

        public int getNumberOfDisjuncts() {
            return this.m_atoms.length;
        }

        public Object getDLPredicate(int n) {
            return this.m_atoms[n][0];
        }

        public Node getArgument(int n, int n2) {
            return (Node)this.m_atoms[n][n2 + 1];
        }

        public Derivation getDerivation() {
            return this.m_derivedBy;
        }

        public String toString(Prefixes prefixes) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.m_atoms.length; ++i) {
                Object[] objectArray;
                if (i != 0) {
                    stringBuffer.append(" v ");
                }
                if ((objectArray = this.m_atoms[i])[0] instanceof DLPredicate) {
                    stringBuffer.append(((DLPredicate)objectArray[0]).toString(prefixes));
                } else if (objectArray[0] instanceof Concept) {
                    stringBuffer.append(((Concept)objectArray[0]).toString(prefixes));
                } else {
                    throw new IllegalStateException("Internal error: invalid DL-predicate.");
                }
                stringBuffer.append('(');
                for (int j = 1; j < objectArray.length; ++j) {
                    if (j != 1) {
                        stringBuffer.append(',');
                    }
                    stringBuffer.append(((Node)objectArray[j]).getNodeID());
                }
                stringBuffer.append(')');
            }
            return stringBuffer.toString();
        }

        public String toString() {
            return this.toString(Prefixes.STANDARD_PREFIXES);
        }
    }

    public static class Atom
    implements Fact {
        private static final long serialVersionUID = -6136317748590721560L;
        protected final Object[] m_tuple;
        protected final Derivation m_derivedBy;

        public Atom(Object[] objectArray, Derivation derivation) {
            this.m_tuple = objectArray;
            this.m_derivedBy = derivation;
        }

        public Object getDLPredicate() {
            return this.m_tuple[0];
        }

        public int getArity() {
            return this.m_tuple.length - 1;
        }

        public Node getArgument(int n) {
            return (Node)this.m_tuple[n + 1];
        }

        public Derivation getDerivation() {
            return this.m_derivedBy;
        }

        public String toString(Prefixes prefixes) {
            if (this.m_tuple.length == 0) {
                return "[ ]";
            }
            StringBuffer stringBuffer = new StringBuffer();
            Object object = this.getDLPredicate();
            if (org.semanticweb.HermiT.model.Atom.s_infixPredicates.contains(object)) {
                stringBuffer.append(this.getArgument(0).getNodeID());
                stringBuffer.append(' ');
                stringBuffer.append(((DLPredicate)object).toString(prefixes));
                stringBuffer.append(' ');
                stringBuffer.append(this.getArgument(1).getNodeID());
            } else {
                if (object instanceof DLPredicate) {
                    stringBuffer.append(((DLPredicate)object).toString(prefixes));
                } else if (object instanceof Concept) {
                    stringBuffer.append(((Concept)object).toString(prefixes));
                } else {
                    throw new IllegalStateException("Internal error: invalid DL-predicate.");
                }
                stringBuffer.append('(');
                for (int i = 0; i < this.getArity(); ++i) {
                    if (i != 0) {
                        stringBuffer.append(',');
                    }
                    stringBuffer.append(this.getArgument(i).getNodeID());
                }
                stringBuffer.append(')');
            }
            return stringBuffer.toString();
        }

        public String toString() {
            return this.toString(Prefixes.STANDARD_PREFIXES);
        }
    }

    protected static interface Fact
    extends Serializable {
        public String toString(Prefixes var1);

        public Derivation getDerivation();
    }

    protected static class AtomKey
    implements Serializable {
        private static final long serialVersionUID = 1409033744982881556L;
        protected final Object[] m_tuple;
        protected final int m_hashCode;

        public AtomKey(Object[] objectArray) {
            this.m_tuple = objectArray;
            int n = 0;
            for (int i = 0; i < objectArray.length; ++i) {
                n += objectArray[i].hashCode();
            }
            this.m_hashCode = n;
        }

        public int hashCode() {
            return this.m_hashCode;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof AtomKey)) {
                return false;
            }
            AtomKey atomKey = (AtomKey)object;
            if (this.m_tuple.length != atomKey.m_tuple.length) {
                return false;
            }
            for (int i = 0; i < this.m_tuple.length; ++i) {
                if (this.m_tuple[i].equals(atomKey.m_tuple[i])) continue;
                return false;
            }
            return true;
        }
    }
}

