/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdfxml.parser;

import java.util.List;
import java.util.Set;
import org.coode.owlapi.rdfxml.parser.OWLRDFConsumer;
import org.coode.owlapi.rdfxml.parser.TriplePredicateHandler;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class TPPropertyChainAxiomHandler
extends TriplePredicateHandler {
    public TPPropertyChainAxiomHandler(OWLRDFConsumer consumer) {
        super(consumer, OWLRDFVocabulary.OWL_PROPERTY_CHAIN_AXIOM.getIRI());
    }

    public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
        this.getConsumer().addObjectProperty(object, false);
        return false;
    }

    public void handleTriple(IRI subject, IRI predicate, IRI object) throws UnloadableImportException {
        OWLObjectPropertyExpression superProp = this.getConsumer().translateObjectPropertyExpression(subject);
        List<OWLObjectPropertyExpression> chain = this.getConsumer().translateToObjectPropertyList(object);
        this.consumeTriple(subject, predicate, object);
        Set<OWLAnnotation> annos = this.getPendingAnnotations();
        this.addAxiom(this.getDataFactory().getOWLSubPropertyChainOfAxiom(chain, superProp, annos));
    }
}

