/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdfxml.parser;

import java.util.HashSet;
import java.util.Set;
import org.coode.owlapi.rdfxml.parser.OWLRDFConsumer;
import org.coode.owlapi.rdfxml.parser.TriplePredicateHandler;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.SWRLPredicate;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class TPEquivalentPropertyHandler
extends TriplePredicateHandler {
    public TPEquivalentPropertyHandler(OWLRDFConsumer consumer) {
        super(consumer, OWLRDFVocabulary.OWL_EQUIVALENT_PROPERTY.getIRI());
    }

    public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
        return false;
    }

    public void handleTriple(IRI subject, IRI predicate, IRI object) throws UnloadableImportException {
        HashSet<SWRLPredicate> props;
        Set<OWLAnnotation> pendingAnnotations = this.getPendingAnnotations();
        if (this.getConsumer().isObjectProperty(subject) && this.getConsumer().isObjectProperty(object)) {
            props = new HashSet<SWRLPredicate>();
            props.add(this.translateObjectProperty(subject));
            props.add(this.translateObjectProperty(object));
            this.addAxiom(this.getDataFactory().getOWLEquivalentObjectPropertiesAxiom(props, pendingAnnotations));
            this.consumeTriple(subject, predicate, object);
        }
        if (this.getConsumer().isDataProperty(subject) && this.getConsumer().isDataProperty(object)) {
            props = new HashSet();
            props.add(this.translateDataProperty(subject));
            props.add(this.translateDataProperty(object));
            this.addAxiom(this.getDataFactory().getOWLEquivalentDataPropertiesAxiom(props, pendingAnnotations));
            this.consumeTriple(subject, predicate, object);
        }
    }
}

