/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.obo.parser;

import java.io.IOException;
import org.coode.owlapi.obo.parser.OBOConsumer;
import org.coode.owlapi.obo.parser.OBOOntologyFormat;
import org.coode.owlapi.obo.parser.OBOParser;
import org.coode.owlapi.obo.parser.ParseException;
import org.coode.owlapi.obo.parser.Token;
import org.coode.owlapi.obo.parser.TokenMgrError;
import org.semanticweb.owlapi.io.AbstractOWLParser;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLParserException;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyAlreadyExistsException;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.UnloadableImportException;

public class OWLOBOParser
extends AbstractOWLParser {
    public OWLOntologyFormat parse(OWLOntologyDocumentSource documentSource, OWLOntology ontology) throws OWLParserException, IOException, UnloadableImportException {
        return this.parse(documentSource, ontology, new OWLOntologyLoaderConfiguration());
    }

    public OWLOntologyFormat parse(OWLOntologyDocumentSource documentSource, OWLOntology ontology, OWLOntologyLoaderConfiguration configuration) throws OWLParserException, IOException, OWLOntologyChangeException, UnloadableImportException {
        OBOParser parser = documentSource.isReaderAvailable() ? new OBOParser(documentSource.getReader()) : (documentSource.isInputStreamAvailable() ? new OBOParser(documentSource.getInputStream()) : new OBOParser(this.getInputStream(documentSource.getDocumentIRI())));
        parser.setHandler(new OBOConsumer(ontology, configuration));
        try {
            parser.parse();
        }
        catch (ParseException e) {
            if (e.getCause() != null && e.getCause() instanceof OWLOntologyChangeException) {
                throw (OWLOntologyChangeException)e.getCause();
            }
            if (e.getCause() != null && e.getCause() instanceof OWLOntologyAlreadyExistsException) {
                OWLOntologyAlreadyExistsException ex = (OWLOntologyAlreadyExistsException)e.getCause();
                throw new UnloadableImportException(ex, ontology.getOWLOntologyManager().getOWLDataFactory().getOWLImportsDeclaration(ex.getOntologyID().getOntologyIRI()));
            }
            Token currentToken = e.currentToken;
            if (currentToken != null) {
                int beginLine = currentToken.beginLine;
                int beginColumn = currentToken.beginColumn;
                throw new OWLParserException(e, beginLine, beginColumn);
            }
            throw new OWLParserException(e);
        }
        catch (TokenMgrError e) {
            throw new OWLParserException(e);
        }
        return new OBOOntologyFormat();
    }
}

