/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.llom;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;
import javax.activation.DataHandler;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAttachmentAccessor;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMComment;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.OMXMLStreamReader;
import org.apache.axiom.om.impl.EmptyOMLocation;
import org.apache.axiom.om.impl.builder.StAXBuilder;
import org.apache.axiom.om.impl.exception.OMStreamingException;
import org.apache.axiom.om.impl.llom.OMNavigator;
import org.apache.axiom.om.impl.llom.util.NamespaceContextImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OMStAXWrapper
implements OMXMLStreamReader,
XMLStreamConstants {
    private static final Log log = LogFactory.getLog(class$org$apache$axiom$om$impl$llom$OMStAXWrapper == null ? (class$org$apache$axiom$om$impl$llom$OMStAXWrapper = OMStAXWrapper.class$("org.apache.axiom.om.impl.llom.OMStAXWrapper")) : class$org$apache$axiom$om$impl$llom$OMStAXWrapper);
    private static boolean DEBUG_ENABLED = log.isDebugEnabled();
    private OMNavigator navigator;
    private OMXMLParserWrapper builder;
    private XMLStreamReader parser;
    private boolean _isClosed = false;
    private boolean _releaseParserOnClose = false;
    private OMNode rootNode;
    private boolean isFirst = true;
    private static final short NAVIGABLE = 0;
    private static final short SWITCH_AT_NEXT = 1;
    private static final short COMPLETED = 2;
    private static final short SWITCHED = 3;
    private static final short DOCUMENT_COMPLETE = 4;
    private static final QName XOP_INCLUDE = new QName("http://www.w3.org/2004/08/xop/include", "Include", "xop");
    private OMElement xopInclude = null;
    private OMText xopIncludeText = null;
    private boolean xopIncludeStart = false;
    private short state;
    private int currentEvent = 7;
    boolean switchingAllowed = false;
    boolean namespaceURIInterning = false;
    private Stack nodeStack = null;
    private OMNode nextNode = null;
    private OMNode currentNode = null;
    private OMNode lastNode = null;
    int depth = 0;
    private boolean needToThrowEndDocument = false;
    private boolean inlineMTOM = true;
    static /* synthetic */ Class class$org$apache$axiom$om$impl$llom$OMStAXWrapper;

    public void setAllowSwitching(boolean b) {
        this.switchingAllowed = b;
    }

    public boolean isAllowSwitching() {
        return this.switchingAllowed;
    }

    public void setNamespaceURIInterning(boolean b) {
        this.namespaceURIInterning = b;
    }

    public boolean isNamespaceURIInterning() {
        return this.namespaceURIInterning;
    }

    public OMStAXWrapper(OMXMLParserWrapper builder, OMElement startNode) {
        this(builder, startNode, false);
    }

    public OMStAXWrapper(OMXMLParserWrapper builder, OMElement startNode, boolean cache) {
        this.navigator = new OMNavigator(startNode);
        this.builder = builder;
        this.rootNode = startNode;
        if (this.rootNode != null && this.rootNode.getParent() != null && this.rootNode.getParent() instanceof OMDocument) {
            this.needToThrowEndDocument = true;
        }
        boolean resetCache = false;
        try {
            if (startNode instanceof OMSourcedElement && !cache && builder != null) {
                if (!builder.isCache()) {
                    resetCache = true;
                }
                builder.setCache(true);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        this.currentNode = this.navigator.next();
        this.updateNextNode();
        if (resetCache) {
            builder.setCache(cache);
        }
        this.switchingAllowed = !cache;
    }

    public String getPrefix() {
        String returnStr = null;
        if (this.parser != null) {
            returnStr = this.parser.getPrefix();
        } else if (this.currentEvent == 1 || this.currentEvent == 2) {
            OMNamespace ns = ((OMElement)this.getNode()).getNamespace();
            returnStr = ns == null ? null : ns.getPrefix();
        }
        return returnStr;
    }

    public String getNamespaceURI() {
        String returnStr = null;
        if (this.parser != null) {
            returnStr = this.parser.getNamespaceURI();
        } else if (this.currentEvent == 1 || this.currentEvent == 2 || this.currentEvent == 13) {
            OMNamespace ns = ((OMElement)this.getNode()).getNamespace();
            String string = returnStr = ns == null ? null : ns.getNamespaceURI();
        }
        if (this.isNamespaceURIInterning()) {
            returnStr = returnStr != null ? returnStr.intern() : null;
        }
        return returnStr;
    }

    public boolean hasName() {
        if (this.parser != null) {
            return this.parser.hasName();
        }
        return this.currentEvent == 1 || this.currentEvent == 2;
    }

    public String getLocalName() {
        String returnStr = null;
        if (this.parser != null) {
            returnStr = this.parser.getLocalName();
        } else if (this.currentEvent == 1 || this.currentEvent == 2 || this.currentEvent == 9) {
            returnStr = ((OMElement)this.getNode()).getLocalName();
        }
        return returnStr;
    }

    public QName getName() {
        QName returnName = null;
        if (this.parser != null) {
            returnName = this.parser.getName();
        } else if (this.currentEvent == 1 || this.currentEvent == 2) {
            returnName = this.getQName((OMElement)this.getNode());
        }
        return returnName;
    }

    public boolean hasText() {
        return this.currentEvent == 4 || this.currentEvent == 11 || this.currentEvent == 12 || this.currentEvent == 9 || this.currentEvent == 5 || this.currentEvent == 6;
    }

    public int getTextLength() {
        if (this.parser != null) {
            return this.parser.getTextLength();
        }
        String text = this.getTextFromNode();
        return text == null ? 0 : text.length();
    }

    public int getTextStart() {
        if (this.parser != null) {
            return this.parser.getTextStart();
        }
        return 0;
    }

    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) throws XMLStreamException {
        if (this.parser != null) {
            try {
                return this.parser.getTextCharacters(sourceStart, target, targetStart, length);
            }
            catch (XMLStreamException e) {
                throw new OMStreamingException(e);
            }
        }
        String text = this.getTextFromNode();
        if (text != null) {
            int copied = Math.min(length, text.length() - sourceStart);
            text.getChars(sourceStart, sourceStart + copied, target, targetStart);
            return copied;
        }
        return 0;
    }

    public char[] getTextCharacters() {
        if (this.parser != null) {
            return this.parser.getTextCharacters();
        }
        String text = this.getTextFromNode();
        return text == null ? null : text.toCharArray();
    }

    public String getText() {
        if (this.parser != null) {
            return this.parser.getText();
        }
        return this.getTextFromNode();
    }

    private String getTextFromNode() {
        if (this.hasText()) {
            OMNode node = this.getNode();
            if (node instanceof OMText) {
                return ((OMText)node).getText();
            }
            if (node instanceof OMComment) {
                return ((OMComment)node).getValue();
            }
        }
        return null;
    }

    public int getEventType() {
        return this.currentEvent;
    }

    public String getNamespaceURI(int i) {
        String returnString = null;
        if (this.parser != null) {
            returnString = this.parser.getNamespaceURI(i);
        } else if (this.isStartElement() || this.isEndElement() || this.currentEvent == 13) {
            OMNamespace ns = (OMNamespace)this.getItemFromIterator(((OMElement)this.getNode()).getAllDeclaredNamespaces(), i);
            String string = returnString = ns == null ? null : ns.getNamespaceURI();
        }
        if (returnString == null) {
            returnString = "";
        }
        return returnString;
    }

    public String getNamespacePrefix(int i) {
        String returnString = null;
        if (this.parser != null) {
            returnString = this.parser.getNamespacePrefix(i);
        } else if (this.isStartElement() || this.isEndElement() || this.currentEvent == 13) {
            OMNamespace ns = (OMNamespace)this.getItemFromIterator(((OMElement)this.getNode()).getAllDeclaredNamespaces(), i);
            returnString = ns == null ? null : ns.getPrefix();
        }
        return returnString;
    }

    public int getNamespaceCount() {
        int returnCount = 0;
        if (this.parser != null) {
            returnCount = this.parser.getNamespaceCount();
        } else if (this.isStartElement() || this.isEndElement() || this.currentEvent == 13) {
            returnCount = this.getCount(((OMElement)this.getNode()).getAllDeclaredNamespaces());
        }
        return returnCount;
    }

    public boolean isAttributeSpecified(int i) {
        boolean returnValue = false;
        if (this.parser != null) {
            returnValue = this.parser.isAttributeSpecified(i);
        } else if (!this.isStartElement() && this.currentEvent != 10) {
            throw new IllegalStateException("attribute type accessed in illegal event!");
        }
        return returnValue;
    }

    public String getAttributeValue(int i) {
        String returnString = null;
        if (this.parser != null) {
            returnString = this.parser.getAttributeValue(i);
        } else if (this.isStartElement() || this.currentEvent == 10) {
            OMAttribute attrib = this.getAttribute((OMElement)this.getNode(), i);
            if (attrib != null) {
                returnString = attrib.getAttributeValue();
            }
        } else {
            throw new IllegalStateException("attribute type accessed in illegal event!");
        }
        return returnString;
    }

    public String getAttributeType(int i) {
        String returnString = null;
        if (this.parser != null) {
            returnString = this.parser.getAttributeType(i);
        } else if (this.isStartElement() || this.currentEvent == 10) {
            OMAttribute attrib = this.getAttribute((OMElement)this.getNode(), i);
            if (attrib != null) {
                returnString = attrib.getAttributeType();
            }
        } else {
            throw new IllegalStateException("attribute type accessed in illegal event!");
        }
        return returnString;
    }

    public String getAttributePrefix(int i) {
        String returnString = null;
        if (this.parser != null) {
            returnString = this.parser.getAttributePrefix(i);
        } else if (this.isStartElement() || this.currentEvent == 10) {
            OMNamespace nameSpace;
            OMAttribute attrib = this.getAttribute((OMElement)this.getNode(), i);
            if (attrib != null && (nameSpace = attrib.getNamespace()) != null) {
                returnString = nameSpace.getPrefix();
            }
        } else {
            throw new IllegalStateException("attribute prefix accessed in illegal event!");
        }
        return returnString;
    }

    public String getAttributeLocalName(int i) {
        String returnString = null;
        if (this.parser != null) {
            returnString = this.parser.getAttributeLocalName(i);
        } else if (this.isStartElement() || this.currentEvent == 10) {
            OMAttribute attrib = this.getAttribute((OMElement)this.getNode(), i);
            if (attrib != null) {
                returnString = attrib.getLocalName();
            }
        } else {
            throw new IllegalStateException("attribute localName accessed in illegal event!");
        }
        return returnString;
    }

    public String getAttributeNamespace(int i) {
        String returnString = null;
        if (this.parser != null) {
            returnString = this.parser.getAttributeNamespace(i);
        } else if (this.isStartElement() || this.currentEvent == 10) {
            OMNamespace nameSpace;
            OMAttribute attrib = this.getAttribute((OMElement)this.getNode(), i);
            if (attrib != null && (nameSpace = attrib.getNamespace()) != null) {
                returnString = nameSpace.getNamespaceURI();
            }
        } else {
            throw new IllegalStateException("attribute nameSpace accessed in illegal event!");
        }
        return returnString;
    }

    public QName getAttributeName(int i) {
        QName returnQName = null;
        if (this.parser != null) {
            returnQName = this.parser.getAttributeName(i);
        } else if (this.isStartElement() || this.currentEvent == 10) {
            returnQName = this.getAttribute((OMElement)this.getNode(), i).getQName();
        } else {
            throw new IllegalStateException("attribute count accessed in illegal event!");
        }
        return returnQName;
    }

    public int getAttributeCount() {
        int returnCount = 0;
        if (this.parser != null) {
            returnCount = this.parser.getAttributeCount();
        } else if (this.isStartElement() || this.currentEvent == 10) {
            OMElement elt = (OMElement)this.getNode();
            returnCount = this.getCount(elt.getAllAttributes());
        } else {
            throw new IllegalStateException("attribute count accessed in illegal event (" + this.currentEvent + ")!");
        }
        return returnCount;
    }

    public String getAttributeValue(String s, String s1) {
        String returnString = null;
        if (this.parser != null) {
            returnString = this.parser.getAttributeValue(s, s1);
        } else if (this.isStartElement() || this.currentEvent == 10) {
            QName qname = new QName(s, s1);
            OMAttribute attrib = ((OMElement)this.getNode()).getAttribute(qname);
            if (attrib != null) {
                returnString = attrib.getAttributeValue();
            }
        } else {
            throw new IllegalStateException("attribute type accessed in illegal event!");
        }
        return returnString;
    }

    public boolean isWhiteSpace() {
        boolean b = this.parser != null ? this.parser.isWhiteSpace() : this.currentEvent == 6;
        return b;
    }

    public boolean isCharacters() {
        boolean b = this.parser != null ? this.parser.isCharacters() : this.currentEvent == 4;
        return b;
    }

    public boolean isEndElement() {
        boolean b = this.parser != null ? this.parser.isEndElement() : this.currentEvent == 2;
        return b;
    }

    public void require(int i, String s, String s1) throws XMLStreamException {
        throw new XMLStreamException();
    }

    public boolean isStartElement() {
        boolean b = this.parser != null ? this.parser.isStartElement() : this.currentEvent == 1;
        return b;
    }

    public String getNamespaceURI(String prefix) {
        String returnString = null;
        if (this.parser != null) {
            returnString = this.parser.getNamespaceURI(prefix);
        } else if ((this.isStartElement() || this.isEndElement() || this.currentEvent == 13) && this.rootNode instanceof OMElement) {
            OMNamespace namespaceURI = ((OMElement)this.rootNode).findNamespaceURI(prefix);
            return namespaceURI != null ? namespaceURI.getNamespaceURI() : null;
        }
        return returnString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws XMLStreamException {
        if (this.builder != null && this.builder instanceof StAXBuilder) {
            StAXBuilder staxBuilder = (StAXBuilder)this.builder;
            staxBuilder.close();
            this.parser = null;
        } else if (this.parser != null) {
            try {
                if (!this.isClosed()) {
                    this.parser.close();
                }
            }
            finally {
                this._isClosed = true;
                if (this._releaseParserOnClose) {
                    this.parser = null;
                }
            }
        }
    }

    public boolean hasNext() throws XMLStreamException {
        if (this.needToThrowEndDocument) {
            return this.state != 4;
        }
        return this.state != 2 && this.currentEvent != 8;
    }

    public int nextTag() throws XMLStreamException {
        int eventType = this.next();
        while (eventType == 4 && this.isWhiteSpace() || eventType == 12 && this.isWhiteSpace() || eventType == 6 || eventType == 3 || eventType == 5) {
            eventType = this.next();
        }
        if (eventType != 1 && eventType != 2) {
            throw new XMLStreamException("expected start or end tag", this.getLocation());
        }
        return eventType;
    }

    public String getElementText() throws XMLStreamException {
        if (this.parser != null) {
            try {
                return this.parser.getElementText();
            }
            catch (XMLStreamException e) {
                throw new OMStreamingException(e);
            }
        }
        if (this.getEventType() != 1) {
            throw new XMLStreamException("parser must be on START_ELEMENT to read next text", this.getLocation());
        }
        int eventType = this.next();
        StringBuffer content = new StringBuffer();
        while (eventType != 2) {
            if (eventType == 4 || eventType == 12 || eventType == 6 || eventType == 9) {
                content.append(this.getText());
            } else if (eventType != 3 && eventType != 5) {
                if (eventType == 8) {
                    throw new XMLStreamException("unexpected end of document when reading element text content");
                }
                if (eventType == 1) {
                    throw new XMLStreamException("element text content may not contain START_ELEMENT");
                }
                throw new XMLStreamException("Unexpected event type " + eventType, this.getLocation());
            }
            eventType = this.next();
        }
        return content.toString();
    }

    public int next() throws XMLStreamException {
        switch (this.state) {
            case 4: {
                throw new XMLStreamException("End of the document reached");
            }
            case 2: {
                this.state = (short)4;
                this.currentEvent = 8;
                break;
            }
            case 1: {
                this.state = (short)3;
                try {
                    this.parser = (XMLStreamReader)this.builder.getParser();
                }
                catch (Exception e) {
                    throw new XMLStreamException("problem accessing the parser. " + e.getMessage(), e);
                }
                this.currentEvent = this.currentEvent == 7 && this.currentEvent == this.parser.getEventType() ? this.parser.next() : this.parser.getEventType();
                this.updateCompleteStatus();
                break;
            }
            case 0: {
                this.currentEvent = this.generateEvents(this.currentNode);
                this.updateCompleteStatus();
                this.updateLastNode();
                break;
            }
            case 3: {
                if (this.parser.hasNext()) {
                    this.currentEvent = this.parser.next();
                }
                this.updateCompleteStatus();
                break;
            }
            default: {
                throw new OMStreamingException("unsuppported state!");
            }
        }
        return this.currentEvent;
    }

    public Object getProperty(String s) throws IllegalArgumentException {
        StAXBuilder staxBuilder;
        OMText text;
        if ("IsDatahandlersAwareParsing".equals(s)) {
            return Boolean.TRUE;
        }
        if ("Axiom.IsBinary".equals(s)) {
            if (this.getNode() instanceof OMText) {
                OMText text2 = (OMText)this.getNode();
                return new Boolean(text2.isBinary());
            }
            return Boolean.FALSE;
        }
        if ("Axiom.DataHandler".equals(s) && this.getNode() instanceof OMText && (text = (OMText)this.getNode()).isBinary()) {
            return text.getDataHandler();
        }
        if (s == null) {
            throw new IllegalArgumentException();
        }
        if (this.parser != null) {
            return this.parser.getProperty(s);
        }
        if (this.builder != null && this.builder instanceof StAXBuilder && !(staxBuilder = (StAXBuilder)this.builder).isClosed()) {
            try {
                return ((StAXBuilder)this.builder).getReaderProperty(s);
            }
            catch (IllegalStateException ise) {
                return null;
            }
        }
        return null;
    }

    private void updateLastNode() throws XMLStreamException {
        if (this.xopInclude != null && this.xopIncludeText == this.currentNode && this.xopIncludeStart) {
            this.lastNode = this.xopIncludeText;
            return;
        }
        this.lastNode = this.currentNode;
        this.currentNode = this.nextNode;
        try {
            this.updateNextNode();
        }
        catch (Exception e) {
            throw new XMLStreamException(e);
        }
    }

    private void updateNextNode() {
        if (this.navigator.isNavigable()) {
            this.nextNode = this.navigator.next();
        } else if (!this.switchingAllowed) {
            if (this.navigator.isCompleted() || this.builder == null || this.builder.isCompleted()) {
                this.nextNode = null;
                if (DEBUG_ENABLED && (this.builder == null || this.builder.isCompleted())) {
                    log.debug("Builder is complete.  Next node is set to null.");
                }
            } else {
                this.builder.next();
                this.navigator.step();
                this.nextNode = this.navigator.next();
            }
        } else if (this.navigator.isCompleted()) {
            this.nextNode = null;
        } else {
            if (this.builder != null) {
                this.builder.setCache(false);
            }
            this.state = 1;
        }
    }

    private void updateCompleteStatus() {
        if (this.state == 0) {
            if (this.rootNode == this.currentNode) {
                if (this.isFirst) {
                    this.isFirst = false;
                } else {
                    this.state = (short)2;
                }
            }
        } else {
            if (this.state == 3) {
                if (this.currentEvent == 1 && this.parser.getLocalName().equals(((OMElement)this.rootNode).getLocalName())) {
                    ++this.depth;
                } else if (this.currentEvent == 2 && this.parser.getLocalName().equals(((OMElement)this.rootNode).getLocalName())) {
                    --this.depth;
                    if (this.depth < 0) {
                        this.state = (short)2;
                    }
                }
            }
            this.state = (short)(this.currentEvent == 8 ? 4 : (int)this.state);
        }
    }

    public NamespaceContext getNamespaceContext() {
        if (this.state == 3) {
            return this.parser.getNamespaceContext();
        }
        Map m = this.getAllNamespaces(this.getNode());
        if (this.getNode() != this.lastNode) {
            m.putAll(this.getAllNamespaces(this.lastNode));
        }
        return new NamespaceContextImpl(m);
    }

    public String getEncoding() {
        return null;
    }

    public Location getLocation() {
        return new EmptyOMLocation();
    }

    public String getVersion() {
        return "1.0";
    }

    public boolean isStandalone() {
        return true;
    }

    public boolean standaloneSet() {
        return false;
    }

    public String getCharacterEncodingScheme() {
        if (this.builder != null) {
            return this.builder.getCharacterEncoding();
        }
        return "utf-8";
    }

    public String getPITarget() {
        throw new UnsupportedOperationException();
    }

    public String getPIData() {
        throw new UnsupportedOperationException();
    }

    private int generateEvents(OMNode node) {
        int returnEvent = 0;
        if (node == null) {
            if (log.isDebugEnabled()) {
                log.debug("Node is null...returning END_DOCUMENT");
            }
            returnEvent = 8;
            return returnEvent;
        }
        int nodeType = node.getType();
        switch (nodeType) {
            case 1: {
                OMElement element = (OMElement)node;
                returnEvent = this.generateElementEvents(element);
                break;
            }
            case 4: {
                returnEvent = this.generateTextEvents(node);
                break;
            }
            case 5: {
                returnEvent = this.generateCommentEvents();
                break;
            }
            case 12: {
                returnEvent = this.generateCdataEvents();
                break;
            }
        }
        return returnEvent;
    }

    private int generateElementEvents(OMElement elt) {
        if (this.nodeStack == null) {
            this.nodeStack = new Stack();
        }
        int returnValue = 1;
        if (!this.nodeStack.isEmpty() && this.nodeStack.peek().equals(elt)) {
            returnValue = 2;
            this.nodeStack.pop();
        } else {
            this.nodeStack.push(elt);
        }
        return returnValue;
    }

    private int generateTextEvents(OMNode node) {
        OMText text;
        if (!this.isInlineMTOM() && node instanceof OMText && (text = (OMText)node).isOptimized()) {
            if (this.nodeStack == null) {
                this.nodeStack = new Stack();
            }
            if (!this.nodeStack.isEmpty() && this.nodeStack.peek().equals(text)) {
                this.nodeStack.pop();
                this.xopIncludeStart = false;
                return 2;
            }
            this.xopIncludeText = text;
            this.xopInclude = node.getOMFactory().createOMElement(XOP_INCLUDE);
            String cid = text.getContentID();
            this.xopInclude.addAttribute("href", "cid:" + cid, null);
            this.xopIncludeStart = true;
            this.nodeStack.push(text);
            return 1;
        }
        return 4;
    }

    private OMNode getNode() {
        if (this.lastNode == this.xopIncludeText) {
            return this.xopInclude;
        }
        return this.lastNode;
    }

    private int generateCommentEvents() {
        return 5;
    }

    private int generateCdataEvents() {
        return 12;
    }

    private int getCount(Iterator it) {
        int count = 0;
        if (it != null) {
            while (it.hasNext()) {
                it.next();
                ++count;
            }
        }
        return count;
    }

    private Object getItemFromIterator(Iterator it, int index) {
        int count = 0;
        Object returnObject = null;
        boolean found = false;
        if (it != null) {
            while (it.hasNext()) {
                returnObject = it.next();
                if (index != count++) continue;
                found = true;
                break;
            }
        }
        if (found) {
            return returnObject;
        }
        return null;
    }

    private QName getQName(OMElement element) {
        QName returnName;
        OMNamespace ns = element.getNamespace();
        String localPart = element.getLocalName();
        if (ns != null) {
            String prefix = ns.getPrefix();
            String uri = ns.getNamespaceURI();
            returnName = prefix == null || prefix.equals("") ? new QName(uri, localPart) : new QName(uri, localPart, prefix);
        } else {
            returnName = new QName(localPart);
        }
        return returnName;
    }

    private OMAttribute getAttribute(OMElement elt, int index) {
        OMAttribute returnAttrib = null;
        if (elt != null) {
            returnAttrib = (OMAttribute)this.getItemFromIterator(elt.getAllAttributes(), index);
        }
        return returnAttrib;
    }

    public void setParser(XMLStreamReader parser) {
        this.parser = parser;
    }

    private Map getAllNamespaces(OMNode contextNode) {
        if (!(contextNode instanceof OMContainer) || !(contextNode instanceof OMElement)) {
            return new HashMap();
        }
        LinkedHashMap nsMap = new LinkedHashMap();
        OMContainer context = (OMContainer)((Object)contextNode);
        while (context != null && !(context instanceof OMDocument)) {
            OMElement element = (OMElement)context;
            Iterator i = element.getAllDeclaredNamespaces();
            while (i != null && i.hasNext()) {
                this.addNamespaceToMap((OMNamespace)i.next(), nsMap);
            }
            if (element.getNamespace() != null) {
                this.addNamespaceToMap(element.getNamespace(), nsMap);
            }
            Iterator iter = element.getAllAttributes();
            while (iter != null && iter.hasNext()) {
                OMAttribute attr = (OMAttribute)iter.next();
                if (attr.getNamespace() == null) continue;
                this.addNamespaceToMap(attr.getNamespace(), nsMap);
            }
            context = ((OMElement)context).getParent();
        }
        return nsMap;
    }

    private void addNamespaceToMap(OMNamespace ns, Map map) {
        if (map.get(ns.getPrefix()) == null) {
            map.put(ns.getPrefix(), ns.getNamespaceURI());
        }
    }

    public OMXMLParserWrapper getBuilder() {
        return this.builder;
    }

    public boolean isClosed() {
        if (this.builder != null && this.builder instanceof StAXBuilder) {
            return ((StAXBuilder)this.builder).isClosed();
        }
        return this._isClosed;
    }

    public void releaseParserOnClose(boolean value) {
        if (this.builder != null && this.builder instanceof StAXBuilder) {
            ((StAXBuilder)this.builder).releaseParserOnClose(value);
            if (this.isClosed() && value) {
                this.parser = null;
            }
            return;
        }
        if (this.isClosed() && value) {
            this.parser = null;
        }
        this._releaseParserOnClose = value;
    }

    public DataHandler getDataHandler(String blobcid) {
        OMText text;
        DataHandler dh = null;
        if (this.builder != null && this.builder instanceof OMAttachmentAccessor) {
            dh = ((OMAttachmentAccessor)((Object)this.builder)).getDataHandler(blobcid);
        }
        if (dh == null && this.lastNode != null && this.lastNode instanceof OMText && (text = (OMText)this.lastNode).isOptimized() && blobcid.equals("cid:" + text.getContentID())) {
            dh = (DataHandler)text.getDataHandler();
        }
        return dh;
    }

    public boolean isInlineMTOM() {
        return this.inlineMTOM;
    }

    public void setInlineMTOM(boolean value) {
        this.inlineMTOM = value;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

