### R code from vignette source 'mosaics-example.Rnw'

###################################################
### code chunk number 1: preliminaries
###################################################
options(prompt = "R> ")


###################################################
### code chunk number 2: mosaics-prelim
###################################################
library("mosaics")


###################################################
### code chunk number 3: mosaicsRunAll (eval = FALSE)
###################################################
##      mosaicsRunAll( 
##          chipFile="/scratch/eland/STAT1_ChIP_eland_results.txt", 
##          chipFileFormat="eland_result", 
##          controlFile="/scratch/eland/STAT1_control_eland_results.txt", 
##          controlFileFormat="eland_result", 
##          binfileDir="/scratch/bin/", 
##          peakFile=c("/scratch/peak/STAT1_peak_list.bed", "/scratch/peak/STAT1_peak_list.gff"),
##          peakFileFormat=c("bed", "gff"),
##          reportSummary=TRUE, 
##          summaryFile="/scratch/reports/mosaics_summary.txt", 
##          reportExploratory=TRUE, 
##          exploratoryFile="/scratch/reports/mosaics_exploratory.pdf", 
##          reportGOF=TRUE, 
##          gofFile="/scratch/reports/mosaics_GOF.pdf",
##          byChr=FALSE,
##          excludeChr="chrM",
##          FDR=0.05, 
##          fragLen=200, 
##          binSize=fragLen,
##          capping=0,
##          bgEst="automatic",
##          signalModel="BIC",
##          parallel=TRUE,
##          nCore=8 )


###################################################
### code chunk number 4: constructBins (eval = FALSE)
###################################################
## constructBins( infile="/scratch/eland/STAT1_eland_results.txt", 
##     fileFormat="eland_result", outfileLoc="/scratch/eland/", 
##     byChr=FALSE, excludeChr="chrM", fragLen=200, binSize=200, capping=0 )


###################################################
### code chunk number 5: mosaicsExample-prelim
###################################################
library(mosaicsExample)


###################################################
### code chunk number 6: io-readbin
###################################################
exampleBinData <- readBins( type=c("chip","input"),
    fileName=c( system.file( file.path("extdata","chip_chr21.txt"), package="mosaicsExample"),
    system.file( file.path("extdata","input_chr21.txt"), package="mosaicsExample") ) )


###################################################
### code chunk number 7: io-bindata-show
###################################################
exampleBinData


###################################################
### code chunk number 8: io-bindata-print
###################################################
print(exampleBinData)[51680:51690,]


###################################################
### code chunk number 9: io-bindata-plot (eval = FALSE)
###################################################
## plot( exampleBinData )
## plot( exampleBinData, plotType="input" )


###################################################
### code chunk number 10: fig-bindata-plot-hist
###################################################
plot(exampleBinData)


###################################################
### code chunk number 11: fig-bindata-plot-input
###################################################
plot( exampleBinData, plotType="input" )


###################################################
### code chunk number 12: io-mosaicsfit
###################################################
exampleFit <- mosaicsFit( exampleBinData, analysisType="IO", bgEst="automatic" )


###################################################
### code chunk number 13: io-mosaicsfit-show
###################################################
exampleFit


###################################################
### code chunk number 14: io-mosaicsfit-plot (eval = FALSE)
###################################################
## plot(exampleFit)


###################################################
### code chunk number 15: fig-mosaicsfit-plot
###################################################
plot(exampleFit)


###################################################
### code chunk number 16: ts-mosaicspeak
###################################################
examplePeak <- mosaicsPeak( exampleFit, signalModel="2S", FDR=0.05, 
maxgap=200, minsize=50, thres=10 )


###################################################
### code chunk number 17: io-mosaicspeak-show
###################################################
examplePeak


###################################################
### code chunk number 18: io-mosaicspeak-print
###################################################
print(examplePeak)[1:15,]


###################################################
### code chunk number 19: io-mosaicspeak-export
###################################################
export( examplePeak, type="txt", filename="TSpeakList.txt" )
export( examplePeak, type="bed", filename="TSpeakList.bed" )
export( examplePeak, type="gff", filename="TSpeakList.gff" )


###################################################
### code chunk number 20: ts-readbin
###################################################
exampleBinData <- readBins( type=c("chip","input","M","GC","N"),
    fileName=c( system.file( file.path("extdata","chip_chr21.txt"), package="mosaicsExample"),
    system.file( file.path("extdata","input_chr21.txt"), package="mosaicsExample"),
    system.file( file.path("extdata","M_chr21.txt"), package="mosaicsExample"),
    system.file( file.path("extdata","GC_chr21.txt"), package="mosaicsExample"),
    system.file( file.path("extdata","N_chr21.txt"), package="mosaicsExample") ) )


###################################################
### code chunk number 21: ts-bindata-plot
###################################################
plot( exampleBinData, plotType="M" )
plot( exampleBinData, plotType="GC" )
plot( exampleBinData, plotType="M|input" )
plot( exampleBinData, plotType="GC|input" )  


###################################################
### code chunk number 22: fig-bindata-plot-M
###################################################
plot( exampleBinData, plotType="M" )


###################################################
### code chunk number 23: fig-bindata-plot-GC
###################################################
plot( exampleBinData, plotType="GC" )


###################################################
### code chunk number 24: fig-bindata-plot-M-input
###################################################
plot( exampleBinData, plotType="M|input" )


###################################################
### code chunk number 25: fig-bindata-plot-GC-input
###################################################
plot( exampleBinData, plotType="GC|input" )


###################################################
### code chunk number 26: ts-mosaicsfit (eval = FALSE)
###################################################
## exampleFit <- mosaicsFit( exampleBinData, analysisType="TS", bgEst="automatic" )


###################################################
### code chunk number 27: os-mosaicspeak (eval = FALSE)
###################################################
## OneSamplePeak <- mosaicsPeak( OneSampleFit, signalModel="2S", FDR=0.05,
## maxgap=200, minsize=50, thres=10 )


###################################################
### code chunk number 28: os-readbin (eval = FALSE)
###################################################
## exampleBinData <- readBins( type=c("chip","M","GC","N"),
##     fileName=c( system.file( file.path("extdata","chip_chr21.txt"), package="mosaicsExample"),
##     system.file( file.path("extdata","M_chr21.txt"), package="mosaicsExample"),
##     system.file( file.path("extdata","GC_chr21.txt"), package="mosaicsExample"),
##     system.file( file.path("extdata","N_chr21.txt"), package="mosaicsExample") ) )


###################################################
### code chunk number 29: os-mosaicsfit (eval = FALSE)
###################################################
## exampleFit <- mosaicsFit( exampleBinData, analysisType="OS", bgEst="automatic" )


###################################################
### code chunk number 30: os-mosaicspeak (eval = FALSE)
###################################################
## exampleFit <- mosaicsPeak( exampleFit, signalModel="2S", FDR=0.05,
## maxgap=200, minsize=50, thres=10 )


