/**************************************************************************
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
***************************************************************************/
/*
@author Mingshu Cao
@date                    20/08/2009 4:58:13 p.m.
@update                  7/03/2011 4:51:08 p.m.
#version to be jar-ed    8/03/2011 4:27:04 p.m.
TO-DO list: 1)add premz list --DONE
            2)one function for DIMS as that publised method
            3)MS2 distance matrix?
            4)may need to get base peak information from scanheader,  
                         getBasePeakMz() and getBasePeakIntensity()  
            
Known issues: 
           --not for old mzXML where filterLine is not presented                        
*/
import java.util.ArrayList;
import java.util.Arrays;
import org.systemsbiology.jrap.stax.MSXMLParser;
import org.systemsbiology.jrap.stax.ScanHeader;
import org.systemsbiology.jrap.stax.Scan;


public class XCMS {             
    private int msLevel;
    private String polarity; //scan-level info 
    private double[] premz; 
    private String[] cid;  
    private double rt;
    private double tic;
    private double[] mz;
    private double[] intensity;
     
    public void setMsLevel(int iLevel){
      msLevel=iLevel;
    }
    public void setPolarity(String iPolarity){
      polarity=iPolarity; 
    }
    public void setPremz(double[] precursors){
      premz=precursors;
    }
    public void setCid(String[] iCid){
      //parse from filterLine, test on LTQ
      cid=iCid;
    }
    public void setRt(double iRt){
      rt=iRt;
    }
    public void setTic(double iTic){
      tic=iTic;
    }
    public void setMz(double[] iMz){
      mz=iMz;
    }
    public void setIntensity(double[] iIntensity){
      intensity=iIntensity;
    }
    public int getMsLevel(){
      return msLevel;
    }
    public String getPolarity(){
      return polarity; 
    }
    public double[] getPremz(){
      return premz;
    }
    public String[] getCid(){
      return cid;
    }
    public double getRt(){
      return rt;
    }
    public double getTic(){
      return tic;
    }
    public double[] getMz(){
      return mz;
    }
    public double[] getIntensity(){
      return intensity;
    }
    

  public static ArrayList<XCMS> getMSData(String filename){
    MSXMLParser parser=new MSXMLParser(filename);
    int N=parser.getScanCount();
    ArrayList<XCMS> msd=new ArrayList<XCMS>(N);
    
    for(int i=1; i<=N; i++){
      XCMS msScan=new XCMS();
  
      Scan oneScan=parser.rap(i);
      ScanHeader oneScanHeader=oneScan.getHeader();
      msScan.setRt(oneScanHeader.getDoubleRetentionTime());
      msScan.setTic((double)oneScanHeader.getTotIonCurrent()); //float initially
      
      int msLevel=oneScanHeader.getMsLevel();
      msScan.setMsLevel(msLevel);
         
      //add polarity returns  "+" , add fields later
      String polarity=oneScanHeader.getPolarity();
      msScan.setPolarity(polarity);
      
      msScan.setPremz(null); 
      if(msLevel > 1){   
        //parse String filter to double[], MS1--null, MS2, length=1 ....
        String filterLine=oneScanHeader.getFilterLine();
        
        if(filterLine.isEmpty()){
         System.err.println("filterLine is not there, please use new version of mzXML");  
        }
     
        String[] inside=filterLine.split(" ");
        ArrayList<Double> precursors=new ArrayList<Double>();
        ArrayList<String> cids=new ArrayList<String>();
        for(String s : inside){
          if(s.contains("@")){                         //only string containing @
            String[] tmp=s.split("@");                 //in pair of premz@cidTime
            precursors.add(Double.valueOf(tmp[0]));    //take premz
            cids.add(tmp[1]);
            //System.out.println(tmp[1]);
          }
        }      
        msScan.setPremz(list2array(precursors));
        msScan.setCid(list2array2(cids));
       }//setPremz
      
      double[][] mzIntenPair=oneScan.getMassIntensityList();
      msScan.setMz(mzIntenPair[0]);
      msScan.setIntensity(mzIntenPair[1]);
       
      msd.add(msScan);
    }//for
   
    return msd;   
  }

  public static ArrayList<XCMS> getMSn(ArrayList<XCMS> msd, int msLevel){
    ArrayList<XCMS> msn=new ArrayList<XCMS>();
    
    for(int k=0; k<msd.size(); k++){
      if(msd.get(k).getMsLevel()==msLevel)
        msn.add(msd.get(k));
    }
        
    return msn;   
  }

  
  public static int[] callMSLevels(ArrayList<XCMS> msn){
    int[] levels=new int[msn.size()];
    for(int k=0; k<msn.size(); k++){
      levels[k]=msn.get(k).getMsLevel();
    }
    
    return levels; 
  }
  
  
  public static String[] callPolarity(ArrayList<XCMS> msn){
    String[] polarity=new String[msn.size()];
    for(int k=0; k<msn.size(); k++){
      polarity[k]=msn.get(k).getPolarity();
    }
    
    return polarity; 
  }
   
  
  public static double[] callCid(ArrayList<XCMS> msn){
    int N=msn.size();
    double[] cid=new double[N];
    for(int k=0; k<N; k++){
      String[] cidString=msn.get(k).getCid(); 
      String tmp=cidString[0].substring(3);      //remove "cid" 
      cid[k]=Double.parseDouble(tmp);
    }
     return cid;
  }

  public static double[] callRT(ArrayList<XCMS> msn){
    double[] rt=new double[msn.size()];
    for(int k=0; k<msn.size(); k++){
      rt[k]=msn.get(k).getRt();
    }
    
    return rt; 
  }
  
  public static double[] callTic(ArrayList<XCMS> msn){
    double[] tic=new double[msn.size()];
    for(int k=0; k<msn.size(); k++){
      tic[k]=msn.get(k).getTic();
    }
    
    return tic; 
  }
  
  
  public static double[] callMZ(ArrayList<XCMS> msn){
     ArrayList<Double> mz=new ArrayList<Double>(); //size in unknown
     for(int k=0; k<msn.size(); k++){
       double[] tmp=msn.get(k).getMz();           //add double[] each time
       for(int j=0; j<tmp.length; j++){
         mz.add(tmp[j]); 
       }                
     }
      
    return list2array(mz);  
  }

   public static double[] callIntensity(ArrayList<XCMS> msn){
     ArrayList<Double> inten=new ArrayList<Double>();    //size in unknown
     for(int k=0; k<msn.size(); k++){
       double[] tmp=msn.get(k).getIntensity();           //add double[] each time
       for(int j=0; j<tmp.length; j++){
         inten.add(tmp[j]); 
       }                
     }
       
    return list2array(inten);  
  }

 
  public static double[][] callPremz(ArrayList<XCMS> msn){
     //ArrayList<Double> premz=new ArrayList<Double>();
     double[][] premz=new double[msn.size()][];  
     for(int i=0; i<msn.size(); i++){
       premz[i]=msn.get(i).getPremz();    
     }
     
     return premz;  
  }
  
  
  public static double[] getIonEIC(ArrayList<XCMS> msn, double mzStart, double mzEnd){
    double[] ionEIC=new double[msn.size()];
    
    for(int i=0; i<msn.size(); i++){
      double[] mz=msn.get(i).getMz();
      double[] inten=msn.get(i).getIntensity();
      //take avergae of inten if mz is within the range, they are co-elute ions
      ArrayList<Double> tmp=new ArrayList<Double>();
      for(int j=0; j<mz.length; j++){
        if(mz[j]>=mzStart && mz[j]< mzEnd)
          //targetMz.add(mz[j]);
          tmp.add(inten[j]);
      }
      double ionIntensity=calMedian(list2array(tmp));
      ionEIC[i]=ionIntensity;
    }
    
    return ionEIC;       
  }
  
  public static double[] getIonEIC1(ArrayList<XCMS> msn, double qIon, double winSize){
    double tol=winSize/2;
    //ArrayList<Double> targetMz=new ArrayList<Double>();
    double[] ionEIC=new double[msn.size()];
    
    for(int i=0; i<msn.size(); i++){
      double[] mz=msn.get(i).getMz();
      double[] inten=msn.get(i).getIntensity();
      //take avergae of inten if mz is within the range, they are co-elute ions
      ArrayList<Double> tmp=new ArrayList<Double>();
      for(int j=0; j<mz.length; j++){
        if(mz[j]>=(qIon-tol) && mz[j]<(qIon+tol))
          //targetMz.add(mz[j]);
          tmp.add(inten[j]);
      }
      double ionIntensity=calMedian(list2array(tmp));
      ionEIC[i]=ionIntensity;
    }//outer for
    
    return ionEIC;       
  }
  
  //To use generic combine two "list2array" methods!!
  public static double[] list2array(ArrayList<Double> arrayList){
    double[] dArray=new double[arrayList.size()];
    int offset=0;
    for(double val : arrayList)
      dArray[offset++] = val;
      
    return dArray;     
  }

  public static String[] list2array2(ArrayList<String> arrayList){
    String[] sArray=new String[arrayList.size()];
    int offset=0;
    for(String val : arrayList)
      sArray[offset++] = val;
      
    return sArray;     
  }
  
  public static double calMedian(double[] x){
    Arrays.sort(x);
    if (x.length == 0)
     return 0;
    else if (x.length % 2 == 1)
     return x[x.length/2];
    else
     return (x[x.length/2] + x[(x.length/2)-1])/2.0;
 }
 /* 
  * or model specturm as treemap
  public static double distMS2(doube mz1, double inten1, double mz2, double inten2, int top){
    
  }*/

/****************************** main ************************************/
/* Test code removed
/****************************** main ************************************/  
}//END     


