### R code from vignette source 'gwascat.Rnw'

###################################################
### code chunk number 1: getlib
###################################################
library(gwascat)


###################################################
### code chunk number 2: lk1
###################################################
if (length(grep("gwascat", search()))>0) detach("package:gwascat")


###################################################
### code chunk number 3: lk2
###################################################
library(gwascat)
objects("package:gwascat")


###################################################
### code chunk number 4: lkgr
###################################################
gwrngs


###################################################
### code chunk number 5: lktr
###################################################
topTraits(gwrngs)


###################################################
### code chunk number 6: lklocs
###################################################
subsetByTraits(gwrngs, tr="LDL cholesterol")[1:3]


###################################################
### code chunk number 7: dobig (eval = FALSE)
###################################################
## library(pd.genomewidesnp.6)
## con = pd.genomewidesnp.6@getdb()
## locon6 = dbGetQuery(con, 
##    "select dbsnp_rs_id, chrom, physical_pos from featureSet limit 10000")


###################################################
### code chunk number 8: doloc
###################################################
data(locon6)
rson6 = as.character(locon6[[1]])
rson6[1:5]


###################################################
### code chunk number 9: lkdtab
###################################################
intr = gwrngs[ intersect(getRsids(gwrngs), rson6) ]
sort(table(getTraits(intr)), decreasing=TRUE)[1:10]


###################################################
### code chunk number 10: lkexp
###################################################
gr6.0 = GRanges(seqnames=ifelse(is.na(locon6$chrom),0,locon6$chrom), 
       IRanges(ifelse(is.na(locon6$phys),1,locon6$phys), width=1))
elementMetadata(gr6.0)$rsid = as.character(locon6$dbsnp_rs_id)
seqlevels(gr6.0) = paste("chr", seqlevels(gr6.0), sep="")


###################################################
### code chunk number 11: dosub
###################################################
ag = function(x) as(x, "GRanges")
ovraw = subsetByOverlaps(ag(gwrngs), gr6.0)
length(ovraw)
ovaug = subsetByOverlaps(ag(gwrngs+500), gr6.0)
length(ovaug)


###################################################
### code chunk number 12: dosub
###################################################
rawrs = elementMetadata(ovraw)$SNPs
augrs = elementMetadata(ovaug)$SNPs
gwrngs[augrs]


###################################################
### code chunk number 13: lkrelax
###################################################
setdiff( getTraits(gwrngs[augrs]), getTraits(gwrngs[rawrs]) )


###################################################
### code chunk number 14: lkcout
###################################################
data(gg17N) # translated from GGdata chr 17 calls using ABmat2nuc
gg17N[1:5,1:5]


###################################################
### code chunk number 15: dorun
###################################################
h17 = riskyAlleleCount(gg17N, matIsAB=FALSE, chr="ch17")
h17[1:5,1:5]
table(as.numeric(h17))


###################################################
### code chunk number 16: domo
###################################################
gwr = gwrngs
gwr = gwr[colnames(h17),]
elementMetadata(gwr) = cbind(elementMetadata(gwr), DataFrame(t(h17)))
sn = rownames(h17)
gwr[,c("Disease.Trait", sn[1:4])]


###################################################
### code chunk number 17: getbase
###################################################
data(low17)
low17


###################################################
### code chunk number 18: lkggd
###################################################
data(g17SM)
g17SM


###################################################
### code chunk number 19: dog
###################################################
data(gw6.rs_17)
g17SM = g17SM[, intersect(colnames(g17SM), gw6.rs_17)]
dim(g17SM)


###################################################
### code chunk number 20: lkrul
###################################################
data(rules_6.0_1kg_17)
rules_6.0_1kg_17[1:5,]


###################################################
### code chunk number 21: lksum
###################################################
summary(rules_6.0_1kg_17)


###################################################
### code chunk number 22: lkov
###################################################
length(intersect(colnames(g17SM), values(gwrngs)$SNPs))


###################################################
### code chunk number 23: doimp
###################################################
exg17 = impute.snps(rules_6.0_1kg_17, g17SM)


###################################################
### code chunk number 24: lkl
###################################################
length(intersect(colnames(exg17), values(gwrngs)$SNPs))


###################################################
### code chunk number 25: getdo
###################################################
library(DO.db)
DO()


###################################################
### code chunk number 26: getallt
###################################################
alltob = unlist(mget(mappedkeys(DOTERM), DOTERM))
allt = sapply(alltob, Term)
allt[1:5]


###################################################
### code chunk number 27: dohit
###################################################
cattra = elementMetadata(gwrngs)$Disease.Trait
mat = match(tolower(cattra), tolower(allt))
catDO = names(allt)[mat]
catDO[1:50]
mean(is.na(catDO))


###################################################
### code chunk number 28: dogr
###################################################
unique(cattra[is.na(catDO)])[1:20]
nomatch = cattra[is.na(catDO)]


###################################################
### code chunk number 29: getrs
###################################################
if ("SNPlocs.Hsapiens.dbSNP.20110815" %in% installed.packages()[,1])
suppressWarnings(chklocs("20"))


