### R code from vignette source 'clusterProfiler.Rnw'

###################################################
### code chunk number 1: options
###################################################
options(width=60)
require(clusterProfiler)


###################################################
### code chunk number 2: groupGO
###################################################
data(gcSample)
x <- groupGO(gene=gcSample[[1]],
             organism="human",
             ont="CC",
             level=2,
             readable=TRUE)
head(summary(x))


###################################################
### code chunk number 3: enrichGO
###################################################
y <- enrichGO(gene=gcSample[[2]],
              organism="human",
              ont="MF",
              pvalueCutoff=0.01,
              qvalueCutoff=0.05,
              readable=TRUE)
head(summary(y))


###################################################
### code chunk number 4: enrichKEGG
###################################################
z <- enrichKEGG(gene=gcSample[[3]],
                organism="human",
                pvalueCutoff=0.05,
                qvalueCutoff=0.05,
                readable=TRUE)
head(summary(z))


###################################################
### code chunk number 5: plotenrichGO
###################################################
plot(y, type="bar", title="MF Enrichment analysis", showCategory=10)


###################################################
### code chunk number 6: plot method (eval = FALSE)
###################################################
## plot(x, type="bar", order=FALSE, drop=TRUE)
## plot(z, type="bar", font.size=12)


###################################################
### code chunk number 7: plotgroupGO
###################################################
plot(x, type="cnet", showCategory=5, output="fixed")


###################################################
### code chunk number 8: plot method 2 (eval = FALSE)
###################################################
## plot(y, type="cnet", categorySize="geneNum")
## plot(z, type="cnet", categorySize="pvalue", output="interactive")


###################################################
### code chunk number 9: compareCluster (eval = FALSE)
###################################################
## xx <- compareCluster(gcSample,
##                      fun="enrichGO",
##                      ont="CC",
##                      organism="human",
##                      pvalueCutoff=0.05,
##                      qvalueCutoff=0.05)
## plot(xx)


###################################################
### code chunk number 10: plot method (eval = FALSE)
###################################################
## plot(xx, type="bar", by="percentage")
## plot(xx, type="bar", by="count")


###################################################
### code chunk number 11: clusterProfiler.Rnw:333-334
###################################################
sessionInfo()


