/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.swing.handler;

import com.mxgraph.swing.handler.mxCellMarker;
import com.mxgraph.swing.handler.mxGraphTransferHandler;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.util.mxGraphTransferable;
import com.mxgraph.swing.util.mxMouseControl;
import com.mxgraph.util.mxCellRenderer;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxGraph;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.TooManyListenersException;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;

public class mxGraphHandler
extends mxMouseControl
implements DropTargetListener {
    private static final long serialVersionUID = 3241109976696510225L;
    public static Cursor MOVE_CURSOR = new Cursor(13);
    protected mxGraphComponent graphComponent;
    protected boolean cloneEnabled = true;
    protected boolean moveEnabled = true;
    protected boolean selectEnabled = true;
    protected boolean removeCellsFromParent = true;
    protected boolean imagePreview = true;
    protected boolean centerPreview = true;
    protected boolean keepOnTop = true;
    protected transient Object[] cells;
    protected transient ImageIcon dragImage;
    protected transient Point first;
    protected transient Object cell;
    protected transient Object initialCell;
    protected transient Object[] dragCells;
    protected transient mxCellMarker marker;
    protected transient boolean canImport;
    protected transient mxRectangle cellBounds;
    protected transient mxRectangle bbox;
    protected transient mxRectangle transferBounds;
    private transient boolean gridEnabledEvent = false;
    protected transient boolean constrainedEvent = false;

    public mxGraphHandler(final mxGraphComponent mxGraphComponent2) {
        this.graphComponent = mxGraphComponent2;
        this.marker = this.createMarker();
        mxGraphComponent2.getGraphControl().add((Component)this, 0);
        mxGraphComponent2.getGraphControl().addMouseListener(this);
        mxGraphComponent2.getGraphControl().addMouseMotionListener(this);
        mxGraphComponent.mxMouseRedirector mxMouseRedirector2 = new mxGraphComponent.mxMouseRedirector(mxGraphComponent2);
        this.addMouseMotionListener(mxMouseRedirector2);
        this.addMouseListener(mxMouseRedirector2);
        DragGestureListener dragGestureListener = new DragGestureListener(){

            public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
                mxGraphTransferable mxGraphTransferable2;
                TransferHandler transferHandler;
                if (mxGraphComponent2.isDragEnabled() && mxGraphHandler.this.first != null && (transferHandler = mxGraphComponent2.getTransferHandler()) instanceof mxGraphTransferHandler && (mxGraphTransferable2 = (mxGraphTransferable)((mxGraphTransferHandler)transferHandler).createTransferable(mxGraphComponent2)) != null) {
                    dragGestureEvent.startDrag(null, mxConstants.EMPTY_IMAGE, new Point(), mxGraphTransferable2, new DragSourceAdapter(){

                        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
                            ((mxGraphTransferHandler)transferHandler).exportDone(mxGraphComponent2, mxGraphTransferable2, 0);
                            mxGraphHandler.this.first = null;
                        }
                    });
                }
            }
        };
        DragSource dragSource = new DragSource();
        dragSource.createDefaultDragGestureRecognizer(mxGraphComponent2.getGraphControl(), 3, dragGestureListener);
        DropTarget dropTarget = mxGraphComponent2.getDropTarget();
        try {
            if (dropTarget != null) {
                dropTarget.addDropTargetListener(this);
            }
        }
        catch (TooManyListenersException tooManyListenersException) {
            // empty catch block
        }
        this.setOpaque(false);
        this.setVisible(false);
        this.setBorder(mxConstants.PREVIEW_BORDER);
    }

    protected mxCellMarker createMarker() {
        mxCellMarker mxCellMarker2 = new mxCellMarker(this.graphComponent, Color.BLUE){
            private static final long serialVersionUID = -8451338653189373347L;

            public boolean isEnabled() {
                return this.graphComponent.getGraph().isDropEnabled();
            }

            public Object getCell(MouseEvent mouseEvent) {
                boolean bl;
                TransferHandler transferHandler = this.graphComponent.getTransferHandler();
                boolean bl2 = transferHandler instanceof mxGraphTransferHandler && ((mxGraphTransferHandler)transferHandler).isLocalDrag();
                mxGraph mxGraph2 = this.graphComponent.getGraph();
                Object object = super.getCell(mouseEvent);
                Object[] objectArray = bl2 ? mxGraph2.getSelectionCells() : mxGraphHandler.this.dragCells;
                object = mxGraph2.getDropTarget(objectArray, mouseEvent.getPoint(), object);
                boolean bl3 = bl = this.graphComponent.isCloneEvent(mouseEvent) && mxGraphHandler.this.cloneEnabled;
                if (bl2 && object != null && objectArray.length > 0 && !bl && mxGraph2.getModel().getParent(objectArray[0]) == object) {
                    object = null;
                }
                return object;
            }
        };
        mxCellMarker2.setSwimlaneContentEnabled(true);
        return mxCellMarker2;
    }

    public mxGraphComponent getGraphComponent() {
        return this.graphComponent;
    }

    public boolean isCloneEnabled() {
        return this.cloneEnabled;
    }

    public void setCloneEnabled(boolean bl) {
        this.cloneEnabled = bl;
    }

    public boolean isMoveEnabled() {
        return this.moveEnabled;
    }

    public void setMoveEnabled(boolean bl) {
        this.moveEnabled = bl;
    }

    public boolean isSelectEnabled() {
        return this.selectEnabled;
    }

    public void setSelectEnabled(boolean bl) {
        this.selectEnabled = bl;
    }

    public boolean isRemoveCellsFromParent() {
        return this.removeCellsFromParent;
    }

    public void setRemoveCellsFromParent(boolean bl) {
        this.removeCellsFromParent = bl;
    }

    public boolean isImagePreview() {
        return this.imagePreview;
    }

    public void setImagePreview(boolean bl) {
        this.imagePreview = bl;
    }

    public boolean isCenterPreview() {
        return this.centerPreview;
    }

    public void setCenterPreview(boolean bl) {
        this.centerPreview = bl;
    }

    public void updateDragImage(Object[] objectArray) {
        BufferedImage bufferedImage;
        this.dragImage = null;
        if (objectArray != null && objectArray.length > 0 && (bufferedImage = mxCellRenderer.createBufferedImage(this.graphComponent.getGraph(), objectArray, this.graphComponent.getGraph().getView().getScale(), null, this.graphComponent.isAntiAlias(), null, this.graphComponent.getCanvas())) != null) {
            this.dragImage = new ImageIcon(bufferedImage);
            this.setSize(this.dragImage.getIconWidth(), this.dragImage.getIconHeight());
            this.getParent().setComponentZOrder(this, 0);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.graphComponent.isEnabled() && this.isEnabled() && !mouseEvent.isConsumed()) {
            Cursor cursor = this.getCursor(mouseEvent);
            if (cursor != null) {
                this.graphComponent.getGraphControl().setCursor(cursor);
                mouseEvent.consume();
            } else {
                this.graphComponent.getGraphControl().setCursor(new Cursor(0));
            }
        }
    }

    protected Cursor getCursor(MouseEvent mouseEvent) {
        Object object;
        Cursor cursor = null;
        if (this.isMoveEnabled() && (object = this.graphComponent.getCellAt(mouseEvent.getX(), mouseEvent.getY(), false)) != null) {
            if (this.graphComponent.isFoldingEnabled() && this.graphComponent.hitFoldingIcon(object, mouseEvent.getX(), mouseEvent.getY())) {
                cursor = new Cursor(12);
            } else if (this.graphComponent.getGraph().isCellMovable(object)) {
                cursor = MOVE_CURSOR;
            }
        }
        return cursor;
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        boolean bl;
        JComponent jComponent = mxGraphHandler.getDropTarget(dropTargetDragEvent);
        TransferHandler transferHandler = jComponent.getTransferHandler();
        boolean bl2 = bl = transferHandler instanceof mxGraphTransferHandler && ((mxGraphTransferHandler)transferHandler).isLocalDrag();
        if (bl) {
            this.canImport = true;
        } else {
            boolean bl3 = this.canImport = this.graphComponent.isImportEnabled() && transferHandler.canImport(jComponent, dropTargetDragEvent.getCurrentDataFlavors());
        }
        if (this.canImport) {
            this.transferBounds = null;
            this.setVisible(false);
            try {
                Transferable transferable = dropTargetDragEvent.getTransferable();
                if (transferable.isDataFlavorSupported(mxGraphTransferable.dataFlavor)) {
                    mxGraphTransferable mxGraphTransferable2 = (mxGraphTransferable)transferable.getTransferData(mxGraphTransferable.dataFlavor);
                    this.dragCells = mxGraphTransferable2.getCells();
                    if (mxGraphTransferable2.getBounds() != null) {
                        mxGraph mxGraph2 = this.graphComponent.getGraph();
                        double d = mxGraph2.getView().getScale();
                        this.transferBounds = mxGraphTransferable2.getBounds();
                        mxRectangle mxRectangle2 = new mxRectangle(this.transferBounds);
                        mxRectangle2.setWidth(mxRectangle2.getWidth() * d + 1.0);
                        mxRectangle2.setHeight(mxRectangle2.getHeight() * d + 1.0);
                        this.setBounds(mxRectangle2.getRectangle());
                        if (this.imagePreview) {
                            if (bl) {
                                this.updateDragImage(mxGraph2.getMovableCells(this.dragCells));
                            } else {
                                Object[] objectArray = this.graphComponent.getImportableCells(this.dragCells);
                                this.updateDragImage(objectArray);
                                if (objectArray == null || objectArray.length == 0) {
                                    this.canImport = false;
                                    dropTargetDragEvent.rejectDrag();
                                    return;
                                }
                            }
                        }
                        this.setVisible(true);
                    }
                }
                dropTargetDragEvent.acceptDrag(3);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.graphComponent.isEnabled() && this.isEnabled() && !mouseEvent.isConsumed() && !this.graphComponent.isForceMarqueeEvent(mouseEvent)) {
            this.initialCell = this.cell = this.graphComponent.getCellAt(mouseEvent.getX(), mouseEvent.getY(), false);
            if (this.cell != null) {
                if (this.isSelectEnabled() && !this.graphComponent.getGraph().isCellSelected(this.cell)) {
                    this.graphComponent.selectCellForEvent(this.cell, mouseEvent);
                    this.cell = null;
                }
                if (this.isMoveEnabled() && !mouseEvent.isPopupTrigger()) {
                    this.start(mouseEvent);
                    mouseEvent.consume();
                }
            } else if (mouseEvent.isPopupTrigger()) {
                this.graphComponent.getGraph().clearSelection();
            }
        }
    }

    public Object[] getCells(Object object) {
        mxGraph mxGraph2 = this.graphComponent.getGraph();
        return mxGraph2.getMovableCells(mxGraph2.getSelectionCells());
    }

    public void start(MouseEvent mouseEvent) {
        mxGraph mxGraph2 = this.graphComponent.getGraph();
        this.cells = this.getCells(this.initialCell);
        this.cellBounds = mxGraph2.getView().getBounds(this.cells);
        if (this.cellBounds != null) {
            this.getParent().setComponentZOrder(this, 0);
            this.bbox = mxGraph2.getView().getBoundingBox(this.cells);
            Rectangle rectangle = this.cellBounds.getRectangle();
            ++rectangle.width;
            ++rectangle.height;
            this.setBounds(rectangle);
        }
        this.first = mouseEvent.getPoint();
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (this.canImport) {
            this.mouseDragged(this.createEvent(dropTargetDragEvent));
            mxGraphTransferHandler mxGraphTransferHandler2 = mxGraphHandler.getGraphTransferHandler(dropTargetDragEvent);
            if (mxGraphTransferHandler2 != null) {
                mxGraph mxGraph2 = this.graphComponent.getGraph();
                double d = mxGraph2.getView().getScale();
                Point point = SwingUtilities.convertPoint(this.graphComponent, dropTargetDragEvent.getLocation(), this.graphComponent.getGraphControl());
                point = this.graphComponent.snapScaledPoint(new mxPoint(point)).getPoint();
                mxGraphTransferHandler2.setLocation(new Point(point));
                int n = 0;
                int n2 = 0;
                if (this.centerPreview && this.transferBounds != null) {
                    n = (int)((long)n - Math.round(this.transferBounds.getWidth() * d / 2.0));
                    n2 = (int)((long)n2 - Math.round(this.transferBounds.getHeight() * d / 2.0));
                }
                mxGraphTransferHandler2.setOffset(new Point((int)mxGraph2.snap((double)n / d), (int)mxGraph2.snap((double)n2 / d)));
                point.translate(n, n2);
                if (this.transferBounds != null && this.dragImage != null) {
                    n = (int)Math.round(((double)(this.dragImage.getIconWidth() - 2) - this.transferBounds.getWidth() * d) / 2.0);
                    n2 = (int)Math.round(((double)(this.dragImage.getIconHeight() - 2) - this.transferBounds.getHeight() * d) / 2.0);
                    point.translate(-n, -n2);
                }
                if (!mxGraphTransferHandler2.isLocalDrag()) {
                    this.setLocation(point.x, point.y);
                }
            }
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    public Point convertPoint(Point point) {
        point = SwingUtilities.convertPoint(this.graphComponent, point, this.graphComponent.getGraphControl());
        point.x -= this.graphComponent.getHorizontalScrollBar().getValue();
        point.y -= this.graphComponent.getVerticalScrollBar().getValue();
        return point;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.graphComponent.getGraphControl().scrollRectToVisible(new Rectangle(mouseEvent.getPoint()));
        if (!mouseEvent.isConsumed()) {
            this.gridEnabledEvent = this.graphComponent.isGridEnabledEvent(mouseEvent);
            this.constrainedEvent = this.graphComponent.isConstrainedEvent(mouseEvent);
            if (this.constrainedEvent && this.first != null) {
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                if (Math.abs(mouseEvent.getX() - this.first.x) > Math.abs(mouseEvent.getY() - this.first.y)) {
                    n2 = this.first.y;
                } else {
                    n = this.first.x;
                }
                mouseEvent = new MouseEvent(mouseEvent.getComponent(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), n, n2, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
            }
            if (this.isVisible()) {
                this.marker.process(mouseEvent);
            }
            if (this.first != null && this.cellBounds != null) {
                double d = mouseEvent.getX() - this.first.x;
                double d2 = mouseEvent.getY() - this.first.y;
                this.setLocation(this.getPreviewLocation(mouseEvent, this.gridEnabledEvent));
                if (!this.isVisible() && this.graphComponent.isSignificant(d, d2)) {
                    if (this.imagePreview && this.dragImage == null && !this.graphComponent.isDragEnabled()) {
                        this.updateDragImage(this.cells);
                    }
                    this.setVisible(true);
                }
                mouseEvent.consume();
            }
        }
    }

    protected Point getPreviewLocation(MouseEvent mouseEvent, boolean bl) {
        int n = 0;
        int n2 = 0;
        if (this.first != null && this.cellBounds != null) {
            mxGraph mxGraph2 = this.graphComponent.getGraph();
            double d = mxGraph2.getView().getScale();
            mxPoint mxPoint2 = mxGraph2.getView().getTranslate();
            double d2 = mouseEvent.getX() - this.first.x;
            double d3 = mouseEvent.getY() - this.first.y;
            double d4 = (this.cellBounds.getX() + d2) / d - mxPoint2.getX();
            double d5 = (this.cellBounds.getY() + d3) / d - mxPoint2.getY();
            if (bl) {
                d4 = mxGraph2.snap(d4);
                d5 = mxGraph2.snap(d5);
            }
            n = (int)Math.round((d4 + mxPoint2.getX()) * d) + (int)Math.round(this.bbox.getX()) - (int)Math.round(this.cellBounds.getX());
            n2 = (int)Math.round((d5 + mxPoint2.getY()) * d) + (int)Math.round(this.bbox.getY()) - (int)Math.round(this.cellBounds.getY());
        }
        return new Point(n, n2);
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        mxGraphTransferHandler mxGraphTransferHandler2 = mxGraphHandler.getGraphTransferHandler(dropTargetEvent);
        if (mxGraphTransferHandler2 != null) {
            mxGraphTransferHandler2.setLocation(null);
        }
        this.dragCells = null;
        this.setVisible(false);
        this.marker.reset();
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        if (this.canImport) {
            mxGraphTransferHandler mxGraphTransferHandler2 = mxGraphHandler.getGraphTransferHandler(dropTargetDropEvent);
            MouseEvent mouseEvent = this.createEvent(dropTargetDropEvent);
            if (mxGraphTransferHandler2 != null && !mxGraphTransferHandler2.isLocalDrag()) {
                mouseEvent.consume();
            }
            this.mouseReleased(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.graphComponent.isEnabled() && this.isEnabled() && !mouseEvent.isConsumed()) {
            mxGraph mxGraph2 = this.graphComponent.getGraph();
            double d = 0.0;
            double d2 = 0.0;
            if (this.first != null && this.cellBounds != null) {
                double d3 = mxGraph2.getView().getScale();
                mxPoint mxPoint2 = mxGraph2.getView().getTranslate();
                d = mouseEvent.getX() - this.first.x;
                d2 = mouseEvent.getY() - this.first.y;
                double d4 = (this.cellBounds.getX() + d) / d3 - mxPoint2.getX();
                double d5 = (this.cellBounds.getY() + d2) / d3 - mxPoint2.getY();
                if (this.gridEnabledEvent) {
                    d4 = mxGraph2.snap(d4);
                    d5 = mxGraph2.snap(d5);
                }
                double d6 = (d4 + mxPoint2.getX()) * d3 + this.bbox.getX() - this.cellBounds.getX();
                double d7 = (d5 + mxPoint2.getY()) * d3 + this.bbox.getY() - this.cellBounds.getY();
                d = Math.round((d6 - this.bbox.getX()) / d3);
                d2 = Math.round((d7 - this.bbox.getY()) / d3);
            }
            if (this.first == null || !this.graphComponent.isSignificant(mouseEvent.getX() - this.first.x, mouseEvent.getY() - this.first.y)) {
                if (!(this.cell == null || mouseEvent.isPopupTrigger() || !this.isSelectEnabled() || this.first == null && this.isMoveEnabled())) {
                    this.graphComponent.selectCellForEvent(this.cell, mouseEvent);
                }
                if (this.graphComponent.isFoldingEnabled() && this.graphComponent.hitFoldingIcon(this.initialCell, mouseEvent.getX(), mouseEvent.getY())) {
                    this.fold(this.initialCell);
                } else {
                    Object object = this.graphComponent.getCellAt(mouseEvent.getX(), mouseEvent.getY(), this.graphComponent.isSwimlaneSelectionEnabled());
                    if (this.cell == null && this.first == null) {
                        if (object == null) {
                            mxGraph2.clearSelection();
                        } else if (mxGraph2.isSwimlane(object) && this.graphComponent.getCanvas().hitSwimlaneContent(this.graphComponent, mxGraph2.getView().getState(object), mouseEvent.getX(), mouseEvent.getY())) {
                            this.graphComponent.selectCellForEvent(object, mouseEvent);
                        }
                    }
                    if (this.graphComponent.isFoldingEnabled() && this.graphComponent.hitFoldingIcon(object, mouseEvent.getX(), mouseEvent.getY())) {
                        this.fold(object);
                        mouseEvent.consume();
                    }
                }
            } else if (this.isVisible()) {
                mxCellState mxCellState2;
                Object object;
                if (this.constrainedEvent) {
                    if (Math.abs(d) > Math.abs(d2)) {
                        d2 = 0.0;
                    } else {
                        d = 0.0;
                    }
                }
                Object object2 = object = (mxCellState2 = this.marker.getValidState()) != null ? mxCellState2.getCell() : null;
                if (mxGraph2.isSplitEnabled() && mxGraph2.isSplitTarget(object, this.cells)) {
                    mxGraph2.splitEdge(object, this.cells, d, d2);
                } else {
                    this.moveCells(this.cells, d, d2, object, mouseEvent);
                }
                mouseEvent.consume();
            }
        }
        this.reset();
    }

    protected void fold(Object object) {
        boolean bl = !this.graphComponent.getGraph().isCellCollapsed(object);
        this.graphComponent.getGraph().foldCells(bl, false, new Object[]{object});
    }

    public void reset() {
        this.setVisible(false);
        this.marker.reset();
        this.initialCell = null;
        this.dragCells = null;
        this.dragImage = null;
        this.cells = null;
        this.first = null;
        this.cell = null;
    }

    protected boolean shouldRemoveCellFromParent(Object object, Object[] objectArray, MouseEvent mouseEvent) {
        if (this.graphComponent.getGraph().getModel().isVertex(object)) {
            mxCellState mxCellState2 = this.graphComponent.getGraph().getView().getState(object);
            return mxCellState2 != null && !mxCellState2.contains(mouseEvent.getX(), mouseEvent.getY());
        }
        return false;
    }

    protected void moveCells(Object[] objectArray, double d, double d2, Object object, MouseEvent mouseEvent) {
        boolean bl;
        mxGraph mxGraph2 = this.graphComponent.getGraph();
        boolean bl2 = bl = mouseEvent.isControlDown() && this.isCloneEnabled();
        if (bl) {
            objectArray = mxGraph2.getCloneableCells(objectArray);
        }
        if (object == null && this.isRemoveCellsFromParent() && this.shouldRemoveCellFromParent(mxGraph2.getModel().getParent(this.cell), objectArray, mouseEvent)) {
            object = mxGraph2.getDefaultParent();
        }
        Object[] objectArray2 = mxGraph2.moveCells(objectArray, d, d2, bl, object, mouseEvent.getPoint());
        if (this.isSelectEnabled() && bl && objectArray2 != null && objectArray2.length == objectArray.length) {
            mxGraph2.setSelectionCells(objectArray2);
        }
    }

    public void paint(Graphics graphics) {
        if (this.dragImage != null) {
            graphics.drawImage(this.dragImage.getImage(), 0, 0, this.dragImage.getIconWidth(), this.dragImage.getIconHeight(), this);
        } else if (!this.imagePreview) {
            super.paint(graphics);
        }
    }

    protected MouseEvent createEvent(DropTargetEvent dropTargetEvent) {
        JComponent jComponent = mxGraphHandler.getDropTarget(dropTargetEvent);
        Point point = null;
        int n = 0;
        if (dropTargetEvent instanceof DropTargetDropEvent) {
            point = ((DropTargetDropEvent)dropTargetEvent).getLocation();
            n = ((DropTargetDropEvent)dropTargetEvent).getDropAction();
        } else if (dropTargetEvent instanceof DropTargetDragEvent) {
            point = ((DropTargetDragEvent)dropTargetEvent).getLocation();
            n = ((DropTargetDragEvent)dropTargetEvent).getDropAction();
        }
        if (point != null) {
            point = this.convertPoint(point);
            Rectangle rectangle = this.graphComponent.getViewport().getViewRect();
            point.translate(rectangle.x, rectangle.y);
        }
        int n2 = n == 1 ? 2 : 0;
        return new MouseEvent(jComponent, 0, System.currentTimeMillis(), n2, (int)point.getX(), (int)point.getY(), 1, false, 1);
    }

    protected static final mxGraphTransferHandler getGraphTransferHandler(DropTargetEvent dropTargetEvent) {
        JComponent jComponent = mxGraphHandler.getDropTarget(dropTargetEvent);
        TransferHandler transferHandler = jComponent.getTransferHandler();
        if (transferHandler instanceof mxGraphTransferHandler) {
            return (mxGraphTransferHandler)transferHandler;
        }
        return null;
    }

    protected static final JComponent getDropTarget(DropTargetEvent dropTargetEvent) {
        return (JComponent)dropTargetEvent.getDropTargetContext().getComponent();
    }
}

