/*
 * Decompiled with CFR 0.152.
 */
package org.renci.sequencing.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.sf.samtools.AlignmentBlock;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.util.StringUtil;

public class SortedBaseHolderUnpacker {
    private LinkedList<SortedBase> localregion = new LinkedList();
    private BufferedWriter writer;

    public SortedBaseHolderUnpacker(File output) throws IOException {
        this.writer = new BufferedWriter(new FileWriter(output));
    }

    public void flushBefore(String chromosome, int location) throws IOException {
        boolean done = false;
        while (this.localregion.size() > 0 && !done) {
            SortedBase w;
            if (!this.localregion.getFirst().getChromosome().equals(chromosome)) {
                w = this.localregion.pop();
                w.write();
                this.writer.flush();
                continue;
            }
            if (this.localregion.getFirst().getRefLocation() < location) {
                w = this.localregion.pop();
                w.write();
                this.writer.flush();
                continue;
            }
            done = true;
            this.writer.flush();
        }
    }

    public void addRead(SAMRecord rec) throws IOException {
        String chr = rec.getReferenceName();
        int refloc = rec.getAlignmentStart();
        this.shiftList(rec, chr, refloc);
        byte[] bases = rec.getReadBases();
        String basestring = StringUtil.bytesToString(bases);
        byte[] quals = rec.getBaseQualities();
        int[] iquals = new int[quals.length];
        double avgq = 0.0;
        int i = 0;
        while (i < quals.length) {
            iquals[i] = quals[i];
            avgq += 1.0 * (double)iquals[i];
            ++i;
        }
        avgq /= (double)iquals.length;
        boolean negstrand = rec.getReadNegativeStrandFlag();
        List<AlignmentBlock> abs = rec.getAlignmentBlocks();
        Iterator iter = this.localregion.iterator();
        SortedBase current = (SortedBase)iter.next();
        for (AlignmentBlock ab : abs) {
            int rstart = ab.getReferenceStart();
            while (current.getRefLocation() < rstart) {
                current = (SortedBase)iter.next();
            }
            int rs = ab.getReadStart() - 1;
            int readend = rs + ab.getLength();
            int readpos = rs;
            while (readpos < readend) {
                current.add(readpos, basestring.charAt(readpos), iquals[readpos], avgq, negstrand);
                current = (SortedBase)iter.next();
                ++readpos;
            }
        }
    }

    private void shiftList(SAMRecord rec, String chr, int refloc) throws IOException {
        this.flushBefore(chr, refloc);
        if (this.localregion.size() != 0) assert (this.localregion.getFirst().getRefLocation() == refloc);
        if (this.localregion.size() == 0) {
            this.localregion.add(this.getSortedBase(chr, refloc));
        }
        int ll = this.localregion.getLast().getRefLocation();
        while (ll <= rec.getAlignmentEnd()) {
            this.localregion.addLast(this.getSortedBase(chr, ++ll));
        }
    }

    private SortedBase getSortedBase(String chrom, int ref_location) {
        return new SortedBase(chrom, ref_location);
    }

    public void flushAll() throws IOException {
        while (!this.localregion.isEmpty()) {
            SortedBase w = this.localregion.pop();
            w.write();
        }
        this.writer.flush();
        this.writer.close();
    }

    private class SortedBase {
        String chromosome = null;
        int refloc;
        List<Integer> read_locs = new ArrayList<Integer>();
        List<Character> read_base = new ArrayList<Character>();
        List<Integer> base_qual = new ArrayList<Integer>();
        List<Double> avgqual = new ArrayList<Double>();
        List<Boolean> reverse = new ArrayList<Boolean>();
        String sFinalWriteString = null;

        public SortedBase(String chr, int rl) {
            this.chromosome = chr;
            this.refloc = rl;
        }

        public String getChromosome() {
            return this.chromosome;
        }

        public int getRefLocation() {
            return this.refloc;
        }

        public void write() throws IOException {
            int i = 0;
            while (i < this.read_locs.size()) {
                String strand = this.reverse.get(i) != false ? "-" : "+";
                this.sFinalWriteString = String.valueOf(this.chromosome) + "\t" + this.refloc + "\t" + this.read_locs.get(i) + "\t" + this.read_base.get(i) + "\t" + this.base_qual.get(i) + "\t" + this.avgqual.get(i) + "\t" + strand;
                SortedBaseHolderUnpacker.this.writer.write(String.valueOf(this.sFinalWriteString) + System.getProperty("line.separator"));
                this.sFinalWriteString = null;
                ++i;
            }
            SortedBaseHolderUnpacker.this.writer.flush();
        }

        public void add(int readpos, char charAt, int b, double avgq, boolean r) {
            this.read_locs.add(readpos);
            this.read_base.add(Character.valueOf(charAt));
            this.base_qual.add(b);
            this.avgqual.add(avgq);
            this.reverse.add(r);
        }
    }
}

