/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.metrics;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import net.sf.picard.PicardException;
import net.sf.picard.metrics.Header;
import net.sf.picard.metrics.MetricBase;
import net.sf.picard.util.FormatUtil;
import net.sf.picard.util.Histogram;
import net.sf.samtools.util.StringUtil;

public class MetricsFile<BEAN extends MetricBase, HKEY extends Comparable> {
    public static final String MAJOR_HEADER_PREFIX = "## ";
    public static final String MINOR_HEADER_PREFIX = "# ";
    public static final String SEPARATOR = "\t";
    public static final String HISTO_HEADER = "## HISTOGRAM\t";
    public static final String METRIC_HEADER = "## METRICS CLASS\t";
    private final List<Header> headers = new ArrayList<Header>();
    private final List<BEAN> metrics = new ArrayList<BEAN>();
    private final List<Histogram<HKEY>> histograms = new ArrayList<Histogram<HKEY>>();

    public void addHeader(Header h) {
        this.headers.add(h);
    }

    public List<Header> getHeaders() {
        return Collections.unmodifiableList(this.headers);
    }

    public void addMetric(BEAN bean) {
        this.metrics.add(bean);
    }

    public List<BEAN> getMetrics() {
        return Collections.unmodifiableList(this.metrics);
    }

    public Histogram<HKEY> getHistogram() {
        if (this.histograms.size() > 0) {
            return this.histograms.get(0);
        }
        return null;
    }

    public void setHistogram(Histogram<HKEY> histogram) {
        if (this.histograms.isEmpty()) {
            if (histogram != null) {
                this.histograms.add(histogram);
            }
        } else {
            this.histograms.set(0, histogram);
        }
    }

    public void addHistogram(Histogram<HKEY> histogram) {
        this.histograms.add(histogram);
    }

    public int getNumHistograms() {
        return this.histograms.size();
    }

    public List<Header> getHeaders(Class<? extends Header> type) {
        ArrayList<Header> tmp = new ArrayList<Header>();
        for (Header h : this.headers) {
            if (!h.getClass().equals(type)) continue;
            tmp.add(h);
        }
        return tmp;
    }

    public void write(File f) {
        FileWriter w = null;
        try {
            w = new FileWriter(f);
            this.write(w);
        }
        catch (IOException ioe) {
            throw new PicardException("Could not write metrics to file: " + f.getAbsolutePath(), ioe);
        }
        finally {
            if (w != null) {
                try {
                    w.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void write(Writer w) {
        try {
            FormatUtil formatter = new FormatUtil();
            BufferedWriter out = new BufferedWriter(w);
            this.printHeaders(out);
            out.newLine();
            this.printBeanMetrics(out, formatter);
            out.newLine();
            this.printHistogram(out, formatter);
            out.newLine();
            out.flush();
        }
        catch (IOException ioe) {
            throw new PicardException("Could not write metrics file.", ioe);
        }
    }

    private void printHeaders(BufferedWriter out) throws IOException {
        for (Header h : this.headers) {
            out.append(MAJOR_HEADER_PREFIX);
            out.append(h.getClass().getName());
            out.newLine();
            out.append(MINOR_HEADER_PREFIX);
            out.append(((Object)h).toString());
            out.newLine();
        }
    }

    private void printBeanMetrics(BufferedWriter out, FormatUtil formatter) throws IOException {
        if (this.metrics.isEmpty()) {
            return;
        }
        out.append(METRIC_HEADER + this.getBeanType().getName());
        out.newLine();
        Field[] fields = this.getBeanType().getFields();
        int fieldCount = fields.length;
        for (int i = 0; i < fieldCount; ++i) {
            out.append(fields[i].getName());
            if (i < fieldCount - 1) {
                out.append(SEPARATOR);
                continue;
            }
            out.newLine();
        }
        for (MetricBase bean : this.metrics) {
            for (int i = 0; i < fieldCount; ++i) {
                try {
                    Object value = fields[i].get(bean);
                    out.append(StringUtil.assertCharactersNotInString(formatter.format(value), '\t', '\n'));
                    if (i < fieldCount - 1) {
                        out.append(SEPARATOR);
                        continue;
                    }
                    out.newLine();
                    continue;
                }
                catch (IllegalAccessException iae) {
                    throw new PicardException("Could not read property " + fields[i].getName() + " from class of type " + bean.getClass());
                }
            }
        }
        out.flush();
    }

    private void printHistogram(BufferedWriter out, FormatUtil formatter) throws IOException {
        if (this.histograms.isEmpty()) {
            return;
        }
        TreeSet keys = new TreeSet(this.histograms.get(0).comparator());
        for (Histogram<HKEY> histo : this.histograms) {
            if (histo == null) continue;
            keys.addAll(histo.keySet());
        }
        out.append(HISTO_HEADER + ((Comparable)this.histograms.get(0).keySet().iterator().next()).getClass().getName());
        out.newLine();
        out.append(StringUtil.assertCharactersNotInString(this.histograms.get(0).getBinLabel(), '\t', '\n'));
        for (Histogram<HKEY> histo : this.histograms) {
            out.append(SEPARATOR);
            out.append(StringUtil.assertCharactersNotInString(histo.getValueLabel(), '\t', '\n'));
        }
        out.newLine();
        for (Comparable key : keys) {
            out.append(key.toString());
            for (Histogram<HKEY> histo : this.histograms) {
                Histogram.Bin bin = (Histogram.Bin)histo.get(key);
                double value = bin == null ? 0.0 : bin.getValue();
                out.append(SEPARATOR);
                out.append(formatter.format(value));
            }
            out.newLine();
        }
    }

    private Class<?> getBeanType() {
        if (this.metrics == null || this.metrics.isEmpty()) {
            return null;
        }
        return ((MetricBase)this.metrics.get(0)).getClass();
    }

    public void read(Reader r) {
        block31: {
            BufferedReader in = new BufferedReader(r);
            FormatUtil formatter = new FormatUtil();
            String line = null;
            try {
                String className;
                Header header = null;
                boolean inHeader = true;
                while ((line = in.readLine()) != null && inHeader) {
                    if ("".equals(line = line.trim())) {
                        inHeader = false;
                        continue;
                    }
                    if (line.startsWith(MAJOR_HEADER_PREFIX)) {
                        if (header != null) {
                            throw new IllegalStateException("Consecutive header class lines encountered.");
                        }
                        className = line.substring(MAJOR_HEADER_PREFIX.length()).trim();
                        try {
                            header = (Header)this.loadClass(className, true).newInstance();
                            continue;
                        }
                        catch (Exception e) {
                            throw new PicardException("Error load and/or instantiating an instance of " + className, e);
                        }
                    }
                    if (line.startsWith(MINOR_HEADER_PREFIX)) {
                        if (header == null) {
                            throw new IllegalStateException("Header class must precede header value:" + line);
                        }
                        header.parse(line.substring(MINOR_HEADER_PREFIX.length()));
                        this.headers.add(header);
                        header = null;
                        continue;
                    }
                    throw new PicardException("Illegal state. Found following string in metrics file header: " + line);
                }
                if (line == null) {
                    throw new PicardException("No lines in metrics file after header.");
                }
                while (!line.startsWith(MAJOR_HEADER_PREFIX)) {
                    line = in.readLine().trim();
                }
                if (line.startsWith(METRIC_HEADER)) {
                    className = line.split(SEPARATOR)[1];
                    Class<?> type = null;
                    try {
                        type = this.loadClass(className, true);
                    }
                    catch (ClassNotFoundException cnfe) {
                        throw new PicardException("Could not locate class with name " + className, cnfe);
                    }
                    String[] fieldNames = in.readLine().split(SEPARATOR);
                    Field[] fields = new Field[fieldNames.length];
                    for (int i = 0; i < fieldNames.length; ++i) {
                        try {
                            fields[i] = type.getField(fieldNames[i]);
                            continue;
                        }
                        catch (Exception e) {
                            throw new PicardException("Could not get field with name " + fieldNames[i] + " from class " + type.getName());
                        }
                    }
                    while ((line = in.readLine()) != null && !"".equals(line.trim())) {
                        String[] values = line.split(SEPARATOR, -1);
                        MetricBase bean = null;
                        try {
                            bean = (MetricBase)type.newInstance();
                        }
                        catch (Exception e) {
                            throw new PicardException("Error instantiating a " + type.getName(), e);
                        }
                        for (int i = 0; i < fields.length; ++i) {
                            Object value = null;
                            if (values[i] != null && values[i].length() > 0) {
                                value = formatter.parseObject(values[i], fields[i].getType());
                            }
                            try {
                                fields[i].set(bean, value);
                                continue;
                            }
                            catch (Exception e) {
                                throw new PicardException("Error setting field " + fields[i].getName() + " on class of type " + type.getName(), e);
                            }
                        }
                        this.metrics.add(bean);
                    }
                }
                while (line != null && !line.startsWith(MAJOR_HEADER_PREFIX)) {
                    line = in.readLine();
                }
                if (line == null || !line.startsWith(HISTO_HEADER)) break block31;
                String keyClassName = line.split(SEPARATOR)[1].trim();
                Class<?> keyClass = null;
                try {
                    keyClass = this.loadClass(keyClassName, true);
                }
                catch (ClassNotFoundException cnfe) {
                    throw new PicardException("Could not load class with name " + keyClassName);
                }
                String[] labels = in.readLine().split(SEPARATOR);
                for (int i = 1; i < labels.length; ++i) {
                    this.histograms.add(new Histogram(labels[0], labels[i]));
                }
                while ((line = in.readLine()) != null && !"".equals(line)) {
                    String[] fields = line.trim().split(SEPARATOR);
                    Comparable key = (Comparable)formatter.parseObject(fields[0], keyClass);
                    for (int i = 1; i < fields.length; ++i) {
                        double value = formatter.parseDouble(fields[i]);
                        this.histograms.get(i - 1).increment(key, value);
                    }
                }
            }
            catch (IOException ioe) {
                throw new PicardException("Could not read metrics from reader.", ioe);
            }
        }
    }

    private Class<?> loadClass(String className, boolean tryOtherPackages) throws ClassNotFoundException {
        String[] packages = new String[]{"edu.mit.broad.picard.genotype.concordance", "edu.mit.broad.picard.genotype.fingerprint", "edu.mit.broad.picard.ic", "edu.mit.broad.picard.illumina", "edu.mit.broad.picard.jumping", "edu.mit.broad.picard.quality", "edu.mit.broad.picard.samplevalidation", "net.sf.picard.analysis", "net.sf.picard.analysis.directed", "net.sf.picard.sam", "net.sf.picard.metrics"};
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException cnfe) {
            if (tryOtherPackages) {
                for (String p : packages) {
                    try {
                        return this.loadClass(p + className.substring(className.lastIndexOf(".")), false);
                    }
                    catch (ClassNotFoundException cnf2) {
                    }
                }
            }
            throw cnfe;
        }
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        MetricsFile that = (MetricsFile)o;
        if (!((Object)this.headers).equals(that.headers)) {
            return false;
        }
        if (!((Object)this.metrics).equals(that.metrics)) {
            return false;
        }
        return ((Object)this.histograms).equals(that.histograms);
    }

    public int hashCode() {
        int result = ((Object)this.headers).hashCode();
        result = 31 * result + ((Object)this.metrics).hashCode();
        return result;
    }
}

