### R code from vignette source 'PatientGeneSets.Rnw'

###################################################
### code chunk number 1: loadPackageData
###################################################
library(PatientGeneSets)
data(Parsons)
ls()

library(KEGG.db)
KEGGPATHID2EXTID


###################################################
### code chunk number 2: loadID2name
###################################################
data(ID2name)
head(ID2name)


###################################################
### code chunk number 3: calcBrainResults
###################################################
as.character(KEGGPATHNAME2ID[c("Endometrial cancer", 
                               "Non-small cell lung cancer",
                               "Alanine, aspartate and glutamate metabolism")])

resultsBrain <-
    do.gene.set.analysis(EventsBySample = EventsBySampleBrain,
                         GeneSizes = GeneSizes08,
                         GeneSets = KEGGPATHID2EXTID[c("hsa05213", 
                         "hsa05223",  "hsa00250")],
                         Coverage = CoverageBrain,
                         ID2name = ID2name,
                         gene.method = FALSE,
                         perm.null.method = TRUE,
                         perm.null.het.method = FALSE,
                         pass.null.method = TRUE,
                         pass.null.het.method = FALSE)


###################################################
### code chunk number 4: showBrainResults
###################################################
resultsBrain


###################################################
### code chunk number 5: calcGeneScores
###################################################
GeneScores <- cma.scores(cma.data = MutationsBrain,
                         number.genes = nrow(GeneSizes08))

head(GeneScores)


###################################################
### code chunk number 6: simData
###################################################
set.seed(831984)

resultsSim <- 
    sim.data.p.values(EventsBySample = EventsBySampleBrain,
                      Mutations = MutationsBrain,
                      GeneSizes = GeneSizes08,
                      Coverage = CoverageBrain,
		      GeneSets = KEGGPATHID2EXTID[c("hsa05213", 
                      "hsa05223", "hsa00250")],
		      ID2name = ID2name,
                      nr.iter = 2,
                      pass.null = TRUE,
                      perc.samples = c(75, 95),
                      spiked.set.sizes = c(50),
                      show.iter = TRUE,
                      gene.method = FALSE,
                      perm.null.method = TRUE,
                      perm.null.het.method = FALSE,
                      pass.null.method = TRUE,
                      pass.null.het.method = FALSE)

resultsSim

slotNames(resultsSim)

resultsSim@null.dist


###################################################
### code chunk number 7: extractSimMethod
###################################################
extract.sims.method(resultsSim,
                    "p.values.perm.null")



###################################################
### code chunk number 8: combineSims
###################################################
combine.sims(resultsSim, resultsSim)


