### R code from vignette source 'GeneExpressionSignature.Rnw'

###################################################
### code chunk number 1: GeneExpressionSignature
###################################################
library(GeneExpressionSignature)
PRLs <- as.matrix(read.table(system.file("extdata/example_PRLs.txt",
package="GeneExpressionSignature")))
states <- read.table(system.file("extdata/example_states.txt",
package="GeneExpressionSignature"))
PRLs[c(1:10),c(1:3)]
states


###################################################
### code chunk number 2: krubor
###################################################
PRL <- krubor(PRLs[,c(1:4,8)])
PRL[c(1:10)]


###################################################
### code chunk number 3: aggregate
###################################################
library(Biobase)
rownames(states)=colnames(PRLs)
phenodata=new("AnnotatedDataFrame", data = states)
exampleSet=new("ExpressionSet", exprs=PRLs, phenoData=phenodata)
summary(exampleSet)
aggregatedSet=aggregate(exampleSet)
summary(aggregatedSet)


###################################################
### code chunk number 4: distances
###################################################
d  <- distances(aggregatedSet,250)
ES <- d[[1]]
exprs(ES)
distance <- d[[2]]
exprs(distance)


###################################################
### code chunk number 5: FootruleMatrix
###################################################
SMDM <- FootruleMatrix(PRLs,1)
SMDM


###################################################
### code chunk number 6: BMRankMerging
###################################################
outranking=BMRankMerging(PRLs[,c(1,2)])


###################################################
### code chunk number 7: krubor
###################################################
PRL <- krubor(PRLs[,c(1:3)])


###################################################
### code chunk number 8: aggregate
###################################################
aggregate(exampleSet)


###################################################
### code chunk number 9: distances
###################################################
PRL <- aggregate(exampleSet)
d  <- distances(PRL,250)
ES <- d[[1]]
exprs(ES)
distance <- d[[2]]
exprs(distance)


###################################################
### code chunk number 10: integratePRL
###################################################
newPRL <- PRL[,2]
d <- integratePRL(ES,PRL,newPRL,250)
newES <- d[[2]]
newdistance <- d[[3]]
exprs(newES)
exprs(newdistance)


###################################################
### code chunk number 11: GeneExpressionSignature.Rnw:145-146
###################################################
sessionInfo()


