/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.swing.treetable;

import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.TreePath;
import org.freehep.swing.treetable.TreeTableModel;

public class TreeTableModelAdapter
extends AbstractTableModel {
    JTree tree;
    TreeTableModel treeTableModel;

    public TreeTableModelAdapter(TreeTableModel treeTableModel, JTree tree) {
        this.tree = tree;
        this.treeTableModel = treeTableModel;
        tree.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeExpanded(TreeExpansionEvent event) {
                TreeTableModelAdapter.this.fireTableDataChanged();
            }

            public void treeCollapsed(TreeExpansionEvent event) {
                TreeTableModelAdapter.this.fireTableDataChanged();
            }
        });
        treeTableModel.addTreeModelListener(new TreeModelListener(){

            public void treeNodesChanged(TreeModelEvent e) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }

            public void treeNodesInserted(TreeModelEvent e) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }

            public void treeNodesRemoved(TreeModelEvent e) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }

            public void treeStructureChanged(TreeModelEvent e) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }
        });
    }

    public boolean isCellEditable(int row, int column) {
        return this.treeTableModel.isCellEditable(this.pathForRow(row), column);
    }

    public Class getColumnClass(int column) {
        return this.treeTableModel.getColumnClass(column);
    }

    public int getColumnCount() {
        return this.treeTableModel.getColumnCount();
    }

    public String getColumnName(int column) {
        return this.treeTableModel.getColumnName(column);
    }

    public int getRowCount() {
        return this.tree.getRowCount();
    }

    public void setValueAt(Object value, int row, int column) {
        this.treeTableModel.setValueAt(value, this.pathForRow(row), column);
    }

    public Object getValueAt(int row, int column) {
        return this.treeTableModel.getValueAt(this.pathForRow(row), column);
    }

    protected int getRowForLocation(int x, int y) {
        return this.tree.getRowForLocation(x, y);
    }

    protected void delayedFireTableDataChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TreeTableModelAdapter.this.fireTableDataChanged();
            }
        });
    }

    protected Object nodeForRow(int row) {
        TreePath treePath = this.tree.getPathForRow(row);
        if (treePath == null) {
            System.err.println("WARNING: nodeForRow returning null for " + row);
            return null;
        }
        return treePath.getLastPathComponent();
    }

    protected TreePath pathForRow(int row) {
        TreePath treePath = this.tree.getPathForRow(row);
        if (treePath == null) {
            System.err.println("WARNING: pathForRow returning null for " + row);
            return null;
        }
        return treePath;
    }
}

