/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.parse_tree;

import java.util.Stack;
import org.cytoscape.equations.CodeAndSourceLocation;
import org.cytoscape.equations.interpreter.Instruction;
import org.cytoscape.equations.parse_tree.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FConvNode
extends Node {
    private final Node convertee;

    public FConvNode(Node convertee) {
        super(-1);
        if (convertee == null) {
            throw new IllegalArgumentException("convertee must not be null!");
        }
        Class type = convertee.getType();
        if (type != Long.class && type != Boolean.class && type != String.class) {
            throw new IllegalArgumentException("convertee must be of type Long, Boolean or String!");
        }
        this.convertee = convertee;
    }

    @Override
    public String toString() {
        return "FConvNode: convertee = " + this.convertee;
    }

    @Override
    public Class getType() {
        return Double.class;
    }

    @Override
    public Node getLeftChild() {
        return this.convertee;
    }

    @Override
    public Node getRightChild() {
        return null;
    }

    @Override
    public void genCode(Stack<CodeAndSourceLocation> codeStack) {
        this.convertee.genCode(codeStack);
        Class type = this.convertee.getType();
        if (type == Long.class) {
            codeStack.push(new CodeAndSourceLocation((Object)Instruction.FCONVI, this.getSourceLocation()));
        } else if (type == Boolean.class) {
            codeStack.push(new CodeAndSourceLocation((Object)Instruction.FCONVB, this.getSourceLocation()));
        } else if (type == String.class) {
            codeStack.push(new CodeAndSourceLocation((Object)Instruction.FCONVS, this.getSourceLocation()));
        } else {
            throw new IllegalStateException("unknown type: " + type + "!");
        }
    }
}

