/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.builtins;

import org.cytoscape.equations.AbstractFunction;
import org.cytoscape.equations.ArgDescriptor;
import org.cytoscape.equations.ArgType;
import org.cytoscape.equations.FunctionUtil;

public class Sum
extends AbstractFunction {
    public Sum() {
        super(new ArgDescriptor[]{new ArgDescriptor(ArgType.OPT_FLOATS, "numbers", "One or more numbers or lists of numbers.")});
    }

    public String getName() {
        return "SUM";
    }

    public String getFunctionSummary() {
        return "Returns the sum of all of its arguments.";
    }

    public Class getReturnType() {
        return Double.class;
    }

    public Object evaluateFunction(Object[] args) {
        double[] numbers;
        try {
            numbers = FunctionUtil.getDoubles(args);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("in a call to SUM(): could not convert one of the arguments to a number or list of numbers!");
        }
        double sum = 0.0;
        for (double d : numbers) {
            sum += d;
        }
        return sum;
    }
}

