/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.builtins;

import org.cytoscape.equations.AbstractFunction;
import org.cytoscape.equations.ArgDescriptor;
import org.cytoscape.equations.ArgType;
import org.cytoscape.equations.FunctionUtil;

public class Round
extends AbstractFunction {
    public Round() {
        super(new ArgDescriptor[]{new ArgDescriptor(ArgType.FLOAT, "number", "Any number."), new ArgDescriptor(ArgType.FLOAT, "digit_count", "Round to this number of significant digits.")});
    }

    public String getName() {
        return "ROUND";
    }

    public String getFunctionSummary() {
        return "Rounds a number to a specified number of decimal places.";
    }

    public Class getReturnType() {
        return Double.class;
    }

    public Object evaluateFunction(Object[] args) throws IllegalArgumentException, ArithmeticException {
        double numDigits;
        double number;
        try {
            number = FunctionUtil.getArgAsDouble(args[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("can't convert \"" + args[0] + "\" to a number in a call to ROUND()!");
        }
        double absNumber = Math.abs(number);
        try {
            numDigits = FunctionUtil.getArgAsLong(args[1]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("can't convert \"" + args[1] + "\" to an integer in a call to ROUND()!");
        }
        double shift = Math.pow(10.0, numDigits);
        double roundedAbsNumber = (double)Math.round(absNumber * shift) / shift;
        return number > 0.0 ? roundedAbsNumber : -roundedAbsNumber;
    }
}

