/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.builtins;

import org.cytoscape.equations.AbstractFunction;
import org.cytoscape.equations.ArgDescriptor;
import org.cytoscape.equations.ArgType;
import org.cytoscape.equations.FunctionUtil;

public class Right
extends AbstractFunction {
    public Right() {
        super(new ArgDescriptor[]{new ArgDescriptor(ArgType.STRING, "text", "The source text."), new ArgDescriptor(ArgType.OPT_FLOAT, "number", "How many characters to extract. (Default is 1.)")});
    }

    public String getName() {
        return "RIGHT";
    }

    public String getFunctionSummary() {
        return "Returns a suffix of a string.";
    }

    public Class getReturnType() {
        return String.class;
    }

    public Object evaluateFunction(Object[] args) throws IllegalArgumentException, ArithmeticException {
        int count;
        String text = FunctionUtil.getArgAsString(args[0]);
        if (args.length == 1) {
            count = 1;
        } else {
            try {
                count = (int)FunctionUtil.getArgAsLong(args[1]);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("can't convert \"" + args[1] + "\" to an integer in a call to RIGHT()!");
            }
            if (count < 0) {
                throw new IllegalArgumentException("illegal character count in a call to RIGHT()!");
            }
        }
        if (count >= text.length()) {
            return text;
        }
        return text.substring(text.length() - count);
    }
}

