/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.builtins;

import java.text.DateFormat;
import java.util.Calendar;
import org.cytoscape.equations.AbstractFunction;
import org.cytoscape.equations.ArgDescriptor;

public class Now
extends AbstractFunction {
    public Now() {
        super(new ArgDescriptor[0]);
    }

    public String getName() {
        return "NOW";
    }

    public String getFunctionSummary() {
        return "Returns the current date and time.";
    }

    public Class getReturnType() {
        return Double.class;
    }

    public Object evaluateFunction(Object[] args) {
        Calendar calendar = Calendar.getInstance();
        DateFormat dateFormat = DateFormat.getDateInstance(3);
        DateFormat timeFormat = DateFormat.getTimeInstance(3);
        try {
            String date = dateFormat.format(calendar.getTime());
            String time = timeFormat.format(calendar.getTime());
            return date + " " + time;
        }
        catch (Exception e) {
            throw new IllegalStateException("failed to get today's date: " + e.getMessage());
        }
    }
}

