/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.builtins;

import org.cytoscape.equations.AbstractFunction;
import org.cytoscape.equations.ArgDescriptor;
import org.cytoscape.equations.ArgType;
import org.cytoscape.equations.FunctionError;
import org.cytoscape.equations.FunctionUtil;

public class Average
extends AbstractFunction {
    public Average() {
        super(new ArgDescriptor[]{new ArgDescriptor(ArgType.FLOATS, "numbers", "One or more numbers and/or lists of numbers.")});
    }

    public String getName() {
        return "AVERAGE";
    }

    public String getFunctionSummary() {
        return "Returns the average of a group of numbers.";
    }

    public Class getReturnType() {
        return Double.class;
    }

    public Object evaluateFunction(Object[] args) throws IllegalArgumentException, ArithmeticException {
        double[] numbers;
        try {
            numbers = FunctionUtil.getDoubles(args);
        }
        catch (FunctionError e) {
            throw new IllegalArgumentException("bad argument(s) in a call to AVERAGE(): " + e.getMessage());
        }
        if (numbers.length == 0) {
            throw new IllegalArgumentException("need at least one number in a call to AVERAGE()!");
        }
        return FunctionUtil.numericallySafeSum(numbers) / (double)numbers.length;
    }
}

