/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations;

import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.cytoscape.equations.ArgDescriptor;
import org.cytoscape.equations.Function;
import org.cytoscape.equations.FunctionError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFunction
implements Function {
    private final ArgDescriptor[] argDescriptors;

    protected AbstractFunction(ArgDescriptor[] argDescriptors) {
        this.argDescriptors = argDescriptors;
        boolean lastArgWasOptional = false;
        for (int i = 0; i < argDescriptors.length; ++i) {
            boolean currentArgIsOptional = argDescriptors[i].isOptional();
            if (lastArgWasOptional && !currentArgIsOptional) {
                throw new IllegalArgumentException("invalid argument specification for " + this.getName() + "() optional argument " + argDescriptors[i - 1].getArgName() + " is followed by non-optional argument " + argDescriptors[i].getArgName() + "!");
            }
            lastArgWasOptional = currentArgIsOptional;
        }
        TreeSet<String> alreadySeen = new TreeSet<String>();
        for (ArgDescriptor argDescriptor : argDescriptors) {
            String argName = argDescriptor.getArgName();
            if (alreadySeen.contains(argName)) {
                throw new IllegalArgumentException("duplicate argument name " + argName + " for " + this.getName() + "() specified multiple times!");
            }
            alreadySeen.add(argName);
        }
    }

    @Override
    public abstract String getName();

    @Override
    public abstract String getFunctionSummary();

    @Override
    public final String getUsageDescription() {
        StringBuilder usage = new StringBuilder("Call with ");
        usage.append(this.getName());
        usage.append('(');
        int optArgCount = 0;
        boolean isFirst = true;
        for (ArgDescriptor argDescriptor : this.argDescriptors) {
            if (argDescriptor.isOptional()) {
                usage.append(isFirst ? "[" : " [,");
                ++optArgCount;
            } else {
                usage.append(isFirst ? "" : " ,");
            }
            usage.append(argDescriptor.getArgName());
            isFirst = false;
        }
        for (int i = 0; i < optArgCount; ++i) {
            usage.append(']');
        }
        usage.append(").");
        return usage.toString();
    }

    @Override
    public abstract Class getReturnType();

    protected final boolean argTypesAreValid(Class[] argTypes) {
        int i = 0;
        int currentArgCount = 0;
        ArgDescriptor currentArgDescriptor = null;
        for (Class argType : argTypes) {
            if (currentArgCount == 0) {
                if (i == this.argDescriptors.length) {
                    return false;
                }
                currentArgDescriptor = this.argDescriptors[i++];
            }
            if (!currentArgDescriptor.isCompatibleWith(argType)) {
                return false;
            }
            if (currentArgDescriptor.acceptsMultipleArgs()) {
                ++currentArgCount;
                continue;
            }
            currentArgCount = 0;
        }
        return i == this.argDescriptors.length || this.argDescriptors[i].isOptional();
    }

    @Override
    public final Class validateArgTypes(Class[] argTypes) {
        return this.argTypesAreValid(argTypes) ? this.getReturnType() : null;
    }

    @Override
    public abstract Object evaluateFunction(Object[] var1) throws FunctionError;

    @Override
    public final List<Class> getPossibleArgTypes(Class[] leadingArgs) {
        int i = 0;
        int currentArgCount = 0;
        ArgDescriptor currentArgDescriptor = null;
        for (Class leadingArg : leadingArgs) {
            if (currentArgCount == 0) {
                if (i == this.argDescriptors.length) {
                    throw new IllegalStateException("number of arguments is too large!");
                }
                currentArgDescriptor = this.argDescriptors[i++];
            }
            if (!currentArgDescriptor.isCompatibleWith(leadingArg)) {
                throw new IllegalStateException("incompatible argument type!");
            }
            if (currentArgDescriptor.acceptsMultipleArgs()) {
                ++currentArgCount;
                continue;
            }
            currentArgCount = 0;
        }
        if (currentArgCount == 0 && i == this.argDescriptors.length) {
            return null;
        }
        LinkedList<Class> possibleNextArgs = new LinkedList<Class>();
        if (currentArgCount > 0) {
            for (Class type : currentArgDescriptor.getCompatibleTypes()) {
                possibleNextArgs.add(type);
            }
            if (i == this.argDescriptors.length) {
                possibleNextArgs.add(null);
            }
        }
        if (i < this.argDescriptors.length) {
            ArgDescriptor nextArgDesc = this.argDescriptors[i];
            for (Class type : nextArgDesc.getCompatibleTypes()) {
                possibleNextArgs.add(type);
            }
            if (nextArgDesc.isOptional()) {
                possibleNextArgs.add(null);
            }
        }
        return possibleNextArgs;
    }
}

