/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.stats.svm.tools;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import org.biojava.stats.svm.SVMClassifierModel;
import org.biojava.stats.svm.tools.SVM_Light;

public class Classify {
    public static void main(String[] args) throws Throwable {
        String line;
        if (args.length < 3) {
            throw new Exception("usage: stats.svm.tools.Classify <model> <test_examples> <results_log>");
        }
        String modelName = args[0];
        String examplesName = args[1];
        String resultsName = args[2];
        SVMClassifierModel model = SVM_Light.readModelFile(modelName);
        BufferedReader r = new BufferedReader(new FileReader(examplesName));
        PrintWriter w = new PrintWriter(new FileWriter(resultsName));
        int right = 0;
        int wrong = 0;
        while ((line = r.readLine()) != null) {
            if (line.length() == 0 || line.startsWith("#")) continue;
            SVM_Light.LabelledVector ex = SVM_Light.parseExample(line);
            double result = model.classify(ex.getVector());
            w.println(result);
            if (Classify.sign(result) == Classify.sign(ex.getLabel())) {
                ++right;
                continue;
            }
            ++wrong;
        }
        System.out.println("" + (double)right / (double)(right + wrong) * 100.0 + "% correct");
        r.close();
        w.close();
    }

    public static int sign(double d) {
        if (d < 0.0) {
            return -1;
        }
        if (d == 0.0) {
            return 0;
        }
        return 1;
    }
}

