/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.sax;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.biojava.bio.program.sax.NamespaceConfigurationIF;
import org.biojava.bio.program.sax.QName;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

abstract class AbstractNativeAppSAXParser
implements XMLReader,
NamespaceConfigurationIF {
    private HashMap oPrefixMap = new HashMap();
    protected ContentHandler oHandler = null;
    protected boolean tNamespaces = true;
    protected boolean tNamespacePrefixes = false;
    protected String oNamespacePrefix = "";
    protected String oFullNamespacePrefix = "";
    protected int iState;

    AbstractNativeAppSAXParser() {
    }

    public void setContentHandler(ContentHandler poHandler) {
        if (poHandler == null) {
            throw new NullPointerException("ContentHandler is null");
        }
        this.oHandler = poHandler;
    }

    public ContentHandler getContentHandler() {
        return this.oHandler;
    }

    public void parse(InputSource input) throws IOException, SAXException {
    }

    public void parse(String poSystemId) throws IOException, SAXException {
        this.parse(new InputSource(poSystemId));
    }

    public boolean getFeature(String poName) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotSupportedException("The feature \"" + poName + "\" is not supported " + "in the biojava native SAX2 parsing framework.");
    }

    public void setFeature(String poName, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (poName.equals("http://xml.org/sax/features/namespaces")) {
            this.setNamespaces(value);
            if (!this.getNamespaces() && !this.getNamespacePrefixes()) {
                throw new SAXNotSupportedException("Illegal feature combination");
            }
            return;
        }
        if (poName.equals("http://xml.org/sax/features/namespace-prefixes")) {
            this.setNamespacePrefixes(value);
            if (!this.getNamespaces() && !this.getNamespacePrefixes()) {
                throw new SAXNotSupportedException("Illegal feature combination");
            }
            return;
        }
        throw new SAXNotSupportedException("The feature \"" + poName + "\" is not supported " + "in the biojava native SAX2 parsing framework.");
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotSupportedException("This method is not supportedin the biojava native SAX2 parser.");
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotSupportedException("This method is not supportedin the biojava native SAX2 parser.");
    }

    public void setEntityResolver(EntityResolver resolver) {
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public void setDTDHandler(DTDHandler handler) {
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public void setErrorHandler(ErrorHandler handler) {
    }

    public ErrorHandler getErrorHandler() {
        return null;
    }

    protected void startElement(QName poQName, Attributes atts) throws SAXException {
        this.oHandler.startElement(poQName.getURI(), poQName.getLocalName(), poQName.getQName(), atts);
    }

    protected void endElement(QName poQName) throws SAXException {
        this.oHandler.endElement(poQName.getURI(), poQName.getLocalName(), poQName.getQName());
    }

    protected void characters(char[] ch, int start, int length) throws SAXException {
        this.oHandler.characters(ch, start, length);
    }

    private void setNamespaces(boolean ptNamespaces) {
        this.tNamespaces = ptNamespaces;
    }

    public boolean getNamespaces() {
        return this.tNamespaces;
    }

    private void setNamespacePrefixes(boolean ptNamespacePrefixes) {
        this.tNamespacePrefixes = ptNamespacePrefixes;
    }

    public boolean getNamespacePrefixes() {
        return this.tNamespacePrefixes;
    }

    public void addPrefixMapping(String poPrefix, String poURI) {
        this.oPrefixMap.put(poPrefix, poURI);
    }

    public String getURIFromPrefix(String poPrefix) {
        if (this.oPrefixMap.containsKey(poPrefix)) {
            return (String)this.oPrefixMap.get(poPrefix);
        }
        return "";
    }

    public void setNamespacePrefix(String poPrefix) {
        this.oNamespacePrefix = poPrefix;
        this.oFullNamespacePrefix = this.oNamespacePrefix.concat(":");
    }

    public String getNamespacePrefix() {
        return this.oNamespacePrefix;
    }

    public String prefix(String poElementName) {
        return this.oFullNamespacePrefix.concat(poElementName);
    }

    protected BufferedReader getContentStream(InputSource poSource) {
        int iBuffSize = 8192;
        InputSource oSource = poSource;
        if (oSource.getCharacterStream() != null) {
            BufferedReader oContents = new BufferedReader(oSource.getCharacterStream(), iBuffSize);
            return oContents;
        }
        if (oSource.getByteStream() != null) {
            BufferedReader oContents = new BufferedReader(new InputStreamReader(oSource.getByteStream()), iBuffSize);
            return oContents;
        }
        if (oSource.getSystemId() != null) {
            try {
                URL IORUrl = new URL(oSource.getSystemId());
                BufferedInputStream inStr = new BufferedInputStream(IORUrl.openStream());
                BufferedReader oContents = new BufferedReader(new InputStreamReader(inStr), iBuffSize);
                return oContents;
            }
            catch (MalformedURLException x) {
                System.out.println(x.getMessage());
                System.out.println("Couldn't open file");
                System.exit(0);
            }
            catch (IOException x) {
                System.out.println(x.getMessage());
                System.out.println("Couldn't open file");
                System.exit(0);
            }
        }
        return null;
    }

    protected void changeState(int piState) {
        this.iState = piState;
    }
}

