/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.das.dasstructure;

import java.util.ArrayList;
import java.util.HashMap;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.structure.AminoAcidImpl;
import org.biojava.bio.structure.AtomImpl;
import org.biojava.bio.structure.Chain;
import org.biojava.bio.structure.ChainImpl;
import org.biojava.bio.structure.Group;
import org.biojava.bio.structure.HetatomImpl;
import org.biojava.bio.structure.NucleotideImpl;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.StructureImpl;
import org.biojava.bio.structure.io.PDBParseException;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class DASStructureXMLResponseParser
extends DefaultHandler {
    StructureImpl structure = new StructureImpl();
    ArrayList current_model = new ArrayList();
    ChainImpl current_chain = null;
    Group current_group = null;
    SymbolTokenization threeLetter;
    SymbolTokenization oneLetter;

    public DASStructureXMLResponseParser() {
        FiniteAlphabet alpha_prot = ProteinTools.getAlphabet();
        try {
            this.threeLetter = alpha_prot.getTokenization("name");
            this.oneLetter = alpha_prot.getTokenization("token");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Structure get_structure() {
        return this.structure;
    }

    private void OBJECThandler(Attributes atts) {
        String id = atts.getValue("dbAccessionId");
        String objectVersion = atts.getValue("objectVersion");
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("idCode", id);
        header.put("modDate", objectVersion);
        this.structure.setHeader(header);
        this.structure.setPDBCode(id);
    }

    private void CHAINhandler(Attributes atts) {
        String model_nr = atts.getValue("model");
        if (model_nr != null) {
            int modnr = Integer.parseInt(model_nr);
            this.structure.setNmr(true);
            if (modnr - 1 > this.structure.nrModels()) {
                this.structure.addModel(this.current_model);
                this.current_model = new ArrayList();
            }
        }
        String chain_id = atts.getValue("id");
        String spCode = atts.getValue("SwissprotId");
        if (this.current_chain == null) {
            this.current_chain = new ChainImpl();
            this.current_chain.setName(chain_id);
            this.current_chain.setSwissprotId(spCode);
            return;
        }
        Chain testchain = this.isKnownChain(chain_id);
        if (testchain != null) {
            this.current_chain = (ChainImpl)testchain;
        } else {
            this.current_chain = new ChainImpl();
            this.current_chain.setName(chain_id);
            this.current_chain.setSwissprotId(spCode);
        }
    }

    private void ATOMhandler(Attributes atts) {
        String atomID = atts.getValue("atomID");
        String atomName = atts.getValue("atomName");
        String X = atts.getValue("x");
        String Y = atts.getValue("y");
        String Z = atts.getValue("z");
        AtomImpl atom = new AtomImpl();
        int pdbnumber = Integer.parseInt(atomID);
        atom.setPDBserial(pdbnumber);
        atom.setFullName(atomName);
        atom.setName(atomName.trim());
        double x = Double.parseDouble(X);
        double y = Double.parseDouble(Y);
        double z = Double.parseDouble(Z);
        double[] coords = new double[]{x, y, z};
        atom.setCoords(coords);
        this.current_group.addAtom(atom);
    }

    private Group getNewGroup(String type, String name) {
        HetatomImpl group;
        if (type.equals("amino")) {
            AminoAcidImpl aa = new AminoAcidImpl();
            Character aminoCode1 = null;
            try {
                aminoCode1 = this.convert_3code_1code(name);
            }
            catch (IllegalSymbolException e) {
                aminoCode1 = new Character('x');
            }
            aa.setAminoType(aminoCode1);
            group = aa;
        } else if (type.equals("nucleotide")) {
            NucleotideImpl nu = new NucleotideImpl();
            group = nu;
        } else {
            group = new HetatomImpl();
        }
        try {
            group.setPDBName(name);
        }
        catch (PDBParseException e) {
            // empty catch block
        }
        return group;
    }

    private void GROUPhandler(Attributes atts) {
        String name = atts.getValue("name");
        String type = atts.getValue("type");
        String groupid = atts.getValue("groupID");
        this.current_group = this.getNewGroup(type, name);
        this.current_group.setPDBCode(groupid);
    }

    public void startElement(String uri, String name, String qName, Attributes atts) {
        if (qName.equals("object")) {
            this.OBJECThandler(atts);
        } else if (qName.equals("chain")) {
            this.CHAINhandler(atts);
        } else if (qName.equals("atom")) {
            this.ATOMhandler(atts);
        } else if (qName.equals("group")) {
            this.GROUPhandler(atts);
        }
    }

    public void startDocument() {
    }

    public void endDocument() {
        this.structure.addModel(this.current_model);
    }

    public void endElement(String uri, String name, String qName) {
        Chain ch;
        if (qName.equals("group")) {
            this.current_chain.addGroup(this.current_group);
        }
        if (qName.equals("chain") && (ch = this.isKnownChain(this.current_chain.getName())) == null) {
            this.current_model.add(this.current_chain);
        }
    }

    public void characters(char[] ch, int start, int length) {
    }

    private Chain isKnownChain(String chainID) {
        Chain testchain = null;
        Chain retchain = null;
        for (int i = 0; i < this.current_model.size(); ++i) {
            testchain = (Chain)this.current_model.get(i);
            if (!chainID.equals(testchain.getName())) continue;
            retchain = testchain;
            break;
        }
        return retchain;
    }

    private Character convert_3code_1code(String code3) throws IllegalSymbolException {
        Symbol sym = this.threeLetter.parseToken(code3);
        String code1 = this.oneLetter.tokenizeSymbol(sym);
        return new Character(code1.charAt(0));
    }
}

