/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.biojava.bio.BioError;
import org.biojava.bio.gui.sequence.LayeredRenderer;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.bio.gui.sequence.SequenceRenderer;
import org.biojava.bio.gui.sequence.SequenceRendererWrapper;
import org.biojava.bio.gui.sequence.SequenceViewerEvent;
import org.biojava.bio.gui.sequence.SubSequenceRenderContext;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.FilterUtils;
import org.biojava.bio.seq.SimpleFeatureHolder;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.utils.AssertionFailure;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.cache.CacheMap;
import org.biojava.utils.cache.FixedSizeMap;

public class BumpedRenderer
extends SequenceRendererWrapper {
    private int leadingPixles;
    private int trailingPixles;
    private CacheMap contextCache = new FixedSizeMap(5);
    private Set flushers = new HashSet();

    public BumpedRenderer() {
    }

    public BumpedRenderer(SequenceRenderer renderer) {
        super(renderer);
    }

    public BumpedRenderer(SequenceRenderer renderer, int leading, int trailing) {
        super(renderer);
        this.leadingPixles = leading;
        this.trailingPixles = trailing;
    }

    public int getLeadingPixles() {
        return this.leadingPixles;
    }

    public void setLeadingPixles(int leading) {
        this.leadingPixles = leading;
    }

    public int getTrailingPixles() {
        return this.trailingPixles;
    }

    public void setTrailingPixles(int trailing) {
        this.trailingPixles = trailing;
    }

    protected boolean hasListeners() {
        return super.hasListeners();
    }

    protected ChangeSupport getChangeSupport(ChangeType ct) {
        return super.getChangeSupport(ct);
    }

    public double getDepth(SequenceRenderContext src) {
        List layers = this.layer(src);
        return LayeredRenderer.INSTANCE.getDepth(layers, Collections.nCopies(layers.size(), this.getRenderer()));
    }

    public double getMinimumLeader(SequenceRenderContext src) {
        List layers = this.layer(src);
        return LayeredRenderer.INSTANCE.getMinimumLeader(layers, Collections.nCopies(layers.size(), this.getRenderer()));
    }

    public double getMinimumTrailer(SequenceRenderContext src) {
        List layers = this.layer(src);
        return LayeredRenderer.INSTANCE.getMinimumTrailer(layers, Collections.nCopies(layers.size(), this.getRenderer()));
    }

    public void paint(Graphics2D g, SequenceRenderContext src) {
        List layers = this.layer(src);
        LayeredRenderer.INSTANCE.paint(g, layers, Collections.nCopies(layers.size(), this.getRenderer()));
    }

    public SequenceViewerEvent processMouseEvent(SequenceRenderContext src, MouseEvent me, List path) {
        path.add(this);
        List layers = this.layer(src);
        SequenceViewerEvent sve = LayeredRenderer.INSTANCE.processMouseEvent(layers, me, path, Collections.nCopies(layers.size(), this.getRenderer()));
        if (sve == null) {
            sve = new SequenceViewerEvent(this, null, src.graphicsToSequence(me.getPoint()), me, path);
        }
        return sve;
    }

    protected List layer(SequenceRenderContext src) {
        FeatureFilter filt = FilterUtils.overlapsLocation(src.getRange());
        CtxtFilt gopher = new CtxtFilt(src, filt, false);
        List layers = (List)this.contextCache.get(gopher);
        if (layers == null) {
            layers = this.doLayer(src, filt);
            this.contextCache.put(gopher, layers);
            CacheFlusher cf = new CacheFlusher(gopher);
            src.getSymbols().addChangeListener(cf, FeatureHolder.FEATURES);
            this.flushers.add(cf);
        }
        return layers;
    }

    protected List doLayer(SequenceRenderContext src, FeatureFilter filt) {
        FeatureHolder features = src.getFeatures();
        ArrayList<SimpleFeatureHolder> layers = new ArrayList<SimpleFeatureHolder>();
        ArrayList layerLocs = new ArrayList();
        int lead = (int)((double)this.leadingPixles / src.getScale());
        int trail = (int)((double)this.trailingPixles / src.getScale());
        Iterator fi = features.filter(filt, false).features();
        while (fi.hasNext()) {
            Feature f = (Feature)fi.next();
            try {
                Location fLoc = f.getLocation();
                fLoc = new RangeLocation(fLoc.getMin() - lead, fLoc.getMax() + trail);
                Iterator li = layerLocs.iterator();
                Iterator fhI = layers.iterator();
                SimpleFeatureHolder fhLayer = null;
                List<Location> listLayer = null;
                block4: while (li.hasNext()) {
                    List l = (List)li.next();
                    SimpleFeatureHolder fh = (SimpleFeatureHolder)fhI.next();
                    Iterator locI = l.iterator();
                    while (locI.hasNext()) {
                        Location loc = (Location)locI.next();
                        if (!loc.overlaps(fLoc)) continue;
                        continue block4;
                    }
                    listLayer = l;
                    fhLayer = fh;
                    break;
                }
                if (listLayer == null) {
                    listLayer = new ArrayList<Location>();
                    layerLocs.add(listLayer);
                    fhLayer = new SimpleFeatureHolder();
                    layers.add(fhLayer);
                }
                listLayer.add(fLoc);
                fhLayer.addFeature(f);
            }
            catch (ChangeVetoException cve) {
                throw new BioError("Pants", cve);
            }
            catch (Throwable t) {
                throw new AssertionFailure("Could not bump feature: " + f, t);
            }
        }
        ArrayList<SubSequenceRenderContext> contexts = new ArrayList<SubSequenceRenderContext>(layers.size());
        Iterator i = layers.iterator();
        while (i.hasNext()) {
            FeatureHolder layer = (FeatureHolder)i.next();
            contexts.add(new SubSequenceRenderContext(src, null, layer, null));
        }
        return contexts;
    }

    private class CtxtFilt {
        private SequenceRenderContext src;
        private FeatureFilter filter;
        private boolean recurse;

        public CtxtFilt(SequenceRenderContext src, FeatureFilter filter, boolean recurse) {
            this.src = src;
            this.filter = filter;
            this.recurse = recurse;
        }

        public boolean equals(Object o) {
            if (!(o instanceof CtxtFilt)) {
                return false;
            }
            CtxtFilt that = (CtxtFilt)o;
            return this.src.equals(that.src) && this.filter.equals(that.filter) && this.recurse == that.recurse;
        }

        public int hashCode() {
            return this.src.hashCode() ^ this.filter.hashCode();
        }
    }

    private class CacheFlusher
    implements ChangeListener {
        private CtxtFilt ctxtFilt;

        public CacheFlusher(CtxtFilt ctxtFilt) {
            this.ctxtFilt = ctxtFilt;
        }

        public void preChange(ChangeEvent ce) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void postChange(ChangeEvent ce) {
            BumpedRenderer.this.contextCache.remove(this.ctxtFilt);
            BumpedRenderer.this.flushers.remove(this);
            if (BumpedRenderer.this.hasListeners()) {
                ChangeSupport cs;
                ChangeSupport changeSupport = cs = BumpedRenderer.this.getChangeSupport(SequenceRenderContext.LAYOUT);
                synchronized (changeSupport) {
                    ChangeEvent ce2 = new ChangeEvent(BumpedRenderer.this, SequenceRenderContext.LAYOUT);
                    cs.firePostChangeEvent(ce2);
                }
            }
        }
    }
}

