/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.util.Date;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class PatternOptionBuilder {
    public static final Class STRING_VALUE = String.class;
    public static final Class OBJECT_VALUE = Object.class;
    public static final Class NUMBER_VALUE = Number.class;
    public static final Class DATE_VALUE = Date.class;
    public static final Class CLASS_VALUE = Class.class;
    public static final Class EXISTING_FILE_VALUE = FileInputStream.class;
    public static final Class FILE_VALUE = File.class;
    public static final Class FILES_VALUE = File[].class;
    public static final Class URL_VALUE = URL.class;

    public static Object getValueClass(char ch) {
        if (ch == '@') {
            return OBJECT_VALUE;
        }
        if (ch == ':') {
            return STRING_VALUE;
        }
        if (ch == '%') {
            return NUMBER_VALUE;
        }
        if (ch == '+') {
            return CLASS_VALUE;
        }
        if (ch == '#') {
            return DATE_VALUE;
        }
        if (ch == '<') {
            return EXISTING_FILE_VALUE;
        }
        if (ch == '>') {
            return FILE_VALUE;
        }
        if (ch == '*') {
            return FILES_VALUE;
        }
        if (ch == '/') {
            return URL_VALUE;
        }
        return null;
    }

    public static boolean isValueCode(char ch) {
        return ch == '@' || ch == ':' || ch == '%' || ch == '+' || ch == '#' || ch == '<' || ch == '>' || ch == '*' || ch == '/' || ch == '!';
    }

    public static Options parsePattern(String pattern) {
        int sz = pattern.length();
        int opt = 32;
        int ch = 32;
        boolean required = false;
        Object type = null;
        Options options = new Options();
        for (int i = 0; i < sz; ++i) {
            ch = pattern.charAt(i);
            if (!PatternOptionBuilder.isValueCode((char)ch)) {
                if (opt != 32) {
                    OptionBuilder.hasArg(type != null);
                    OptionBuilder.isRequired(required);
                    OptionBuilder.withType(type);
                    options.addOption(OptionBuilder.create((char)opt));
                    required = false;
                    type = null;
                    opt = 32;
                }
                opt = ch;
                continue;
            }
            if (ch == 33) {
                required = true;
                continue;
            }
            type = PatternOptionBuilder.getValueClass((char)ch);
        }
        if (opt != 32) {
            OptionBuilder.hasArg(type != null);
            OptionBuilder.isRequired(required);
            OptionBuilder.withType(type);
            options.addOption(OptionBuilder.create((char)opt));
        }
        return options;
    }
}

