/*
 * Decompiled with CFR 0.152.
 */
package jas.util;

import jas.util.BooleanCommandTarget;
import jas.util.CommandInvocationException;
import jas.util.CommandTarget;
import jas.util.CommandTargetManager;
import jas.util.JASCheckboxState;
import jas.util.JASState;
import jas.util.SimpleCommandTarget;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Observable;

public class CommandProcessor
extends Observable {
    private static final Class[] noArg = new Class[0];
    private static final Object[] noArgs = new Object[0];
    private static final Class[] boolArg = new Class[]{Boolean.TYPE};
    private static final Class[] simpleEnableArg = new Class[]{JASState.class};
    private static final Class[] booleanEnableArg = new Class[]{JASCheckboxState.class};

    protected String translate(String command) {
        if (command.endsWith("...")) {
            command = command.substring(0, command.length() - 3);
        }
        int i = command.indexOf(" ");
        while (i >= 0) {
            command = command.substring(0, i) + command.substring(i + 1);
            i = command.indexOf(" ");
        }
        return command;
    }

    protected void setChanged() {
        super.setChanged();
        this.notifyObservers();
    }

    protected void setManager(CommandTargetManager m) {
    }

    protected CommandTarget acceptCommand(String command) {
        String t = this.translate(command);
        String c = "on" + t;
        String e = "enable" + t;
        try {
            Method me;
            Method mc = this.getClass().getMethod(c, noArg);
            try {
                me = this.getClass().getMethod(e, simpleEnableArg);
            }
            catch (NoSuchMethodException x) {
                me = null;
            }
            try {
                if (me == null) {
                    me = this.getClass().getMethod(e, booleanEnableArg);
                }
            }
            catch (NoSuchMethodException x) {
                me = null;
            }
            return new SimpleTarget(mc, me);
        }
        catch (NoSuchMethodException x) {
            try {
                Method me;
                Method mc = this.getClass().getMethod(c, boolArg);
                try {
                    me = this.getClass().getMethod(e, booleanEnableArg);
                }
                catch (NoSuchMethodException x2) {
                    me = null;
                }
                return new BooleanTarget(mc, me);
            }
            catch (NoSuchMethodException x3) {
                return null;
            }
        }
    }

    protected void invoke(Method method, Object[] args) throws IllegalAccessException, InvocationTargetException {
        method.invoke((Object)this, args);
    }

    protected void invokeEnable(Method method, Object[] args) throws IllegalAccessException, InvocationTargetException {
        this.invoke(method, args);
    }

    protected void invokeCommand(Method method, Object[] args) throws IllegalAccessException, InvocationTargetException {
        this.invoke(method, args);
    }

    protected void invokeCommand(SimpleTarget t) {
        try {
            t.doCommand();
        }
        catch (CommandInvocationException x) {
            System.err.println("Error during command invocation: " + x.getTargetException());
        }
    }

    protected void invokeCommand(BooleanTarget t, boolean arg) {
        try {
            t.doCommand(arg);
        }
        catch (CommandInvocationException x) {
            System.err.println("Error during command invocation: " + x.getTargetException());
        }
    }

    protected class BooleanTarget
    implements BooleanCommandTarget {
        private Method m_command;
        private Method m_enable;

        BooleanTarget(Method command, Method enable) {
            this.m_command = command;
            this.m_enable = enable;
        }

        public void invoke(boolean arg) {
            CommandProcessor.this.invokeCommand(this, arg);
        }

        public void enable(JASState state) {
            if (this.m_enable == null) {
                state.setEnabled(true);
            } else {
                try {
                    Object[] args = new Object[]{(JASCheckboxState)state};
                    CommandProcessor.this.invokeEnable(this.m_enable, args);
                }
                catch (IllegalAccessException x) {
                    state.setEnabled(false);
                }
                catch (InvocationTargetException x) {
                    state.setEnabled(false);
                }
            }
        }

        public void doCommand(boolean arg) throws CommandInvocationException {
            try {
                Object[] args = new Object[]{new Boolean(arg)};
                CommandProcessor.this.invokeCommand(this.m_command, args);
            }
            catch (IllegalAccessException x) {
                throw new RuntimeException("IllegalAccessException during command invocation");
            }
            catch (InvocationTargetException x) {
                throw new CommandInvocationException(x.getTargetException());
            }
        }

        public CommandProcessor getProcessor() {
            return CommandProcessor.this;
        }
    }

    protected class SimpleTarget
    implements SimpleCommandTarget {
        private Method m_command;
        private Method m_enable;

        SimpleTarget(Method command, Method enable) {
            this.m_command = command;
            this.m_enable = enable;
        }

        public void invoke() {
            CommandProcessor.this.invokeCommand(this);
        }

        public void doCommand() throws CommandInvocationException {
            try {
                CommandProcessor.this.invokeCommand(this.m_command, noArgs);
            }
            catch (IllegalAccessException x) {
                throw new RuntimeException("IllegalAccessException during command invocation");
            }
            catch (InvocationTargetException x) {
                throw new CommandInvocationException(x.getTargetException());
            }
        }

        public void enable(JASState state) {
            if (this.m_enable == null) {
                state.setEnabled(true);
            } else {
                try {
                    Object[] args = new Object[]{state};
                    CommandProcessor.this.invokeEnable(this.m_enable, args);
                }
                catch (IllegalAccessException x) {
                    state.setEnabled(false);
                }
                catch (InvocationTargetException x) {
                    state.setEnabled(false);
                }
            }
        }

        public CommandProcessor getProcessor() {
            return CommandProcessor.this;
        }
    }
}

