/*
 * Decompiled with CFR 0.152.
 */
package fing.model;

import fing.model.FNode;
import fing.model.FingNodeDepot;
import giny.model.Node;
import giny.model.RootGraph;

final class NodeDepository
implements FingNodeDepot {
    private static final int INITIAL_CAPACITY = 11;
    private Node[] m_nodeStack = new Node[11];
    private int m_size = 0;

    NodeDepository() {
    }

    public Node getNode(RootGraph root, int index, String id) {
        FNode returnThis = this.m_size == 0 ? new FNode() : (FNode)this.m_nodeStack[--this.m_size];
        returnThis.m_rootGraph = root;
        returnThis.m_rootGraphIndex = index;
        returnThis.m_identifier = id;
        return returnThis;
    }

    public void recycleNode(Node node) {
        if (node == null) {
            return;
        }
        try {
            this.m_nodeStack[this.m_size] = node;
            ++this.m_size;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            int newArrSize = (int)Math.min(Integer.MAX_VALUE, (long)this.m_nodeStack.length * 2L + 1L);
            if (newArrSize == this.m_nodeStack.length) {
                throw new IllegalStateException("unable to allocate large enough array");
            }
            Node[] newArr = new Node[newArrSize];
            System.arraycopy(this.m_nodeStack, 0, newArr, 0, this.m_nodeStack.length);
            this.m_nodeStack = newArr;
            this.m_nodeStack[this.m_size++] = node;
        }
    }
}

