/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui.icon;

import cytoscape.visual.ArrowShape;
import cytoscape.visual.ui.icon.VisualPropertyIcon;
import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class ArrowIcon
extends VisualPropertyIcon {
    private static final Stroke EDGE_STROKE = new BasicStroke(6.0f, 2, 0);
    private static final Stroke EDGE_STROKE_SMALL = new BasicStroke(4.0f, 2, 0);
    private static final int DEF_L_PAD = 15;
    private final ArrowShape arrow;

    public ArrowIcon(ArrowShape arrow, int width) {
        super(arrow.getShape(), width, 32, arrow.getName(), DEFAULT_ICON_COLOR);
        this.arrow = arrow;
    }

    public ArrowIcon(ArrowShape arrow) {
        this(arrow, 96);
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(this.color);
        g2d.translate(this.leftPad, this.bottomPad);
        if (this.shape == null) {
            if (this.width < 20 || this.height < 20) {
                g2d.translate(-this.leftPad, -this.bottomPad);
                g2d.setStroke(EDGE_STROKE_SMALL);
                g2d.drawLine(3, c.getHeight() / 2, this.width / 2 + 10, c.getHeight() / 2);
            } else {
                g2d.setStroke(EDGE_STROKE);
                g2d.drawLine(15, c.getHeight() / 2, this.width / 2 + 10, c.getHeight() / 2);
            }
            return;
        }
        AffineTransform af = new AffineTransform();
        Rectangle2D bound = this.shape.getBounds2D();
        double minx = bound.getMinX();
        double miny = bound.getMinY();
        Shape newShape = this.shape;
        if (minx < 0.0) {
            af.setToTranslation(Math.abs(minx), 0.0);
            newShape = af.createTransformedShape(newShape);
        }
        if (miny < 0.0) {
            af.setToTranslation(0.0, Math.abs(miny));
            newShape = af.createTransformedShape(newShape);
        }
        double shapeWidth = newShape.getBounds2D().getWidth();
        double shapeHeight = newShape.getBounds2D().getHeight();
        double originalXYRatio = shapeWidth / shapeHeight;
        double xRatio = (double)(this.width / 3) / shapeWidth;
        double yRatio = (double)this.height / shapeHeight;
        af.setToScale(xRatio * originalXYRatio, yRatio);
        newShape = af.createTransformedShape(newShape);
        af.setToTranslation((double)this.width * 0.8 - newShape.getBounds2D().getCenterX(), (double)((this.height + 20) / 2) - newShape.getBounds2D().getCenterY());
        newShape = af.createTransformedShape(newShape);
        g2d.fill(newShape);
        if (this.arrow.renderEdgeWithArrow()) {
            if (this.width < 20 || this.height < 20) {
                g2d.translate(-this.leftPad, -this.bottomPad);
                g2d.setStroke(EDGE_STROKE_SMALL);
                g2d.drawLine(3, c.getHeight() / 2, this.width / 2 + 10, c.getHeight() / 2);
            } else {
                g2d.setStroke(EDGE_STROKE);
                g2d.drawLine(15, (this.height + 20) / 2, (int)newShape.getBounds2D().getCenterX() - 2, (this.height + 20) / 2);
            }
        }
    }
}

