/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui;

import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.logger.CyLogger;
import cytoscape.visual.VisualMappingManager;
import cytoscape.visual.VisualPropertyDependency;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.converter.ValueToStringConverterManager;
import cytoscape.visual.ui.BypassHack;
import giny.model.GraphObject;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class VizMapBypass {
    protected Frame parent = Cytoscape.getDesktop();
    protected VisualMappingManager vmm = Cytoscape.getVisualMappingManager();
    protected CyAttributes attrs = null;
    protected GraphObject graphObj = null;
    protected CyLogger logger = CyLogger.getLogger(VizMapBypass.class);

    VizMapBypass() {
    }

    protected abstract List<String> getBypassNames();

    protected void addResetAllMenuItem(JMenu menu) {
        JMenuItem jmi = new JMenuItem(new AbstractAction("Reset All"){

            public void actionPerformed(ActionEvent e) {
                List<String> names = VizMapBypass.this.getBypassNames();
                String id = VizMapBypass.this.graphObj.getIdentifier();
                for (String attrName : names) {
                    if (!VizMapBypass.this.attrs.hasAttribute(id, attrName)) continue;
                    VizMapBypass.this.attrs.deleteAttribute(id, attrName);
                }
                Cytoscape.getCurrentNetworkView().redrawGraph(false, true);
                BypassHack.finished();
            }
        });
        menu.add(jmi);
    }

    protected void addResetMenuItem(JMenu menu, final VisualPropertyType type) {
        JMenuItem jmi = new JMenuItem(new AbstractAction("[ Reset " + type.getName() + " ]"){

            public void actionPerformed(ActionEvent e) {
                String id = VizMapBypass.this.graphObj.getIdentifier();
                if (VizMapBypass.this.attrs.hasAttribute(id, type.getBypassAttrName())) {
                    VizMapBypass.this.attrs.deleteAttribute(id, type.getBypassAttrName());
                }
                Cytoscape.getCurrentNetworkView().redrawGraph(false, true);
                BypassHack.finished();
            }
        });
        menu.add(jmi);
    }

    protected void addMenuItem(JMenu menu, final VisualPropertyType type) {
        JCheckBoxMenuItem jmi = new JCheckBoxMenuItem(new AbstractAction(type.getName()){

            public void actionPerformed(ActionEvent e) {
                Object obj = null;
                try {
                    obj = type.showDiscreteEditor();
                }
                catch (Exception ex) {
                    VizMapBypass.this.logger.warn("Unable to show descrete editor", ex);
                    obj = null;
                }
                if (obj == null) {
                    return;
                }
                String val = ValueToStringConverterManager.manager.toString(obj);
                VizMapBypass.this.attrs.setAttribute(VizMapBypass.this.graphObj.getIdentifier(), type.getBypassAttrName(), val);
                Cytoscape.getCurrentNetworkView().redrawGraph(false, true);
                BypassHack.finished();
            }
        });
        menu.add(jmi);
        VisualPropertyDependency dep = Cytoscape.getVisualMappingManager().getVisualStyle().getDependency();
        jmi.setEnabled(!type.getVisualProperty().constrained(dep));
        String attrString = this.attrs.getStringAttribute(this.graphObj.getIdentifier(), type.getBypassAttrName());
        if (attrString == null || attrString.length() == 0) {
            jmi.setSelected(false);
        } else {
            jmi.setSelected(true);
            this.addResetMenuItem(menu, type);
        }
    }
}

