/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.properties;

import cytoscape.Cytoscape;
import cytoscape.visual.LineStyle;
import cytoscape.visual.VisualPropertyDependency;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.properties.AbstractVisualProperty;
import cytoscape.visual.ui.icon.NodeIcon;
import giny.view.NodeView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Stroke;
import java.util.Map;
import javax.swing.Icon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeLineStyleProp
extends AbstractVisualProperty {
    @Override
    public VisualPropertyType getType() {
        return VisualPropertyType.NODE_LINE_STYLE;
    }

    @Override
    public Icon getIcon(final Object value) {
        NodeIcon icon = new NodeIcon(){

            public void paintIcon(Component c, Graphics g, int x, int y) {
                super.setColor(new Color(10, 10, 10, 0));
                super.paintIcon(c, g, x, y);
                float width = ((Number)VisualPropertyType.NODE_LINE_WIDTH.getDefault(Cytoscape.getVisualMappingManager().getVisualStyle())).floatValue();
                Stroke stroke = ((LineStyle)((Object)value)).getStroke(width);
                this.g2d.setStroke(stroke);
                this.g2d.setColor(Color.DARK_GRAY);
                this.g2d.translate(15, 4);
                this.g2d.draw(this.shape);
                this.g2d.translate(-15, -4);
                this.g2d.setFont(new Font("SansSerif", 1, 12));
                this.g2d.setColor(new Color(10, 10, 10, 45));
                this.g2d.drawString(value.toString(), c.getX() + 12, c.getHeight() / 2 + 3);
                this.g2d.setFont(new Font("SansSerif", 1, 12));
            }
        };
        return icon;
    }

    @Override
    public Map<Object, Icon> getIconSet() {
        return LineStyle.getIconSet();
    }

    @Override
    public void applyToNodeView(NodeView nv, Object o, VisualPropertyDependency dep) {
        if (o == null || nv == null) {
            return;
        }
        nv.setBorder(((LineStyle)((Object)o)).getStroke(nv.getBorderWidth()));
    }

    @Override
    public Object getDefaultAppearanceObject() {
        return LineStyle.SOLID;
    }
}

