/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.mappings.discrete;

import cytoscape.visual.converter.ValueToStringConverterManager;
import cytoscape.visual.mappings.MappingUtil;
import java.util.Properties;
import java.util.SortedMap;

public class DiscreteMappingWriter {
    private String attrName;
    private String baseKey;
    private SortedMap map;

    public DiscreteMappingWriter(String attrName, String baseKey, SortedMap map) {
        this.attrName = attrName;
        this.baseKey = baseKey;
        this.map = map;
    }

    public Properties getProperties() {
        Properties newProps = new Properties();
        if (this.attrName == null) {
            return newProps;
        }
        String contKey = this.baseKey + ".controller";
        newProps.setProperty(contKey, this.attrName);
        String contTypeKey = this.baseKey + ".controllerType";
        newProps.setProperty(contTypeKey, MappingUtil.getAttributeTypeString(this.baseKey, this.attrName));
        String mapKey = this.baseKey + ".map.";
        for (Object key : this.map.keySet()) {
            Object value = this.map.get(key);
            if (value == null) continue;
            String stringValue = ValueToStringConverterManager.manager.toString(value);
            newProps.setProperty(mapKey + key.toString(), stringValue);
        }
        return newProps;
    }
}

